/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.common.fs.inline.InLineFileSystem;
import org.apache.hudi.common.fs.inline.InMemoryFileSystem;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInLineFileSystemHFileInLining {
    private final Configuration inMemoryConf;
    private final Configuration inlineConf;
    private final int minBlockSize = 1024;
    private static final String LOCAL_FORMATTER = "%010d";
    private int maxRows = 100 + FileSystemTestUtils.RANDOM.nextInt(1000);
    private Path generatedPath;

    public TestInLineFileSystemHFileInLining() {
        this.inMemoryConf = new Configuration();
        this.inMemoryConf.set("fs.inmemfs.impl", InMemoryFileSystem.class.getName());
        this.inlineConf = new Configuration();
        this.inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
    }

    @AfterEach
    public void teardown() throws IOException {
        File filePath;
        if (this.generatedPath != null && (filePath = new File(this.generatedPath.toString().substring(this.generatedPath.toString().indexOf(58) + 1))).exists()) {
            FileSystemTestUtils.deleteFile(filePath);
        }
    }

    @Test
    public void testSimpleInlineFileSystem() throws IOException {
        int[] invalidRowIds;
        Path outerPath;
        Path outerInMemFSPath = FileSystemTestUtils.getRandomOuterInMemPath();
        this.generatedPath = outerPath = new Path("file" + outerInMemFSPath.toString().substring(outerInMemFSPath.toString().indexOf(58)));
        CacheConfig cacheConf = new CacheConfig(this.inMemoryConf);
        FSDataOutputStream fout = this.createFSOutput(outerInMemFSPath, this.inMemoryConf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(1024).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.inMemoryConf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).withComparator(new KeyValue.KVComparator()).create();
        this.writeRecords(writer);
        fout.close();
        byte[] inlineBytes = this.getBytesToInline(outerInMemFSPath);
        long startOffset = this.generateOuterFile(outerPath, inlineBytes);
        long inlineLength = inlineBytes.length;
        Path inlinePath = FileSystemTestUtils.getPhantomFile(outerPath, startOffset, inlineLength);
        InLineFileSystem inlineFileSystem = (InLineFileSystem)inlinePath.getFileSystem(this.inlineConf);
        FSDataInputStream fin = inlineFileSystem.open(inlinePath);
        HFile.Reader reader = HFile.createReader((FileSystem)inlineFileSystem, (Path)inlinePath, (CacheConfig)cacheConf, (Configuration)this.inlineConf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(true, false);
        scanner.seekTo();
        this.readAllRecords(scanner);
        Set<Integer> rowIdsToSearch = this.getRandomValidRowIds(10);
        for (int rowId : rowIdsToSearch) {
            Assertions.assertEquals((int)0, (int)scanner.seekTo((Cell)KeyValue.createKeyValueFromKey((byte[])this.getSomeKey(rowId))), (String)"location lookup failed");
            ByteBuffer readKey = scanner.getKey();
            Assertions.assertArrayEquals((byte[])this.getSomeKey(rowId), (byte[])Bytes.toBytes((ByteBuffer)readKey), (String)"seeked key does not match");
            scanner.seekTo((Cell)KeyValue.createKeyValueFromKey((byte[])this.getSomeKey(rowId)));
            ByteBuffer val1 = scanner.getValue();
            scanner.seekTo((Cell)KeyValue.createKeyValueFromKey((byte[])this.getSomeKey(rowId)));
            ByteBuffer val2 = scanner.getValue();
            Assertions.assertArrayEquals((byte[])Bytes.toBytes((ByteBuffer)val1), (byte[])Bytes.toBytes((ByteBuffer)val2));
        }
        for (int rowId : invalidRowIds = new int[]{-4, this.maxRows, this.maxRows + 1, this.maxRows + 120, this.maxRows + 160, this.maxRows + 1000}) {
            Assertions.assertNotEquals((int)0, (int)scanner.seekTo((Cell)KeyValue.createKeyValueFromKey((byte[])this.getSomeKey(rowId))), (String)"location lookup should have failed");
        }
        reader.close();
        fin.close();
        outerPath.getFileSystem(this.inMemoryConf).delete(outerPath, true);
    }

    private Set<Integer> getRandomValidRowIds(int count) {
        HashSet<Integer> rowIds = new HashSet<Integer>();
        while (rowIds.size() < count) {
            int index = FileSystemTestUtils.RANDOM.nextInt(this.maxRows);
            if (rowIds.contains(index)) continue;
            rowIds.add(index);
        }
        return rowIds;
    }

    private byte[] getSomeKey(int rowId) {
        KeyValue kv = new KeyValue(String.format(LOCAL_FORMATTER, rowId).getBytes(), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Long.MAX_VALUE, KeyValue.Type.Put);
        return kv.getKey();
    }

    private FSDataOutputStream createFSOutput(Path name, Configuration conf) throws IOException {
        return name.getFileSystem(conf).create(name);
    }

    private void writeRecords(HFile.Writer writer) throws IOException {
        this.writeSomeRecords(writer);
        writer.close();
    }

    private int writeSomeRecords(HFile.Writer writer) throws IOException {
        String value = "value";
        for (int i = 0; i < this.maxRows; ++i) {
            String key = String.format(LOCAL_FORMATTER, i);
            KeyValue kv = new KeyValue(Bytes.toBytes((String)key), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)(value + key)));
            writer.append((Cell)kv);
        }
        return this.maxRows;
    }

    private void readAllRecords(HFileScanner scanner) throws IOException {
        this.readAndCheckbytes(scanner, 0, this.maxRows);
    }

    private int readAndCheckbytes(HFileScanner scanner, int start, int n) throws IOException {
        int i;
        String value = "value";
        for (i = start; i < start + n; ++i) {
            ByteBuffer key = scanner.getKey();
            ByteBuffer val = scanner.getValue();
            String keyStr = String.format(LOCAL_FORMATTER, i);
            String valStr = value + keyStr;
            KeyValue kv = new KeyValue(Bytes.toBytes((String)keyStr), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)valStr));
            byte[] keyBytes = new KeyValue.KeyOnlyKeyValue(Bytes.toBytes((ByteBuffer)key), 0, Bytes.toBytes((ByteBuffer)key).length).getKey();
            Assertions.assertArrayEquals((byte[])kv.getKey(), (byte[])keyBytes, (String)("bytes for keys do not match " + keyStr + " " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))));
            byte[] valBytes = Bytes.toBytes((ByteBuffer)val);
            Assertions.assertArrayEquals((byte[])Bytes.toBytes((String)valStr), (byte[])valBytes, (String)("bytes for vals do not match " + valStr + " " + Bytes.toString((byte[])valBytes)));
            if (!scanner.next()) break;
        }
        Assertions.assertEquals((int)i, (int)(start + n - 1));
        return start + n;
    }

    private long generateOuterFile(Path outerPath, byte[] inlineBytes) throws IOException {
        FSDataOutputStream wrappedOut = outerPath.getFileSystem(this.inMemoryConf).create(outerPath, true);
        this.writeRandomBytes(wrappedOut, 10);
        long startOffset = wrappedOut.getPos();
        wrappedOut.write(inlineBytes);
        this.writeRandomBytes(wrappedOut, 5);
        wrappedOut.hsync();
        wrappedOut.close();
        return startOffset;
    }

    private byte[] getBytesToInline(Path outerInMemFSPath) throws IOException {
        InMemoryFileSystem inMemoryFileSystem = (InMemoryFileSystem)outerInMemFSPath.getFileSystem(this.inMemoryConf);
        return inMemoryFileSystem.getFileAsBytes();
    }

    private void writeRandomBytes(FSDataOutputStream writer, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            writer.writeUTF(UUID.randomUUID().toString());
        }
    }
}

