/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.functional;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestHoodieLogFormatAppendFailure {
    private static File baseDir;
    private static MiniDFSCluster cluster;

    @BeforeAll
    public static void setUpClass() throws IOException {
        baseDir = new File("/tmp/" + UUID.randomUUID().toString());
        FileUtil.fullyDelete((File)baseDir);
        Configuration conf = new Configuration();
        conf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.client.socket-timeout", 3000);
        cluster = new MiniDFSCluster.Builder(conf).checkExitOnShutdown(true).numDataNodes(4).build();
    }

    @AfterAll
    public static void tearDownClass() {
        cluster.shutdown();
        FileUtil.fullyDelete((File)baseDir);
    }

    @Test
    @Timeout(value=60L)
    public void testFailedToGetAppendStreamFromHDFSNameNode() throws IOException, URISyntaxException, InterruptedException, TimeoutException {
        String uuid = UUID.randomUUID().toString();
        Path localPartitionPath = new Path("/tmp/");
        DistributedFileSystem fs = cluster.getFileSystem();
        Path testPath = new Path(localPartitionPath, uuid);
        fs.mkdirs(testPath);
        List<IndexedRecord> records = SchemaTestUtil.generateTestRecords(0, 10);
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(2);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, "100");
        header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, SchemaTestUtil.getSimpleSchema().toString());
        HoodieAvroDataBlock dataBlock = new HoodieAvroDataBlock(records, header);
        HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(testPath).withFileExtension(".archive").withFileId("commits.archive").overBaseCommit("").withFs((FileSystem)fs).build();
        writer = writer.appendBlock((HoodieLogBlock)dataBlock);
        int logFileVersion = writer.getLogFile().getLogVersion();
        Path logFilePath = writer.getLogFile().getPath();
        writer.close();
        DFSTestUtil.waitReplication((FileSystem)fs, (Path)logFilePath, (short)3);
        LocatedBlocks lbs = cluster.getFileSystem().getClient().getNamenode().getBlockLocations("/tmp/" + uuid + "/" + logFilePath.getName(), 0L, Long.MAX_VALUE);
        ArrayList dnsOfCluster = cluster.getDataNodes();
        DatanodeInfo[] dnsWithLocations = lbs.getLastLocatedBlock().getLocations();
        for (DataNode dn : dnsOfCluster) {
            for (DatanodeInfo loc : dnsWithLocations) {
                if (!dn.getDatanodeId().equals((Object)loc)) continue;
                dn.shutdown();
                cluster.stopDataNode(dn.getDisplayName());
                DFSTestUtil.waitForDatanodeDeath((DataNode)dn);
            }
        }
        DFSTestUtil.waitReplication((FileSystem)fs, (Path)logFilePath, (short)0);
        writer = HoodieLogFormat.newWriterBuilder().onParentPath(testPath).withFileExtension(".archive").withFileId("commits.archive").overBaseCommit("").withFs((FileSystem)fs).build();
        header = new HashMap();
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_PREVIOUS_BLOCK.ordinal()));
        writer.appendBlock((HoodieLogBlock)new HoodieCommandBlock(header));
        Assertions.assertNotEquals((int)writer.getLogFile().getLogVersion(), (int)logFileVersion);
    }
}

