/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieWriteStat {
    @Test
    public void testSetPaths() {
        String instantTime = HoodieActiveTimeline.COMMIT_FORMATTER.format(new Date());
        String basePathString = "/data/tables/some-hoodie-table";
        String partitionPathString = "2017/12/31";
        String fileName = UUID.randomUUID().toString();
        String writeToken = "1-0-1";
        Path basePath = new Path(basePathString);
        Path partitionPath = new Path(basePath, partitionPathString);
        Path finalizeFilePath = new Path(partitionPath, FSUtils.makeDataFileName((String)instantTime, (String)writeToken, (String)fileName));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setPath(basePath, finalizeFilePath);
        Assertions.assertEquals((Object)finalizeFilePath, (Object)new Path(basePath, writeStat.getPath()));
        writeStat = new HoodieWriteStat();
        writeStat.setPath(basePath, finalizeFilePath);
        Assertions.assertEquals((Object)finalizeFilePath, (Object)new Path(basePath, writeStat.getPath()));
        Assertions.assertNull((Object)writeStat.getTempPath());
    }
}

