/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestOverwriteNonDefaultsWithLatestAvroPayload {
    private Schema schema;

    @BeforeEach
    public void setUp() throws Exception {
        this.schema = Schema.createRecord(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("partition", Schema.create((Schema.Type)Schema.Type.STRING), "", (Object)""), new Schema.Field("ts", Schema.create((Schema.Type)Schema.Type.LONG), "", null), new Schema.Field("_hoodie_is_deleted", Schema.create((Schema.Type)Schema.Type.BOOLEAN), "", (Object)false), new Schema.Field("city", Schema.create((Schema.Type)Schema.Type.STRING), "", (Object)"NY")));
    }

    @Test
    public void testActiveRecords() throws IOException {
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition1");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        record1.put("city", (Object)"NY0");
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"2");
        record2.put("partition", (Object)"");
        record2.put("ts", (Object)1L);
        record2.put("_hoodie_is_deleted", (Object)false);
        record2.put("city", (Object)"NY");
        GenericData.Record record3 = new GenericData.Record(this.schema);
        record3.put("id", (Object)"2");
        record3.put("partition", (Object)"partition1");
        record3.put("ts", (Object)1L);
        record3.put("_hoodie_is_deleted", (Object)false);
        record3.put("city", (Object)"NY0");
        OverwriteNonDefaultsWithLatestAvroPayload payload1 = new OverwriteNonDefaultsWithLatestAvroPayload((GenericRecord)record1, (Comparable)Integer.valueOf(1));
        OverwriteNonDefaultsWithLatestAvroPayload payload2 = new OverwriteNonDefaultsWithLatestAvroPayload((GenericRecord)record2, (Comparable)Integer.valueOf(2));
        Assertions.assertEquals((Object)payload1.preCombine((OverwriteWithLatestAvroPayload)payload2), (Object)payload2);
        Assertions.assertEquals((Object)payload2.preCombine((OverwriteWithLatestAvroPayload)payload1), (Object)payload2);
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema).get());
        Assertions.assertEquals((Object)record2, (Object)payload2.getInsertValue(this.schema).get());
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)record2, this.schema).get(), (Object)record1);
        Assertions.assertEquals((Object)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema).get(), (Object)record3);
    }

    @Test
    public void testDeletedRecord() throws IOException {
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        record1.put("city", (Object)"NY0");
        GenericData.Record delRecord1 = new GenericData.Record(this.schema);
        delRecord1.put("id", (Object)"2");
        delRecord1.put("partition", (Object)"partition1");
        delRecord1.put("ts", (Object)1L);
        delRecord1.put("_hoodie_is_deleted", (Object)true);
        delRecord1.put("city", (Object)"NY0");
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition0");
        record2.put("ts", (Object)0L);
        record2.put("_hoodie_is_deleted", (Object)true);
        record2.put("city", (Object)"NY0");
        OverwriteNonDefaultsWithLatestAvroPayload payload1 = new OverwriteNonDefaultsWithLatestAvroPayload((GenericRecord)record1, (Comparable)Integer.valueOf(1));
        OverwriteNonDefaultsWithLatestAvroPayload payload2 = new OverwriteNonDefaultsWithLatestAvroPayload((GenericRecord)delRecord1, (Comparable)Integer.valueOf(2));
        Assertions.assertEquals((Object)payload1.preCombine((OverwriteWithLatestAvroPayload)payload2), (Object)payload2);
        Assertions.assertEquals((Object)payload2.preCombine((OverwriteWithLatestAvroPayload)payload1), (Object)payload2);
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema).get());
        Assertions.assertFalse((boolean)payload2.getInsertValue(this.schema).isPresent());
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)delRecord1, this.schema).get(), (Object)record2);
        Assertions.assertFalse((boolean)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema).isPresent());
    }
}

