/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieTableMetaClient
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void checkMetadata() {
        Assertions.assertEquals((Object)"raw_trips", (Object)this.metaClient.getTableConfig().getTableName(), (String)"Table name should be raw_trips");
        Assertions.assertEquals((Object)this.basePath, (Object)this.metaClient.getBasePath(), (String)"Basepath should be the one assigned");
        Assertions.assertEquals((Object)(this.basePath + "/.hoodie"), (Object)this.metaClient.getMetaPath(), (String)"Metapath should be ${basepath}/.hoodie");
    }

    @Test
    public void checkSerDe() {
        HoodieTableMetaClient deseralizedMetaClient = HoodieTestUtils.serializeDeserialize(this.metaClient, HoodieTableMetaClient.class);
        Assertions.assertNotNull((Object)deseralizedMetaClient);
        HoodieActiveTimeline commitTimeline = deseralizedMetaClient.getActiveTimeline();
        HoodieInstant instant = new HoodieInstant(true, "commit", "1");
        commitTimeline.createNewInstant(instant);
        commitTimeline.saveAsComplete(instant, Option.of((Object)"test-detail".getBytes()));
        commitTimeline = commitTimeline.reload();
        HoodieInstant completedInstant = HoodieTimeline.getCompletedInstant((HoodieInstant)instant);
        Assertions.assertEquals((Object)completedInstant, commitTimeline.getInstants().findFirst().get(), (String)"Commit should be 1 and completed");
        Assertions.assertArrayEquals((byte[])"test-detail".getBytes(), (byte[])((byte[])commitTimeline.getInstantDetails(completedInstant).get()), (String)"Commit value should be \"test-detail\"");
    }

    @Test
    public void checkCommitTimeline() {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty(), (String)"Should be empty commit timeline");
        HoodieInstant instant = new HoodieInstant(true, "commit", "1");
        activeTimeline.createNewInstant(instant);
        activeTimeline.saveAsComplete(instant, Option.of((Object)"test-detail".getBytes()));
        activeTimeline = this.metaClient.getActiveTimeline();
        activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty(), (String)"Should be empty commit timeline");
        HoodieInstant completedInstant = HoodieTimeline.getCompletedInstant((HoodieInstant)instant);
        activeTimeline = activeTimeline.reload();
        activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertFalse((boolean)activeCommitTimeline.empty(), (String)"Should be the 1 commit we made");
        Assertions.assertEquals((Object)completedInstant, activeCommitTimeline.getInstants().findFirst().get(), (String)"Commit should be 1");
        Assertions.assertArrayEquals((byte[])"test-detail".getBytes(), (byte[])((byte[])activeCommitTimeline.getInstantDetails(completedInstant).get()), (String)"Commit value should be \"test-detail\"");
    }

    @Test
    public void testEquals() throws IOException {
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType());
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType());
        Assertions.assertEquals((Object)metaClient1, (Object)metaClient1);
        Assertions.assertEquals((Object)metaClient1, (Object)metaClient2);
        Assertions.assertNotEquals((Object)metaClient1, null);
        Assertions.assertNotEquals((Object)metaClient1, (Object)new Object());
    }

    @Test
    public void testToString() throws IOException {
        HoodieTableMetaClient metaClient1 = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType());
        HoodieTableMetaClient metaClient2 = HoodieTestUtils.init(this.tempDir.toAbsolutePath().toString(), this.getTableType());
        Assertions.assertEquals((Object)metaClient1.toString(), (Object)metaClient2.toString());
        Assertions.assertNotEquals((Object)metaClient1.toString(), (Object)new Object().toString());
    }
}

