/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTimelineUtils
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @Test
    public void testGetPartitions() throws IOException {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        String olderPartition = "0";
        for (int i = 1; i <= 5; ++i) {
            String ts = i + "";
            HoodieInstant instant = new HoodieInstant(true, "commit", ts);
            activeTimeline.createNewInstant(instant);
            activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, ts, ts, 2, Collections.emptyMap())));
            HoodieInstant cleanInstant = new HoodieInstant(true, "clean", ts);
            activeTimeline.createNewInstant(cleanInstant);
            activeTimeline.saveAsComplete(cleanInstant, this.getCleanMetadata(olderPartition, ts));
        }
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((int)5, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("0", "2", "3", "4", "5"));
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertEquals((int)4, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("0", "2", "3", "4"));
        partitions = TimelineUtils.getPartitionsWritten((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((int)4, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4", "5"));
        partitions = TimelineUtils.getPartitionsWritten((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4"));
    }

    @Test
    public void testGetPartitionsUnpartitioned() throws IOException {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        String partitionPath = "";
        for (int i = 1; i <= 5; ++i) {
            String ts = i + "";
            HoodieInstant instant = new HoodieInstant(true, "commit", ts);
            activeTimeline.createNewInstant(instant);
            activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, partitionPath, ts, 2, Collections.emptyMap())));
            HoodieInstant cleanInstant = new HoodieInstant(true, "clean", ts);
            activeTimeline.createNewInstant(cleanInstant);
            activeTimeline.saveAsComplete(cleanInstant, this.getCleanMetadata(partitionPath, ts));
        }
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertTrue((boolean)partitions.isEmpty());
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertTrue((boolean)partitions.isEmpty());
    }

    @Test
    public void testRestoreInstants() throws Exception {
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        for (int i = 1; i <= 5; ++i) {
            String ts = i + "";
            HoodieInstant instant = new HoodieInstant(true, "restore", ts);
            activeTimeline.createNewInstant(instant);
            activeTimeline.saveAsComplete(instant, Option.of((Object)this.getRestoreMetadata(this.basePath, ts, ts, 2, "commit")));
        }
        this.metaClient.reloadActiveTimeline();
        List partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsAfter("1", 10));
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4", "5"));
        partitions = TimelineUtils.getAffectedPartitions((HoodieTimeline)this.metaClient.getActiveTimeline().findInstantsInRange("1", "4"));
        Assertions.assertEquals((Object)partitions, Arrays.asList("2", "3", "4"));
    }

    @Test
    public void testGetExtraMetadata() throws Exception {
        String extraMetadataKey = "test_key";
        String extraMetadataValue1 = "test_value1";
        HoodieActiveTimeline activeTimeline = this.metaClient.getActiveTimeline();
        HoodieTimeline activeCommitTimeline = activeTimeline.getCommitTimeline();
        Assertions.assertTrue((boolean)activeCommitTimeline.empty());
        Assertions.assertFalse((boolean)TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey).isPresent());
        String ts = "0";
        HoodieInstant instant = new HoodieInstant(true, "commit", ts);
        activeTimeline.createNewInstant(instant);
        activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, ts, ts, 2, Collections.emptyMap())));
        ts = "1";
        instant = new HoodieInstant(true, "commit", ts);
        activeTimeline.createNewInstant(instant);
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put(extraMetadataKey, extraMetadataValue1);
        activeTimeline.saveAsComplete(instant, Option.of((Object)this.getCommitMetadata(this.basePath, ts, ts, 2, extraMetadata)));
        this.metaClient.reloadActiveTimeline();
        Option extraLatestValue = TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey);
        Assertions.assertTrue((boolean)extraLatestValue.isPresent());
        Assertions.assertEquals((Object)extraMetadataValue1, (Object)extraLatestValue.get());
        Assertions.assertFalse((boolean)TimelineUtils.getExtraMetadataFromLatest((HoodieTableMetaClient)this.metaClient, (String)"unknownKey").isPresent());
        Map extraMetadataEntries = TimelineUtils.getAllExtraMetadataForKey((HoodieTableMetaClient)this.metaClient, (String)extraMetadataKey);
        Assertions.assertEquals((int)2, (int)extraMetadataEntries.size());
        Assertions.assertFalse((boolean)((Option)extraMetadataEntries.get("0")).isPresent());
        Assertions.assertTrue((boolean)((Option)extraMetadataEntries.get("1")).isPresent());
        Assertions.assertEquals((Object)extraMetadataValue1, (Object)((Option)extraMetadataEntries.get("1")).get());
    }

    private byte[] getRestoreMetadata(String basePath, String partition, String commitTs, int count, String actionType) throws IOException {
        ArrayList<HoodieRollbackMetadata> rollbackM = new ArrayList<HoodieRollbackMetadata>();
        rollbackM.add(this.getRollbackMetadataInstance(basePath, partition, commitTs, count, actionType));
        ArrayList<HoodieInstant> rollbackInstants = new ArrayList<HoodieInstant>();
        rollbackInstants.add(new HoodieInstant(false, commitTs, actionType));
        HoodieRestoreMetadata metadata = TimelineMetadataUtils.convertRestoreMetadata((String)commitTs, (long)200L, rollbackInstants, (Map)CollectionUtils.createImmutableMap((Object)commitTs, rollbackM));
        return (byte[])TimelineMetadataUtils.serializeRestoreMetadata((HoodieRestoreMetadata)metadata).get();
    }

    private HoodieRollbackMetadata getRollbackMetadataInstance(String basePath, String partition, String commitTs, int count, String actionType) {
        ArrayList<String> deletedFiles = new ArrayList<String>();
        for (int i = 1; i <= count; ++i) {
            deletedFiles.add("file-" + i);
        }
        ArrayList<HoodieInstant> rollbacks = new ArrayList<HoodieInstant>();
        rollbacks.add(new HoodieInstant(false, actionType, commitTs));
        HoodieRollbackStat rollbackStat = new HoodieRollbackStat(partition, deletedFiles, Collections.emptyList(), Collections.emptyMap());
        ArrayList<HoodieRollbackStat> rollbackStats = new ArrayList<HoodieRollbackStat>();
        rollbackStats.add(rollbackStat);
        return TimelineMetadataUtils.convertRollbackMetadata((String)commitTs, (Option)Option.empty(), rollbacks, rollbackStats);
    }

    private byte[] getCommitMetadata(String basePath, String partition, String commitTs, int count, Map<String, String> extraMetadata) throws IOException {
        HoodieCommitMetadata commit = new HoodieCommitMetadata();
        for (int i = 1; i <= count; ++i) {
            HoodieWriteStat stat = new HoodieWriteStat();
            stat.setFileId(i + "");
            stat.setPartitionPath(Paths.get(basePath, partition).toString());
            stat.setPath(commitTs + "." + i + ".parquet");
            commit.addWriteStat(partition, stat);
        }
        for (Map.Entry<String, String> extraEntries : extraMetadata.entrySet()) {
            commit.addMetadata(extraEntries.getKey(), extraEntries.getValue());
        }
        return commit.toJsonString().getBytes(StandardCharsets.UTF_8);
    }

    private Option<byte[]> getCleanMetadata(String partition, String time) throws IOException {
        HashMap<String, HoodieCleanPartitionMetadata> partitionToFilesCleaned = new HashMap<String, HoodieCleanPartitionMetadata>();
        ArrayList<String> filesDeleted = new ArrayList<String>();
        filesDeleted.add("file-" + partition + "-" + time + "1");
        filesDeleted.add("file-" + partition + "-" + time + "2");
        HoodieCleanPartitionMetadata partitionMetadata = HoodieCleanPartitionMetadata.newBuilder().setPartitionPath(partition).setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setFailedDeleteFiles(Collections.emptyList()).setDeletePathPatterns(Collections.emptyList()).setSuccessDeleteFiles(filesDeleted).build();
        partitionToFilesCleaned.putIfAbsent(partition, partitionMetadata);
        HoodieCleanMetadata cleanMetadata = HoodieCleanMetadata.newBuilder().setVersion(Integer.valueOf(1)).setTimeTakenInMillis(100L).setTotalFilesDeleted(1).setStartCleanTime(time).setEarliestCommitToRetain(time).setPartitionMetadata(partitionToFilesCleaned).build();
        return TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)cleanMetadata);
    }
}

