/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.testutils.Assertions;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieActiveTimeline
extends HoodieCommonTestHarness {
    private HoodieActiveTimeline timeline;

    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @Test
    public void testLoadingInstantsFromFiles() throws IOException {
        HoodieInstant instant1 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "1");
        HoodieInstant instant2 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "3");
        HoodieInstant instant3 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "5");
        HoodieInstant instant4 = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "8");
        HoodieInstant instant1Complete = new HoodieInstant(false, "commit", "1");
        HoodieInstant instant2Complete = new HoodieInstant(false, "commit", "3");
        HoodieInstant instant3Complete = new HoodieInstant(false, "commit", "5");
        HoodieInstant instant4Complete = new HoodieInstant(false, "commit", "8");
        HoodieInstant instant5 = new HoodieInstant(true, "commit", "9");
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.createNewInstant(instant1);
        this.timeline.transitionRequestedToInflight(instant1, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant1.getAction(), instant1.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant2);
        this.timeline.transitionRequestedToInflight(instant2, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant2.getAction(), instant2.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant3);
        this.timeline.transitionRequestedToInflight(instant3, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant3.getAction(), instant3.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant4);
        this.timeline.transitionRequestedToInflight(instant4, Option.empty());
        this.timeline.saveAsComplete(new HoodieInstant(true, instant4.getAction(), instant4.getTimestamp()), Option.empty());
        this.timeline.createNewInstant(instant5);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)this.timeline.countInstants(), (String)"Total instants should be 5");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), this.timeline.getInstants(), "Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete, instant5), this.timeline.getCommitTimeline().getInstants(), "Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant1Complete, instant2Complete, instant3Complete, instant4Complete), this.timeline.getCommitTimeline().filterCompletedInstants().getInstants(), "Check the instants stream");
        Assertions.assertStreamEquals(Stream.of(instant5), this.timeline.getCommitTimeline().filterPendingExcludingCompaction().getInstants(), "Check the instants stream");
        this.metaClient = HoodieTableMetaClient.initTableType((Configuration)this.metaClient.getHadoopConf(), (String)this.metaClient.getBasePath(), (HoodieTableType)this.metaClient.getTableType(), (String)this.metaClient.getTableConfig().getTableName(), (String)this.metaClient.getArchivePath(), (String)this.metaClient.getTableConfig().getPayloadClass(), (Integer)TimelineLayoutVersion.VERSION_0);
        HoodieInstant instant6 = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "9");
        byte[] dummy = new byte[5];
        HoodieActiveTimeline oldTimeline = new HoodieActiveTimeline(new HoodieTableMetaClient(this.metaClient.getHadoopConf(), this.metaClient.getBasePath(), true, this.metaClient.getConsistencyGuardConfig(), Option.of((Object)new TimelineLayoutVersion(TimelineLayoutVersion.VERSION_0))));
        oldTimeline.saveToCompactionRequested(instant6, Option.of((Object)dummy));
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getFs().exists(new Path(this.metaClient.getMetaAuxiliaryPath(), instant6.getFileName())));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)((byte[])this.timeline.readCompactionPlanAsBytes(instant6).get()).length);
        this.metaClient.getFs().delete(new Path(this.metaClient.getMetaAuxiliaryPath(), instant6.getFileName()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getFs().exists(new Path(this.metaClient.getMetaAuxiliaryPath(), instant6.getFileName())));
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)((byte[])this.timeline.readCompactionPlanAsBytes(instant6).get()).length);
    }

    @Test
    public void testTimelineOperationsBasic() {
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.firstInstant());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.nthInstant(5));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.nthInstant(-1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Option.empty(), (Object)this.timeline.lastInstant());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(new HoodieInstant(false, "commit", "01")));
    }

    @Test
    public void testTimelineOperations() {
        this.timeline = new MockHoodieTimeline(Stream.of("01", "03", "05", "07", "09", "11", "13", "15", "17", "19"), Stream.of("21", "23"));
        Assertions.assertStreamEquals(Stream.of("05", "07", "09", "11"), this.timeline.getCommitTimeline().filterCompletedInstants().findInstantsInRange("04", "11").getInstants().map(HoodieInstant::getTimestamp), "findInstantsInRange should return 4 instants");
        Assertions.assertStreamEquals(Stream.of("09", "11"), this.timeline.getCommitTimeline().filterCompletedInstants().findInstantsAfter("07", 2).getInstants().map(HoodieInstant::getTimestamp), "findInstantsAfter 07 should return 2 instants");
        Assertions.assertStreamEquals(Stream.of("01", "03", "05"), this.timeline.getCommitTimeline().filterCompletedInstants().findInstantsBefore("07").getInstants().map(HoodieInstant::getTimestamp), "findInstantsBefore 07 should return 3 instants");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.getCommitTimeline().filterPendingExcludingCompaction().empty());
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)this.timeline.countInstants());
        HoodieTimeline activeCommitTimeline = this.timeline.getCommitTimeline().filterCompletedInstants();
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)activeCommitTimeline.countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"01", (Object)((HoodieInstant)activeCommitTimeline.firstInstant().get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"11", (Object)((HoodieInstant)activeCommitTimeline.nthInstant(5).get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"19", (Object)((HoodieInstant)activeCommitTimeline.lastInstant().get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"09", (Object)((HoodieInstant)activeCommitTimeline.nthFromLastInstant(5).get()).getTimestamp());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)activeCommitTimeline.containsInstant(new HoodieInstant(false, "commit", "09")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)activeCommitTimeline.isBeforeTimelineStarts("02"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)activeCommitTimeline.isBeforeTimelineStarts("00"));
    }

    @Test
    public void testTimelineGetOperations() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        Supplier<Stream> sup = allInstants::stream;
        this.timeline = new HoodieActiveTimeline(this.metaClient, true);
        this.timeline.setInstants(allInstants);
        BiConsumer<HoodieTimeline, Set> checkTimeline = (timeline, actions) -> {
            ((Stream)sup.get()).filter(i -> actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(i)));
            ((Stream)sup.get()).filter(i -> !actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(i)));
        };
        checkTimeline.accept(this.timeline.getCommitsTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "replacecommit"}));
        checkTimeline.accept((HoodieTimeline)this.timeline.getCommitsAndCompactionTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "compaction", "replacecommit"}));
        checkTimeline.accept(this.timeline.getCommitTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "replacecommit"}));
        checkTimeline.accept(this.timeline.getDeltaCommitTimeline(), Collections.singleton("deltacommit"));
        checkTimeline.accept(this.timeline.getCleanerTimeline(), Collections.singleton("clean"));
        checkTimeline.accept(this.timeline.getRollbackTimeline(), Collections.singleton("rollback"));
        checkTimeline.accept(this.timeline.getRestoreTimeline(), Collections.singleton("restore"));
        checkTimeline.accept(this.timeline.getSavePointTimeline(), Collections.singleton("savepoint"));
        checkTimeline.accept(this.timeline.getAllCommitsTimeline(), CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "clean", "compaction", "replacecommit", "savepoint", "rollback"}));
        Random rand = new Random();
        Set randomInstants = sup.get().filter(i -> rand.nextBoolean()).map(HoodieInstant::getAction).collect(Collectors.toSet());
        checkTimeline.accept(this.timeline.getTimelineOfActions(randomInstants), randomInstants);
    }

    @Test
    public void testTimelineInstantOperations() {
        this.timeline = new HoodieActiveTimeline(this.metaClient, true);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.timeline.countInstants(), (String)"No instant present");
        HoodieInstant commit = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "1");
        this.timeline.createNewInstant(commit);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        HoodieInstant inflight = this.timeline.revertToInflight(commit);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(commit));
        this.timeline.deleteInflight(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(commit));
        this.timeline.createNewInstant(commit);
        this.timeline.createNewInstant(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        this.timeline.deletePending(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        HoodieInstant compaction = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "2");
        this.timeline.createNewInstant(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.timeline.countInstants());
        this.timeline.deleteCompactionRequested(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.timeline.countInstants());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(commit));
        compaction = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "3");
        this.timeline.createNewInstant(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        inflight = this.timeline.transitionCompactionRequestedToInflight(compaction);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        compaction = this.timeline.revertCompactionInflightToRequested(inflight);
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        inflight = this.timeline.transitionCompactionRequestedToInflight(compaction);
        compaction = this.timeline.transitionCompactionInflightToComplete(inflight, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(compaction));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        HoodieInstant clean = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "4");
        this.timeline.saveToCleanRequested(clean, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(clean));
        inflight = this.timeline.transitionCleanRequestedToInflight(clean, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(clean));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(inflight));
        clean = this.timeline.transitionCleanInflightToComplete(inflight, Option.empty());
        this.timeline = this.timeline.reload();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(clean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsInstant(inflight));
        HoodieInstant srcInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "restore", "5");
        HoodieInstant otherInstant = HoodieTimeline.getRequestedInstant((HoodieInstant)srcInstant);
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "restore", "5"));
        otherInstant = HoodieTimeline.getCleanRequestedInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "5"));
        otherInstant = HoodieTimeline.getCleanInflightInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "5"));
        otherInstant = HoodieTimeline.getCompactionRequestedInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "5"));
        otherInstant = HoodieTimeline.getCompactionInflightInstant((String)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)otherInstant, (Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "5"));
        List<HoodieInstant> allInstants = this.getAllInstants();
        this.timeline = new HoodieActiveTimeline(this.metaClient, true);
        this.timeline.setInstants(allInstants);
        this.timeline.setInstants(allInstants);
        this.timeline.createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", "2"));
        allInstants.stream().map(HoodieInstant::getTimestamp).forEach(s -> org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsOrBeforeTimelineStarts(s)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsOrBeforeTimelineStarts("0"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.containsOrBeforeTimelineStarts(String.valueOf(System.currentTimeMillis() + 1000L)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.timeline.getTimelineHash().isEmpty());
    }

    @Test
    public void testCreateInstants() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        for (HoodieInstant instant : allInstants) {
            this.timeline.createNewInstant(instant);
        }
        this.timeline = this.timeline.reload();
        for (HoodieInstant instant : allInstants) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.timeline.containsInstant(instant));
        }
    }

    @Test
    public void testInstantFilenameOperations() {
        HoodieInstant instantRequested = new HoodieInstant(HoodieInstant.State.REQUESTED, "restore", "5");
        HoodieInstant instantInflight = new HoodieInstant(HoodieInstant.State.INFLIGHT, "restore", "5");
        HoodieInstant instantComplete = new HoodieInstant(HoodieInstant.State.COMPLETED, "restore", "5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.getCommitFromCommitFile((String)instantRequested.getFileName()), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.getCommitFromCommitFile((String)instantInflight.getFileName()), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.getCommitFromCommitFile((String)instantComplete.getFileName()), (Object)"5");
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.makeFileNameAsComplete((String)instantInflight.getFileName()), (Object)instantComplete.getFileName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTimeline.makeFileNameAsInflight((String)instantComplete.getFileName()), (Object)instantInflight.getFileName());
    }

    @Test
    public void testFiltering() {
        List<HoodieInstant> allInstants = this.getAllInstants();
        Supplier<Stream> sup = allInstants::stream;
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.setInstants(allInstants);
        Stream instants = this.timeline.getReverseOrderedInstants();
        List v1 = instants.collect(Collectors.toList());
        List v2 = sup.get().collect(Collectors.toList());
        Collections.reverse(v2);
        org.junit.jupiter.api.Assertions.assertEquals(v1, v2);
        BiConsumer<HoodieTimeline, Set> checkFilter = (timeline, states) -> {
            ((Stream)sup.get()).filter(i -> states.contains(i.getState())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(i)));
            ((Stream)sup.get()).filter(i -> !states.contains(i.getState())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(i)));
        };
        checkFilter.accept(this.timeline.filter(i -> false), new HashSet());
        checkFilter.accept(this.timeline.filterInflights(), Collections.singleton(HoodieInstant.State.INFLIGHT));
        checkFilter.accept(this.timeline.filterInflightsAndRequested(), CollectionUtils.createSet((Object[])new HoodieInstant.State[]{HoodieInstant.State.INFLIGHT, HoodieInstant.State.REQUESTED}));
        HoodieTimeline t1 = this.timeline.filterCompletedAndCompactionInstants();
        Set states2 = CollectionUtils.createSet((Object[])new HoodieInstant.State[]{HoodieInstant.State.COMPLETED});
        Set<String> actions = Collections.singleton("compaction");
        sup.get().filter(i -> states2.contains(i.getState()) || actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)t1.containsInstant(i)));
        sup.get().filter(i -> !states2.contains(i.getState()) && !actions.contains(i.getAction())).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)t1.containsInstant(i)));
        HoodieTimeline t2 = this.timeline.filterPendingCompactionTimeline();
        sup.get().filter(i -> i.getAction().equals("compaction")).forEach(i -> org.junit.jupiter.api.Assertions.assertTrue((boolean)t2.containsInstant(i)));
        sup.get().filter(i -> !i.getAction().equals("compaction")).forEach(i -> org.junit.jupiter.api.Assertions.assertFalse((boolean)t2.containsInstant(i)));
    }

    @Test
    public void testReplaceActionsTimeline() {
        int instantTime = 1;
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", String.format("%03d", instantTime++));
        allInstants.add(instant);
        instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", String.format("%03d", instantTime++));
        allInstants.add(instant);
        instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", String.format("%03d", instantTime++));
        allInstants.add(instant);
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        this.timeline.setInstants(allInstants);
        List validReplaceInstants = this.timeline.getCompletedReplaceTimeline().getInstants().collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)validReplaceInstants.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instant.getTimestamp(), (Object)((HoodieInstant)validReplaceInstants.get(0)).getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"replacecommit", (Object)((HoodieInstant)validReplaceInstants.get(0)).getAction());
    }

    private List<HoodieInstant> getAllInstants() {
        this.timeline = new HoodieActiveTimeline(this.metaClient);
        ArrayList<HoodieInstant> allInstants = new ArrayList<HoodieInstant>();
        long instantTime = 1L;
        for (HoodieInstant.State state : HoodieInstant.State.values()) {
            if (state == HoodieInstant.State.INVALID) continue;
            for (String action : HoodieTimeline.VALID_ACTIONS_IN_TIMELINE) {
                if (state == HoodieInstant.State.REQUESTED && (action.equals("savepoint") || action.equals("restore") || action.equals("rollback")) || state == HoodieInstant.State.INFLIGHT && action.equals("rollback") || state == HoodieInstant.State.COMPLETED && action.equals("rollback")) continue;
                if (state == HoodieInstant.State.COMPLETED && action.equals("compaction")) {
                    action = "commit";
                }
                allInstants.add(new HoodieInstant(state, action, String.format("%03d", instantTime++)));
            }
        }
        return allInstants;
    }
}

