/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimelineLayout {
    @Test
    public void testTimelineLayoutFilter() {
        List<HoodieInstant> rawInstants = Arrays.asList(new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "001"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "001"), new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001"), new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", "002"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", "002"), new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "002"), new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "003"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "003"), new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003"), new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "004"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "004"), new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", "005"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", "005"), new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "005"), new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", "006"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "006"), new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", "007"), new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", "007"));
        List layout0Instants = TimelineLayout.getLayout((TimelineLayoutVersion)new TimelineLayoutVersion(Integer.valueOf(0))).filterHoodieInstants(rawInstants.stream()).collect(Collectors.toList());
        Assertions.assertEquals(rawInstants, layout0Instants);
        List layout1Instants = TimelineLayout.getLayout((TimelineLayoutVersion)TimelineLayoutVersion.CURR_LAYOUT_VERSION).filterHoodieInstants(rawInstants.stream()).collect(Collectors.toList());
        Assertions.assertEquals((int)7, (int)layout1Instants.size());
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", "007")));
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", "006")));
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "005")));
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "004")));
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "003")));
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", "002")));
        Assertions.assertTrue((boolean)layout1Instants.contains(new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001")));
    }
}

