/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;

public class AvroBinaryTestPayload
implements HoodieRecordPayload {
    private final byte[] recordBytes;

    public AvroBinaryTestPayload(Option<GenericRecord> record) {
        this.recordBytes = record.isPresent() ? HoodieAvroUtils.avroToBytes((GenericRecord)((GenericRecord)record.get())) : new byte[0];
    }

    public HoodieRecordPayload preCombine(HoodieRecordPayload another) {
        return this;
    }

    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        return Option.of((Object)HoodieAvroUtils.bytesToAvro((byte[])this.recordBytes, (Schema)schema));
    }
}

