/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;

public class FileCreateUtils {
    private static final String WRITE_TOKEN = "1-0-1";

    public static String baseFileName(String instantTime, String fileId) {
        return FileCreateUtils.baseFileName(instantTime, fileId, HoodieFileFormat.PARQUET.getFileExtension());
    }

    public static String baseFileName(String instantTime, String fileId, String fileExtension) {
        return FSUtils.makeDataFileName((String)instantTime, (String)WRITE_TOKEN, (String)fileId, (String)fileExtension);
    }

    public static String logFileName(String instantTime, String fileId, int version) {
        return FileCreateUtils.logFileName(instantTime, fileId, version, HoodieFileFormat.HOODIE_LOG.getFileExtension());
    }

    public static String logFileName(String instantTime, String fileId, int version, String fileExtension) {
        return FSUtils.makeLogFileName((String)fileId, (String)fileExtension, (String)instantTime, (int)version, (String)WRITE_TOKEN);
    }

    public static String markerFileName(String instantTime, String fileId, IOType ioType) {
        return FileCreateUtils.markerFileName(instantTime, fileId, ioType, HoodieFileFormat.PARQUET.getFileExtension());
    }

    public static String markerFileName(String instantTime, String fileId, IOType ioType, String fileExtension) {
        return String.format("%s_%s_%s%s%s.%s", fileId, WRITE_TOKEN, instantTime, fileExtension, ".marker", ioType);
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        java.nio.file.Path parentPath = Paths.get(basePath, ".hoodie");
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            Files.createFile(metaFilePath, new FileAttribute[0]);
        }
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix, byte[] content) throws IOException {
        java.nio.file.Path parentPath = Paths.get(basePath, ".hoodie");
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            Files.write(metaFilePath, content, new OpenOption[0]);
        }
    }

    public static void createCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".commit");
    }

    public static void createRequestedCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".commit.requested");
    }

    public static void createInflightCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".inflight");
    }

    public static void createDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit");
    }

    public static void createRequestedDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit.requested");
    }

    public static void createInflightDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit.inflight");
    }

    public static void createReplaceCommit(String basePath, String instantTime, HoodieReplaceCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit", metadata.toJsonString().getBytes(StandardCharsets.UTF_8));
    }

    public static void createRequestedReplaceCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.requested");
    }

    public static void createInflightReplaceCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.inflight");
    }

    public static void createCleanFile(String basePath, String instantTime, HoodieCleanMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean", (byte[])TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)metadata).get());
    }

    public static void createRequestedCleanFile(String basePath, String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean.requested", (byte[])TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan).get());
    }

    public static void createInflightCleanFile(String basePath, String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean.inflight", (byte[])TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan).get());
    }

    private static void createAuxiliaryMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        java.nio.file.Path parentPath = Paths.get(basePath, HoodieTableMetaClient.AUXILIARYFOLDER_NAME);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            Files.createFile(metaFilePath, new FileAttribute[0]);
        }
    }

    public static void createRequestedCompaction(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createAuxiliaryMetaFile(basePath, instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION);
    }

    public static void createInflightCompaction(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createAuxiliaryMetaFile(basePath, instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION);
    }

    public static void createPartitionMetaFile(String basePath, String partitionPath) throws IOException {
        java.nio.file.Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path metaFilePath = parentPath.resolve(".hoodie_partition_metadata");
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            Files.createFile(metaFilePath, new FileAttribute[0]);
        }
    }

    public static void createBaseFile(String basePath, String partitionPath, String instantTime, String fileId) throws Exception {
        FileCreateUtils.createBaseFile(basePath, partitionPath, instantTime, fileId, 0L);
    }

    public static void createBaseFile(String basePath, String partitionPath, String instantTime, String fileId, long length) throws Exception {
        java.nio.file.Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path baseFilePath = parentPath.resolve(FileCreateUtils.baseFileName(instantTime, fileId));
        if (Files.notExists(baseFilePath, new LinkOption[0])) {
            Files.createFile(baseFilePath, new FileAttribute[0]);
        }
        new RandomAccessFile(baseFilePath.toFile(), "rw").setLength(length);
    }

    public static void createLogFile(String basePath, String partitionPath, String instantTime, String fileId, int version) throws Exception {
        FileCreateUtils.createLogFile(basePath, partitionPath, instantTime, fileId, version, 0);
    }

    public static void createLogFile(String basePath, String partitionPath, String instantTime, String fileId, int version, int length) throws Exception {
        java.nio.file.Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path logFilePath = parentPath.resolve(FileCreateUtils.logFileName(instantTime, fileId, version));
        if (Files.notExists(logFilePath, new LinkOption[0])) {
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        new RandomAccessFile(logFilePath.toFile(), "rw").setLength(length);
    }

    public static String createMarkerFile(String basePath, String partitionPath, String instantTime, String fileId, IOType ioType) throws IOException {
        java.nio.file.Path parentPath = Paths.get(basePath, HoodieTableMetaClient.TEMPFOLDER_NAME, instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        java.nio.file.Path markerFilePath = parentPath.resolve(FileCreateUtils.markerFileName(instantTime, fileId, ioType));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static long getTotalMarkerFileCount(String basePath, String partitionPath, String instantTime, IOType ioType) throws IOException {
        java.nio.file.Path parentPath = Paths.get(basePath, HoodieTableMetaClient.TEMPFOLDER_NAME, instantTime, partitionPath);
        if (Files.notExists(parentPath, new LinkOption[0])) {
            return 0L;
        }
        return Files.list(parentPath).filter(p -> p.getFileName().toString().endsWith(String.format("%s.%s", ".marker", ioType))).count();
    }

    public static Map<String, Long> getBaseFileCountsForPaths(String basePath, FileSystem fs, String ... paths) {
        HashMap<String, Long> toReturn = new HashMap<String, Long>();
        try {
            HoodieTableMetaClient metaClient = new HoodieTableMetaClient(fs.getConf(), basePath, true);
            for (String path : paths) {
                HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(metaClient, metaClient.getCommitsTimeline().filterCompletedInstants(), fs.globStatus(new Path(path)));
                toReturn.put(path, fileSystemView.getLatestBaseFiles().count());
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new HoodieException("Error reading hoodie table as a dataframe", (Throwable)e);
        }
    }
}

