/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieTestTable {
    protected final String basePath;
    protected final FileSystem fs;
    protected HoodieTableMetaClient metaClient;
    protected String currentInstantTime;

    protected HoodieTestTable(String basePath, FileSystem fs, HoodieTableMetaClient metaClient) {
        ValidationUtils.checkArgument((boolean)Objects.equals(basePath, metaClient.getBasePath()));
        ValidationUtils.checkArgument((boolean)Objects.equals(fs, metaClient.getRawFs()));
        this.basePath = basePath;
        this.fs = fs;
        this.metaClient = metaClient;
    }

    public static HoodieTestTable of(HoodieTableMetaClient metaClient) {
        return new HoodieTestTable(metaClient.getBasePath(), metaClient.getRawFs(), metaClient);
    }

    public static String makeNewCommitTime(int sequence) {
        return String.format("%09d", sequence);
    }

    public static String makeNewCommitTime() {
        return HoodieTestTable.makeNewCommitTime(Instant.now());
    }

    public static String makeNewCommitTime(Instant dateTime) {
        return HoodieActiveTimeline.COMMIT_FORMATTER.format(Date.from(dateTime));
    }

    public static List<String> makeIncrementalCommitTimes(int num) {
        return HoodieTestTable.makeIncrementalCommitTimes(num, 1);
    }

    public static List<String> makeIncrementalCommitTimes(int num, int firstOffsetSeconds) {
        Instant now = Instant.now();
        return IntStream.range(0, num).mapToObj(i -> HoodieTestTable.makeNewCommitTime(now.plus((long)(firstOffsetSeconds + i), ChronoUnit.SECONDS))).collect(Collectors.toList());
    }

    public HoodieTestTable addRequestedCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addRequestedDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addInflightCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addInflightDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightDeltaCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightCommit(this.basePath, instantTime);
        FileCreateUtils.createCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addDeltaCommit(String instantTime) throws Exception {
        FileCreateUtils.createRequestedDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightDeltaCommit(this.basePath, instantTime);
        FileCreateUtils.createDeltaCommit(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addReplaceCommit(String instantTime, HoodieReplaceCommitMetadata metadata) throws Exception {
        FileCreateUtils.createRequestedReplaceCommit(this.basePath, instantTime);
        FileCreateUtils.createInflightReplaceCommit(this.basePath, instantTime);
        FileCreateUtils.createReplaceCommit(this.basePath, instantTime, metadata);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addInflightClean(String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createRequestedCleanFile(this.basePath, instantTime, cleanerPlan);
        FileCreateUtils.createInflightCleanFile(this.basePath, instantTime, cleanerPlan);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addClean(String instantTime, HoodieCleanerPlan cleanerPlan, HoodieCleanMetadata metadata) throws IOException {
        FileCreateUtils.createRequestedCleanFile(this.basePath, instantTime, cleanerPlan);
        FileCreateUtils.createInflightCleanFile(this.basePath, instantTime, cleanerPlan);
        FileCreateUtils.createCleanFile(this.basePath, instantTime, metadata);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime) throws IOException {
        FileCreateUtils.createRequestedCompaction(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable addRequestedCompaction(String instantTime, HoodieCompactionPlan compactionPlan) throws IOException {
        HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime);
        this.metaClient.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
        return this.addRequestedCompaction(instantTime);
    }

    public HoodieTestTable addRequestedCompaction(String instantTime, FileSlice ... fileSlices) throws IOException {
        HoodieCompactionPlan plan = CompactionUtils.buildFromFileSlices(Arrays.stream(fileSlices).map(fs -> Pair.of((Object)fs.getPartitionPath(), (Object)fs)).collect(Collectors.toList()), (Option)Option.empty(), (Option)Option.empty());
        return this.addRequestedCompaction(instantTime, plan);
    }

    public HoodieTestTable addCompaction(String instantTime) throws IOException {
        FileCreateUtils.createRequestedCompaction(this.basePath, instantTime);
        FileCreateUtils.createInflightCompaction(this.basePath, instantTime);
        this.currentInstantTime = instantTime;
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        return this;
    }

    public HoodieTestTable forCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forDeltaCommit(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable forCompaction(String instantTime) {
        this.currentInstantTime = instantTime;
        return this;
    }

    public HoodieTestTable withPartitionMetaFiles(String ... partitionPaths) throws IOException {
        for (String partitionPath : partitionPaths) {
            FileCreateUtils.createPartitionMetaFile(this.basePath, partitionPath);
        }
        return this;
    }

    public HoodieTestTable withMarkerFile(String partitionPath, IOType ioType) throws IOException {
        return this.withMarkerFile(partitionPath, UUID.randomUUID().toString(), ioType);
    }

    public HoodieTestTable withMarkerFile(String partitionPath, String fileId, IOType ioType) throws IOException {
        FileCreateUtils.createMarkerFile(this.basePath, partitionPath, this.currentInstantTime, fileId, ioType);
        return this;
    }

    public HoodieTestTable withMarkerFiles(String partitionPath, int num, IOType ioType) throws IOException {
        String[] fileIds = (String[])IntStream.range(0, num).mapToObj(i -> UUID.randomUUID().toString()).toArray(String[]::new);
        return this.withMarkerFiles(partitionPath, fileIds, ioType);
    }

    public HoodieTestTable withMarkerFiles(String partitionPath, String[] fileIds, IOType ioType) throws IOException {
        for (String fileId : fileIds) {
            FileCreateUtils.createMarkerFile(this.basePath, partitionPath, this.currentInstantTime, fileId, ioType);
        }
        return this;
    }

    public Map<String, String> getFileIdsWithBaseFilesInPartitions(String ... partitions) throws Exception {
        HashMap<String, String> partitionFileIdMap = new HashMap<String, String>();
        for (String p : partitions) {
            String fileId = UUID.randomUUID().toString();
            FileCreateUtils.createBaseFile(this.basePath, p, this.currentInstantTime, fileId);
            partitionFileIdMap.put(p, fileId);
        }
        return partitionFileIdMap;
    }

    public HoodieTestTable withBaseFilesInPartitions(Map<String, String> partitionAndFileId) throws Exception {
        for (Map.Entry<String, String> pair : partitionAndFileId.entrySet()) {
            this.withBaseFilesInPartition(pair.getKey(), pair.getValue());
        }
        return this;
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, String ... fileIds) throws Exception {
        for (String f : fileIds) {
            FileCreateUtils.createBaseFile(this.basePath, partition, this.currentInstantTime, f);
        }
        return this;
    }

    public HoodieTestTable withBaseFilesInPartition(String partition, int ... lengths) throws Exception {
        for (int l : lengths) {
            String fileId = UUID.randomUUID().toString();
            FileCreateUtils.createBaseFile(this.basePath, partition, this.currentInstantTime, fileId, l);
        }
        return this;
    }

    public String getFileIdWithLogFile(String partitionPath) throws Exception {
        String fileId = UUID.randomUUID().toString();
        this.withLogFile(partitionPath, fileId);
        return fileId;
    }

    public HoodieTestTable withLogFile(String partitionPath, String fileId) throws Exception {
        return this.withLogFile(partitionPath, fileId, 0);
    }

    public HoodieTestTable withLogFile(String partitionPath, String fileId, int ... versions) throws Exception {
        for (int version : versions) {
            FileCreateUtils.createLogFile(this.basePath, partitionPath, this.currentInstantTime, fileId, version);
        }
        return this;
    }

    public boolean inflightCommitsExist(String ... instantTime) {
        return Arrays.stream(instantTime).allMatch(this::inflightCommitExists);
    }

    public boolean inflightCommitExists(String instantTime) {
        try {
            return this.fs.exists(this.getInflightCommitFilePath(instantTime));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean commitsExist(String ... instantTime) {
        return Arrays.stream(instantTime).allMatch(this::commitExists);
    }

    public boolean commitExists(String instantTime) {
        try {
            return this.fs.exists(this.getCommitFilePath(instantTime));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean baseFilesExist(Map<String, String> partitionAndFileId, String instantTime) {
        return partitionAndFileId.entrySet().stream().allMatch(entry -> {
            String partition = (String)entry.getKey();
            String fileId = (String)entry.getValue();
            return this.baseFileExists(partition, instantTime, fileId);
        });
    }

    public boolean baseFilesExist(String partition, String instantTime, String ... fileIds) {
        return Arrays.stream(fileIds).allMatch(f -> this.baseFileExists(partition, instantTime, (String)f));
    }

    public boolean baseFileExists(String partition, String instantTime, String fileId) {
        try {
            return this.fs.exists(new Path(Paths.get(this.basePath, partition, FileCreateUtils.baseFileName(instantTime, fileId)).toString()));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public boolean logFilesExist(String partition, String instantTime, String fileId, int ... versions) {
        return Arrays.stream(versions).allMatch(v -> this.logFileExists(partition, instantTime, fileId, v));
    }

    public boolean logFileExists(String partition, String instantTime, String fileId, int version) {
        try {
            return this.fs.exists(new Path(Paths.get(this.basePath, partition, FileCreateUtils.logFileName(instantTime, fileId, version)).toString()));
        }
        catch (IOException e) {
            throw new HoodieTestTableException(e);
        }
    }

    public Path getInflightCommitFilePath(String instantTime) {
        return new Path(Paths.get(this.basePath, ".hoodie", instantTime + ".inflight").toUri());
    }

    public Path getCommitFilePath(String instantTime) {
        return new Path(Paths.get(this.basePath, ".hoodie", instantTime + ".commit").toUri());
    }

    public Path getRequestedCompactionFilePath(String instantTime) {
        return new Path(Paths.get(this.basePath, HoodieTableMetaClient.AUXILIARYFOLDER_NAME, instantTime + HoodieTimeline.REQUESTED_COMPACTION_EXTENSION).toUri());
    }

    public Path getPartitionPath(String partition) {
        return new Path(Paths.get(this.basePath, partition).toUri());
    }

    public Path getBaseFilePath(String partition, String fileId) {
        return new Path(Paths.get(this.basePath, partition, this.getBaseFileNameById(fileId)).toUri());
    }

    public String getBaseFileNameById(String fileId) {
        return FileCreateUtils.baseFileName(this.currentInstantTime, fileId);
    }

    public FileStatus[] listAllBaseFiles() throws IOException {
        return this.listAllBaseFiles(HoodieFileFormat.PARQUET.getFileExtension());
    }

    public FileStatus[] listAllBaseFiles(String fileExtension) throws IOException {
        return (FileStatus[])FileSystemTestUtils.listRecursive(this.fs, new Path(this.basePath)).stream().filter(status -> status.getPath().getName().endsWith(fileExtension)).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllLogFiles() throws IOException {
        return this.listAllLogFiles(HoodieFileFormat.HOODIE_LOG.getFileExtension());
    }

    public FileStatus[] listAllLogFiles(String fileExtension) throws IOException {
        return (FileStatus[])FileSystemTestUtils.listRecursive(this.fs, new Path(this.basePath)).stream().filter(status -> status.getPath().getName().contains(fileExtension)).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllBaseAndLogFiles() throws IOException {
        return (FileStatus[])Stream.concat(Stream.of(this.listAllBaseFiles()), Stream.of(this.listAllLogFiles())).toArray(FileStatus[]::new);
    }

    public FileStatus[] listAllFilesInPartition(String partitionPath) throws IOException {
        return FileSystemTestUtils.listRecursive(this.fs, new Path(Paths.get(this.basePath, partitionPath).toString())).toArray(new FileStatus[0]);
    }

    public FileStatus[] listAllFilesInTempFolder() throws IOException {
        return FileSystemTestUtils.listRecursive(this.fs, new Path(Paths.get(this.basePath, HoodieTableMetaClient.TEMPFOLDER_NAME).toString())).toArray(new FileStatus[0]);
    }

    public static class HoodieTestTableException
    extends RuntimeException {
        public HoodieTestTableException(Throwable t) {
            super(t);
        }
    }
}

