/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SampleTestRecord
implements Serializable {
    private String _hoodie_commit_time;
    private String _hoodie_record_key;
    private String _hoodie_partition_path;
    private String _hoodie_file_name;
    private String _hoodie_commit_seqno;
    private String field1;
    private String field2;
    private String name;
    private Integer favoriteIntNumber;
    private Long favoriteNumber;
    private Float favoriteFloatNumber;
    private Double favoriteDoubleNumber;
    private Map<String, TestMapItemRecord> tags;
    private TestNestedRecord testNestedRecord;
    private String[] stringArray;

    public SampleTestRecord(String instantTime, int recordNumber, String fileId) {
        this._hoodie_commit_time = instantTime;
        this._hoodie_record_key = "key" + recordNumber;
        this._hoodie_partition_path = instantTime;
        this._hoodie_file_name = fileId;
        this._hoodie_commit_seqno = instantTime + recordNumber;
        String commitTimeSuffix = "@" + instantTime;
        int commitHashCode = instantTime.hashCode();
        this.field1 = "field" + recordNumber;
        this.field2 = "field" + recordNumber + commitTimeSuffix;
        this.name = "name" + recordNumber;
        this.favoriteIntNumber = recordNumber + commitHashCode;
        this.favoriteNumber = recordNumber + commitHashCode;
        this.favoriteFloatNumber = Float.valueOf((float)((double)(recordNumber + commitHashCode) / 1024.0));
        this.favoriteDoubleNumber = (double)(recordNumber + commitHashCode) / 1024.0;
        this.tags = new HashMap<String, TestMapItemRecord>();
        this.tags.put("mapItem1", new TestMapItemRecord("item" + recordNumber, "item" + recordNumber + commitTimeSuffix));
        this.tags.put("mapItem2", new TestMapItemRecord("item2" + recordNumber, "item2" + recordNumber + commitTimeSuffix));
        this.testNestedRecord = new TestNestedRecord(false, "UserId" + recordNumber + commitTimeSuffix);
        this.stringArray = new String[]{"stringArray0" + commitTimeSuffix, "stringArray1" + commitTimeSuffix};
    }

    public String toJsonString() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    class TestNestedRecord
    implements Serializable {
        private boolean isAdmin;
        private String userId;

        TestNestedRecord(boolean isAdmin, String userId) {
            this.isAdmin = isAdmin;
            this.userId = userId;
        }
    }

    class TestMapItemRecord
    implements Serializable {
        private String item1;
        private String item2;

        TestMapItemRecord(String item1, String item2) {
            this.item1 = item1;
            this.item2 = item2;
        }
    }
}

