/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.SampleTestRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;

public final class SchemaTestUtil {
    private static final String RESOURCE_SAMPLE_DATA = "/sample.data";

    public static Schema getSimpleSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/simple-test.avsc"));
    }

    public static List<IndexedRecord> generateTestRecords(int from, int limit) throws IOException, URISyntaxException {
        return SchemaTestUtil.toRecords(SchemaTestUtil.getSimpleSchema(), SchemaTestUtil.getSimpleSchema(), from, limit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<IndexedRecord> toRecords(Schema writerSchema, Schema readerSchema, int from, int limit) throws IOException, URISyntaxException {
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        URI resource = SchemaTestUtil.class.getResource(RESOURCE_SAMPLE_DATA).toURI();
        Path dataPath = resource.toString().contains("!") ? SchemaTestUtil.uriToPath(resource) : Paths.get(SchemaTestUtil.class.getResource(RESOURCE_SAMPLE_DATA).toURI());
        try (Stream<String> stream = Files.lines(dataPath);){
            List<IndexedRecord> list = stream.skip(from).limit(limit).map(s -> {
                try {
                    return (IndexedRecord)reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(writerSchema, s));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Could not read data from /sample.data", e);
                }
            }).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read data from /sample.data", e);
        }
    }

    public static Path uriToPath(URI uri) throws IOException {
        FileSystem fs;
        HashMap env = new HashMap();
        String[] array = uri.toString().split("!");
        try {
            fs = FileSystems.getFileSystem(URI.create(array[0]));
        }
        catch (FileSystemNotFoundException e) {
            fs = FileSystems.newFileSystem(URI.create(array[0]), env);
        }
        return fs.getPath(array[1], new String[0]);
    }

    public static List<IndexedRecord> generateHoodieTestRecords(int from, int limit) throws IOException, URISyntaxException {
        List<IndexedRecord> records = SchemaTestUtil.generateTestRecords(from, limit);
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        Schema hoodieFieldsSchema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        return records.stream().map(s -> HoodieAvroUtils.rewriteRecord((GenericRecord)((GenericRecord)s), (Schema)hoodieFieldsSchema)).map(p -> {
            p.put("_hoodie_record_key", (Object)UUID.randomUUID().toString());
            p.put("_hoodie_partition_path", (Object)"0000/00/00");
            p.put("_hoodie_commit_time", (Object)instantTime);
            return p;
        }).collect(Collectors.toList());
    }

    public static List<HoodieRecord> generateHoodieTestRecords(int from, int limit, Schema schema) throws IOException, URISyntaxException {
        List<IndexedRecord> records = SchemaTestUtil.generateTestRecords(from, limit);
        return records.stream().map(s -> HoodieAvroUtils.rewriteRecord((GenericRecord)((GenericRecord)s), (Schema)schema)).map(p -> SchemaTestUtil.convertToHoodieRecords((IndexedRecord)p, UUID.randomUUID().toString(), "000/00/00")).collect(Collectors.toList());
    }

    private static HoodieRecord convertToHoodieRecords(IndexedRecord iRecord, String key, String partitionPath) {
        return new HoodieRecord(new HoodieKey(key, partitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)iRecord))));
    }

    public static List<IndexedRecord> updateHoodieTestRecords(List<String> oldRecordKeys, List<IndexedRecord> newRecords, String instantTime) {
        return newRecords.stream().map(p -> {
            ((GenericRecord)p).put("_hoodie_record_key", oldRecordKeys.remove(0));
            ((GenericRecord)p).put("_hoodie_partition_path", (Object)"0000/00/00");
            ((GenericRecord)p).put("_hoodie_commit_time", (Object)instantTime);
            return p;
        }).collect(Collectors.toList());
    }

    public static List<HoodieRecord> generateHoodieTestRecordsWithoutHoodieMetadata(int from, int limit) throws IOException, URISyntaxException {
        List<IndexedRecord> iRecords = SchemaTestUtil.generateTestRecords(from, limit);
        return iRecords.stream().map(r -> new HoodieRecord(new HoodieKey(UUID.randomUUID().toString(), "0000/00/00"), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)r))))).collect(Collectors.toList());
    }

    public static List<HoodieRecord> updateHoodieTestRecordsWithoutHoodieMetadata(List<HoodieRecord> oldRecords, Schema schema, String fieldNameToUpdate, String newValue) {
        return oldRecords.stream().map(r -> {
            try {
                GenericRecord rec = (GenericRecord)r.getData().getInsertValue(schema).get();
                rec.put(fieldNameToUpdate, (Object)newValue);
                return new HoodieRecord(r.getKey(), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)rec)));
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to get data from hoodie record", io);
            }
        }).collect(Collectors.toList());
    }

    public static Schema getEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/simple-test-evolved.avsc"));
    }

    public static List<IndexedRecord> generateEvolvedTestRecords(int from, int limit) throws IOException, URISyntaxException {
        return SchemaTestUtil.toRecords(SchemaTestUtil.getSimpleSchema(), SchemaTestUtil.getEvolvedSchema(), from, limit);
    }

    public static Schema getComplexEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/complex-test-evolved.avsc"));
    }

    public static Schema getTimestampEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(SchemaTestUtil.class.getResourceAsStream("/timestamp-test-evolved.avsc"));
    }

    public static GenericRecord generateAvroRecordFromJson(Schema schema, int recordNumber, String instantTime, String fileId) throws IOException {
        SampleTestRecord record = new SampleTestRecord(instantTime, recordNumber, fileId);
        MercifulJsonConverter converter = new MercifulJsonConverter();
        return converter.convert(record.toJsonString(), schema);
    }

    public static Schema getSchemaFromResource(Class<?> clazz, String name, boolean withHoodieMetadata) {
        try {
            Schema schema = new Schema.Parser().parse(clazz.getResourceAsStream(name));
            return withHoodieMetadata ? HoodieAvroUtils.addMetadataFields((Schema)schema) : schema;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to get schema from resource `%s` for class `%s`", name, clazz.getName()));
        }
    }

    public static Schema getSchemaFromResource(Class<?> clazz, String name) {
        return SchemaTestUtil.getSchemaFromResource(clazz, name, false);
    }
}

