/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.minicluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;

public class ZookeeperTestService {
    private static final Logger LOG = LogManager.getLogger(ZookeeperTestService.class);
    private static final int TICK_TIME = 2000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private Configuration hadoopConf;
    private String workDir = Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]).toFile().getAbsolutePath();
    private Integer clientPort = 2828;
    private String bindIP = "127.0.0.1";
    private Boolean clean = false;
    private int tickTime = 0;
    private NIOServerCnxnFactory standaloneServerFactory;
    private ZooKeeperServer zooKeeperServer;
    private boolean started = false;

    public ZookeeperTestService(Configuration config) throws IOException {
        this.hadoopConf = config;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public ZooKeeperServer start() throws IOException, InterruptedException {
        Objects.requireNonNull(this.workDir, "The localBaseFsLocation must be set before starting cluster.");
        ZookeeperTestService.setupTestEnv();
        this.stop();
        File dir = new File(this.workDir, "zookeeper").getAbsoluteFile();
        this.recreateDir(dir, this.clean);
        int tickTimeToUse = this.tickTime > 0 ? this.tickTime : 2000;
        this.zooKeeperServer = new ZooKeeperServer(dir, dir, tickTimeToUse);
        this.standaloneServerFactory = new NIOServerCnxnFactory();
        LOG.info((Object)("Zookeeper force binding to: " + this.bindIP));
        this.standaloneServerFactory.configure(new InetSocketAddress(this.bindIP, (int)this.clientPort), 1000);
        this.standaloneServerFactory.startup(this.zooKeeperServer);
        String serverHostname = this.bindIP.equals("0.0.0.0") ? "localhost" : this.bindIP;
        if (!ZookeeperTestService.waitForServerUp(serverHostname, this.clientPort, 30000L)) {
            throw new IOException("Waiting for startup of standalone server");
        }
        this.started = true;
        LOG.info((Object)("Zookeeper Minicluster service started on client port: " + this.clientPort));
        return this.zooKeeperServer;
    }

    public void stop() throws IOException {
        if (!this.started) {
            return;
        }
        this.standaloneServerFactory.shutdown();
        if (!ZookeeperTestService.waitForServerDown(this.clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.started = false;
        this.standaloneServerFactory = null;
        this.zooKeeperServer = null;
        LOG.info((Object)"Zookeeper Minicluster service shut down.");
    }

    private void recreateDir(File dir, boolean clean) throws IOException {
        if (dir.exists() && clean) {
            FileUtil.fullyDelete((File)dir);
        } else if (dir.exists() && !clean) {
            return;
        }
        try {
            dir.mkdirs();
        }
        catch (SecurityException e) {
            throw new IOException("creating dir: " + dir, e);
        }
    }

    private static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
    }

    private static boolean waitForServerDown(int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try (Socket sock = new Socket("localhost", port);){
                OutputStream outstream = sock.getOutputStream();
                outstream.write("stat".getBytes());
                outstream.flush();
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitForServerUp(String hostname, int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = new Socket(hostname, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    InputStreamReader isr = new InputStreamReader(sock.getInputStream());
                    reader = new BufferedReader(isr);
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Object)("server " + hostname + ":" + port + " not up " + e));
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

