/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCommitUtils {
    @Test
    public void testCommitMetadataCreation() {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        writeStats.add(this.createWriteStat("p1", "f1"));
        writeStats.add(this.createWriteStat("p2", "f2"));
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add("f0");
        partitionToReplaceFileIds.put("p1", replacedFileIds);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT, (String)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (String)"deltacommit");
        Assertions.assertFalse((boolean)(commitMetadata instanceof HoodieReplaceCommitMetadata));
        Assertions.assertEquals((int)2, (int)commitMetadata.getPartitionToWriteStats().size());
        Assertions.assertEquals((Object)"f1", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p1")).get(0)).getFileId());
        Assertions.assertEquals((Object)"f2", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p2")).get(0)).getFileId());
        Assertions.assertEquals((Object)WriteOperationType.INSERT, (Object)commitMetadata.getOperationType());
        Assertions.assertEquals((Object)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (Object)commitMetadata.getMetadata("schema"));
    }

    @Test
    public void testReplaceMetadataCreation() {
        ArrayList<HoodieWriteStat> writeStats = new ArrayList<HoodieWriteStat>();
        writeStats.add(this.createWriteStat("p1", "f1"));
        writeStats.add(this.createWriteStat("p2", "f2"));
        HashMap partitionToReplaceFileIds = new HashMap();
        ArrayList<String> replacedFileIds = new ArrayList<String>();
        replacedFileIds.add("f0");
        partitionToReplaceFileIds.put("p1", replacedFileIds);
        HoodieCommitMetadata commitMetadata = CommitUtils.buildMetadata(writeStats, partitionToReplaceFileIds, (Option)Option.empty(), (WriteOperationType)WriteOperationType.INSERT, (String)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (String)"replacecommit");
        Assertions.assertTrue((boolean)(commitMetadata instanceof HoodieReplaceCommitMetadata));
        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)commitMetadata;
        Assertions.assertEquals((int)1, (int)replaceCommitMetadata.getPartitionToReplaceFileIds().size());
        Assertions.assertEquals((Object)"f0", ((List)replaceCommitMetadata.getPartitionToReplaceFileIds().get("p1")).get(0));
        Assertions.assertEquals((int)2, (int)commitMetadata.getPartitionToWriteStats().size());
        Assertions.assertEquals((Object)"f1", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p1")).get(0)).getFileId());
        Assertions.assertEquals((Object)"f2", (Object)((HoodieWriteStat)((List)commitMetadata.getPartitionToWriteStats().get("p2")).get(0)).getFileId());
        Assertions.assertEquals((Object)WriteOperationType.INSERT, (Object)commitMetadata.getOperationType());
        Assertions.assertEquals((Object)"{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}", (Object)commitMetadata.getMetadata("schema"));
    }

    private HoodieWriteStat createWriteStat(String partition, String fileId) {
        HoodieWriteStat writeStat1 = new HoodieWriteStat();
        writeStat1.setPartitionPath(partition);
        writeStat1.setFileId(fileId);
        return writeStat1;
    }
}

