/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionPlanMigrator;
import org.apache.hudi.common.testutils.CompactionTestUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCompactionUtils
extends HoodieCommonTestHarness {
    private static String TEST_WRITE_TOKEN = "1-0-1";
    private static final Map<String, Double> METRICS = new HashMap<String, Double>(){
        {
            this.put("key1", 1.0);
            this.put("key2", 3.0);
        }
    };
    private Function<Pair<String, FileSlice>, Map<String, Double>> metricsCaptureFn = partitionFileSlice -> METRICS;

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testUpgradeDowngrade() {
        Pair<List<Pair<String, FileSlice>>, HoodieCompactionPlan> inputAndPlan = this.buildCompactionPlan();
        this.testFileSlicesCompactionPlanEquality((List)inputAndPlan.getKey(), (HoodieCompactionPlan)inputAndPlan.getValue());
        CompactionPlanMigrator migrator = new CompactionPlanMigrator(this.metaClient);
        HoodieCompactionPlan plan = (HoodieCompactionPlan)inputAndPlan.getRight();
        System.out.println("Plan=" + plan.getOperations());
        Assertions.assertEquals((Integer)CompactionUtils.LATEST_COMPACTION_METADATA_VERSION, (Integer)plan.getVersion());
        HoodieCompactionPlan oldPlan = (HoodieCompactionPlan)migrator.migrateToVersion((Object)plan, plan.getVersion().intValue(), CompactionUtils.COMPACTION_METADATA_VERSION_1.intValue());
        Assertions.assertEquals((Integer)CompactionUtils.COMPACTION_METADATA_VERSION_1, (Integer)oldPlan.getVersion());
        this.testFileSlicesCompactionPlanEquality((List)inputAndPlan.getKey(), oldPlan);
        HoodieCompactionPlan newPlan = (HoodieCompactionPlan)migrator.upgradeToLatest((Object)plan, plan.getVersion().intValue());
        Assertions.assertEquals((Integer)CompactionUtils.LATEST_COMPACTION_METADATA_VERSION, (Integer)newPlan.getVersion());
        this.testFileSlicesCompactionPlanEquality((List)inputAndPlan.getKey(), newPlan);
        HoodieCompactionPlan latestPlan = (HoodieCompactionPlan)migrator.migrateToVersion((Object)oldPlan, oldPlan.getVersion().intValue(), newPlan.getVersion().intValue());
        this.testFileSlicesCompactionPlanEquality((List)inputAndPlan.getKey(), latestPlan);
    }

    @Test
    public void testBuildFromFileSlice() {
        FileSlice emptyFileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "empty1");
        HoodieCompactionOperation op = CompactionUtils.buildFromFileSlice((String)HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], (FileSlice)emptyFileSlice, (Option)Option.of(this.metricsCaptureFn));
        this.testFileSliceCompactionOpEquality(emptyFileSlice, op, HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], CompactionUtils.LATEST_COMPACTION_METADATA_VERSION);
        FileSlice noLogFileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "noLog1");
        noLogFileSlice.setBaseFile((HoodieBaseFile)new CompactionTestUtils.DummyHoodieBaseFile("/tmp/noLog_1_000.parquet"));
        op = CompactionUtils.buildFromFileSlice((String)HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], (FileSlice)noLogFileSlice, (Option)Option.of(this.metricsCaptureFn));
        this.testFileSliceCompactionOpEquality(noLogFileSlice, op, HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], CompactionUtils.LATEST_COMPACTION_METADATA_VERSION);
        FileSlice noDataFileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "noData1");
        noDataFileSlice.addLogFile(new HoodieLogFile(new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)1, (String)TEST_WRITE_TOKEN))));
        noDataFileSlice.addLogFile(new HoodieLogFile(new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)2, (String)TEST_WRITE_TOKEN))));
        op = CompactionUtils.buildFromFileSlice((String)HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], (FileSlice)noDataFileSlice, (Option)Option.of(this.metricsCaptureFn));
        this.testFileSliceCompactionOpEquality(noDataFileSlice, op, HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], CompactionUtils.LATEST_COMPACTION_METADATA_VERSION);
        FileSlice fileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "noData1");
        fileSlice.setBaseFile((HoodieBaseFile)new CompactionTestUtils.DummyHoodieBaseFile("/tmp/noLog_1_000.parquet"));
        fileSlice.addLogFile(new HoodieLogFile(new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)1, (String)TEST_WRITE_TOKEN))));
        fileSlice.addLogFile(new HoodieLogFile(new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)2, (String)TEST_WRITE_TOKEN))));
        op = CompactionUtils.buildFromFileSlice((String)HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], (FileSlice)fileSlice, (Option)Option.of(this.metricsCaptureFn));
        this.testFileSliceCompactionOpEquality(fileSlice, op, HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], CompactionUtils.LATEST_COMPACTION_METADATA_VERSION);
    }

    private Pair<List<Pair<String, FileSlice>>, HoodieCompactionPlan> buildCompactionPlan() {
        Path fullPartitionPath = new Path(new Path(this.metaClient.getBasePath()), HoodieTestUtils.DEFAULT_PARTITION_PATHS[0]);
        FileSlice emptyFileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "empty1");
        FileSlice fileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "noData1");
        fileSlice.setBaseFile((HoodieBaseFile)new CompactionTestUtils.DummyHoodieBaseFile(fullPartitionPath.toString() + "/data1_1_000.parquet"));
        fileSlice.addLogFile(new HoodieLogFile(new Path(fullPartitionPath, new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)1, (String)TEST_WRITE_TOKEN)))));
        fileSlice.addLogFile(new HoodieLogFile(new Path(fullPartitionPath, new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)2, (String)TEST_WRITE_TOKEN)))));
        FileSlice noLogFileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "noLog1");
        noLogFileSlice.setBaseFile((HoodieBaseFile)new CompactionTestUtils.DummyHoodieBaseFile(fullPartitionPath.toString() + "/noLog_1_000.parquet"));
        FileSlice noDataFileSlice = new FileSlice(HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], "000", "noData1");
        noDataFileSlice.addLogFile(new HoodieLogFile(new Path(fullPartitionPath, new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)1, (String)TEST_WRITE_TOKEN)))));
        noDataFileSlice.addLogFile(new HoodieLogFile(new Path(fullPartitionPath, new Path(FSUtils.makeLogFileName((String)"noData1", (String)".log", (String)"000", (int)2, (String)TEST_WRITE_TOKEN)))));
        List<FileSlice> fileSliceList = Arrays.asList(emptyFileSlice, noDataFileSlice, fileSlice, noLogFileSlice);
        List input = fileSliceList.stream().map(f -> Pair.of((Object)HoodieTestUtils.DEFAULT_PARTITION_PATHS[0], (Object)f)).collect(Collectors.toList());
        return Pair.of(input, (Object)CompactionUtils.buildFromFileSlices(input, (Option)Option.empty(), (Option)Option.of(this.metricsCaptureFn)));
    }

    @Test
    public void testBuildFromFileSlices() {
        Pair<List<Pair<String, FileSlice>>, HoodieCompactionPlan> inputAndPlan = this.buildCompactionPlan();
        this.testFileSlicesCompactionPlanEquality((List)inputAndPlan.getKey(), (HoodieCompactionPlan)inputAndPlan.getValue());
    }

    @Test
    public void testCompactionTransformation() {
        Pair<List<Pair<String, FileSlice>>, HoodieCompactionPlan> inputAndPlan = this.buildCompactionPlan();
        HoodieCompactionPlan plan = (HoodieCompactionPlan)inputAndPlan.getRight();
        List originalOps = plan.getOperations();
        List regeneratedOps = originalOps.stream().map(CompactionUtils::buildCompactionOperation).map(CompactionUtils::buildHoodieCompactionOperation).collect(Collectors.toList());
        Assertions.assertTrue((originalOps.size() > 0 ? 1 : 0) != 0, (String)"Transformation did get tested");
        Assertions.assertEquals((Object)originalOps, regeneratedOps, (String)"All fields set correctly in transformations");
    }

    @Test
    public void testGetAllPendingCompactionOperationsWithDupFileId() throws IOException {
        HoodieCompactionPlan plan1 = CompactionTestUtils.createCompactionPlan(this.metaClient, "000", "001", 10, true, true);
        HoodieCompactionPlan plan2 = CompactionTestUtils.createCompactionPlan(this.metaClient, "002", "003", 0, false, false);
        CompactionTestUtils.scheduleCompaction(this.metaClient, "001", plan1);
        CompactionTestUtils.scheduleCompaction(this.metaClient, "003", plan2);
        ((HoodieCompactionOperation)plan1.getOperations().get(0)).setDataFilePath("bla");
        CompactionTestUtils.scheduleCompaction(this.metaClient, "005", plan1);
        this.metaClient = new HoodieTableMetaClient(this.metaClient.getHadoopConf(), this.basePath, true);
        Assertions.assertThrows(IllegalStateException.class, () -> CompactionUtils.getAllPendingCompactionOperations((HoodieTableMetaClient)this.metaClient));
    }

    @Test
    public void testGetAllPendingCompactionOperationsWithFullDupFileId() throws IOException {
        HoodieCompactionPlan plan1 = CompactionTestUtils.createCompactionPlan(this.metaClient, "000", "001", 10, true, true);
        HoodieCompactionPlan plan2 = CompactionTestUtils.createCompactionPlan(this.metaClient, "002", "003", 0, false, false);
        CompactionTestUtils.scheduleCompaction(this.metaClient, "001", plan1);
        CompactionTestUtils.scheduleCompaction(this.metaClient, "003", plan2);
        CompactionTestUtils.scheduleCompaction(this.metaClient, "005", plan1);
        this.metaClient = new HoodieTableMetaClient(this.metaClient.getHadoopConf(), this.basePath, true);
        Map res = CompactionUtils.getAllPendingCompactionOperations((HoodieTableMetaClient)this.metaClient);
    }

    @Test
    public void testGetAllPendingCompactionOperations() throws IOException {
        CompactionTestUtils.setupAndValidateCompactionOperations(this.metaClient, false, 10, 10, 10, 0);
    }

    @Test
    public void testGetAllPendingInflightCompactionOperations() throws IOException {
        CompactionTestUtils.setupAndValidateCompactionOperations(this.metaClient, true, 10, 10, 10, 0);
    }

    @Test
    public void testGetAllPendingCompactionOperationsForEmptyCompactions() throws IOException {
        CompactionTestUtils.setupAndValidateCompactionOperations(this.metaClient, false, 0, 0, 0, 0);
    }

    private void testFileSlicesCompactionPlanEquality(List<Pair<String, FileSlice>> input, HoodieCompactionPlan plan) {
        Assertions.assertEquals((int)input.size(), (int)plan.getOperations().size(), (String)"All file-slices present");
        IntStream.range(0, input.size()).boxed().forEach(idx -> this.testFileSliceCompactionOpEquality((FileSlice)((Pair)input.get((int)idx)).getValue(), (HoodieCompactionOperation)plan.getOperations().get((int)idx), (String)((Pair)input.get((int)idx)).getKey(), plan.getVersion()));
    }

    private void testFileSliceCompactionOpEquality(FileSlice slice, HoodieCompactionOperation op, String expPartitionPath, int version) {
        Assertions.assertEquals((Object)expPartitionPath, (Object)op.getPartitionPath(), (String)"Partition path is correct");
        Assertions.assertEquals((Object)slice.getBaseInstantTime(), (Object)op.getBaseInstantTime(), (String)"Same base-instant");
        Assertions.assertEquals((Object)slice.getFileId(), (Object)op.getFileId(), (String)"Same file-id");
        if (slice.getBaseFile().isPresent()) {
            HoodieBaseFile df = (HoodieBaseFile)slice.getBaseFile().get();
            Assertions.assertEquals((Object)(version == CompactionUtils.COMPACTION_METADATA_VERSION_1 ? df.getPath() : df.getFileName()), (Object)op.getDataFilePath(), (String)"Same data-file");
        }
        List paths = slice.getLogFiles().map(l -> l.getPath().toString()).collect(Collectors.toList());
        IntStream.range(0, paths.size()).boxed().forEach(idx -> Assertions.assertEquals(version == CompactionUtils.COMPACTION_METADATA_VERSION_1 ? paths.get((int)idx) : new Path((String)paths.get((int)idx)).getName(), op.getDeltaFilePaths().get((int)idx), (String)("Log File Index " + idx)));
        Assertions.assertEquals(METRICS, (Object)op.getMetrics(), (String)"Metrics set");
    }

    @Override
    protected HoodieTableType getTableType() {
        return HoodieTableType.MERGE_ON_READ;
    }
}

