/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.testutils.minicluster.HdfsTestService;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestDFSPropertiesConfiguration {
    private static String dfsBasePath;
    private static HdfsTestService hdfsTestService;
    private static MiniDFSCluster dfsCluster;
    private static DistributedFileSystem dfs;

    @BeforeAll
    public static void initClass() throws Exception {
        hdfsTestService = new HdfsTestService();
        dfsCluster = hdfsTestService.start(true);
        dfs = dfsCluster.getFileSystem();
        dfsBasePath = dfs.getWorkingDirectory().toString();
        dfs.mkdirs(new Path(dfsBasePath));
        Path filePath = new Path(dfsBasePath + "/t1.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"", "#comment", "abc", "int.prop=123", "double.prop=113.4", "string.prop=str", "boolean.prop=true", "long.prop=1354354354"});
        filePath = new Path(dfsBasePath + "/t2.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"string.prop=ignored", "include=t1.props"});
        filePath = new Path(dfsBasePath + "/t3.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"double.prop=838.3", "include = t2.props", "double.prop=243.4", "string.prop=t3.value"});
        filePath = new Path(dfsBasePath + "/t4.props");
        TestDFSPropertiesConfiguration.writePropertiesFile(filePath, new String[]{"double.prop=838.3", "include = t4.props"});
    }

    @AfterAll
    public static void cleanupClass() throws Exception {
        if (hdfsTestService != null) {
            hdfsTestService.stop();
        }
    }

    private static void writePropertiesFile(Path path, String[] lines) throws IOException {
        PrintStream out = new PrintStream((OutputStream)dfs.create(path, true));
        for (String line : lines) {
            out.println(line);
        }
        out.flush();
        out.close();
    }

    @Test
    public void testParsing() {
        DFSPropertiesConfiguration cfg = new DFSPropertiesConfiguration((FileSystem)dfs, new Path(dfsBasePath + "/t1.props"));
        TypedProperties props = cfg.getConfig();
        Assertions.assertEquals((int)5, (int)props.size());
        Assertions.assertThrows(IllegalArgumentException.class, () -> props.getString("invalid.key"), (String)"Should error out here.");
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop"));
        Assertions.assertEquals((double)113.4, (double)props.getDouble("double.prop"), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop"));
        Assertions.assertEquals((Object)"str", (Object)props.getString("string.prop"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop"));
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop", 456));
        Assertions.assertEquals((double)113.4, (double)props.getDouble("double.prop", 223.4), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop", false));
        Assertions.assertEquals((Object)"str", (Object)props.getString("string.prop", "default"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop", 8578494434L));
        Assertions.assertEquals((int)456, (int)props.getInteger("bad.int.prop", 456));
        Assertions.assertEquals((double)223.4, (double)props.getDouble("bad.double.prop", 223.4), (double)0.001);
        Assertions.assertFalse((boolean)props.getBoolean("bad.boolean.prop", false));
        Assertions.assertEquals((Object)"default", (Object)props.getString("bad.string.prop", "default"));
        Assertions.assertEquals((long)8578494434L, (long)props.getLong("bad.long.prop", 8578494434L));
    }

    @Test
    public void testIncludes() {
        DFSPropertiesConfiguration cfg = new DFSPropertiesConfiguration((FileSystem)dfs, new Path(dfsBasePath + "/t3.props"));
        TypedProperties props = cfg.getConfig();
        Assertions.assertEquals((int)123, (int)props.getInteger("int.prop"));
        Assertions.assertEquals((double)243.4, (double)props.getDouble("double.prop"), (double)0.001);
        Assertions.assertTrue((boolean)props.getBoolean("boolean.prop"));
        Assertions.assertEquals((Object)"t3.value", (Object)props.getString("string.prop"));
        Assertions.assertEquals((long)1354354354L, (long)props.getLong("long.prop"));
        Assertions.assertThrows(IllegalStateException.class, () -> new DFSPropertiesConfiguration((FileSystem)dfs, new Path(dfsBasePath + "/t4.props")), (String)"Should error out on a self-included file.");
    }
}

