/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.FileIOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileIOUtils
extends HoodieCommonTestHarness {
    @Test
    public void testMkdirAndDelete() throws IOException {
        try {
            FileIOUtils.mkdir((File)this.tempDir.toFile());
        }
        catch (IOException e) {
            Assertions.fail((String)"Should not error out if dir exists already");
        }
        File dir = this.tempDir.resolve("dir").toFile();
        FileIOUtils.mkdir((File)dir);
        Assertions.assertTrue((boolean)dir.exists());
        new File(dir, "t.txt").createNewFile();
        new File(dir, "subdir").mkdirs();
        new File(dir, "subdir" + File.pathSeparator + "z.txt").createNewFile();
        FileIOUtils.deleteDirectory((File)dir);
        Assertions.assertFalse((boolean)dir.exists());
    }

    @Test
    public void testInputStreamReads() throws IOException {
        String msg = "hudi rocks!";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)msg, (Object)FileIOUtils.readAsUTFString((InputStream)inputStream));
        inputStream = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)msg.length(), (int)FileIOUtils.readAsByteArray((InputStream)inputStream).length);
    }
}

