/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestParquetUtils
extends HoodieCommonTestHarness {
    public static List<Arguments> bloomFilterTypeCodes() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{BloomFilterTypeCode.SIMPLE.name()}), Arguments.of((Object[])new Object[]{BloomFilterTypeCode.DYNAMIC_V0.name()}));
    }

    @BeforeEach
    public void setup() {
        this.initPath();
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testHoodieWriteSupport(String typeCode) throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            rowKeys.add(UUID.randomUUID().toString());
        }
        String filePath = Paths.get(this.basePath, "test.parquet").toString();
        this.writeParquetFile(typeCode, filePath, rowKeys);
        ArrayList rowKeysInFile = new ArrayList(ParquetUtils.readRowKeysFromParquet((Configuration)HoodieTestUtils.getDefaultHadoopConf(), (Path)new Path(filePath)));
        Collections.sort(rowKeysInFile);
        Collections.sort(rowKeys);
        Assertions.assertEquals(rowKeys, rowKeysInFile, (String)"Did not read back the expected list of keys");
        BloomFilter filterInFile = ParquetUtils.readBloomFilterFromParquetMetadata((Configuration)HoodieTestUtils.getDefaultHadoopConf(), (Path)new Path(filePath));
        for (String rowKey : rowKeys) {
            Assertions.assertTrue((boolean)filterInFile.mightContain(rowKey), (String)"key should be found in bloom filter");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testFilterParquetRowKeys(String typeCode) throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        HashSet<String> filter = new HashSet<String>();
        for (int i = 0; i < 1000; ++i) {
            String rowKey = UUID.randomUUID().toString();
            rowKeys.add(rowKey);
            if (i % 100 != 0) continue;
            filter.add(rowKey);
        }
        String filePath = Paths.get(this.basePath, "test.parquet").toString();
        this.writeParquetFile(typeCode, filePath, rowKeys);
        Set filtered = ParquetUtils.filterParquetRowKeys((Configuration)HoodieTestUtils.getDefaultHadoopConf(), (Path)new Path(filePath), filter);
        Assertions.assertEquals((int)filter.size(), (int)filtered.size(), (String)"Filtered count does not match");
        for (String rowKey : filtered) {
            Assertions.assertTrue((boolean)filter.contains(rowKey), (String)"filtered key must be in the given filter");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"bloomFilterTypeCodes"})
    public void testFetchRecordKeyPartitionPathFromParquet(String typeCode) throws Exception {
        ArrayList<String> rowKeys = new ArrayList<String>();
        ArrayList<HoodieKey> expected = new ArrayList<HoodieKey>();
        String partitionPath = "path1";
        for (int i = 0; i < 1000; ++i) {
            String rowKey = UUID.randomUUID().toString();
            rowKeys.add(rowKey);
            expected.add(new HoodieKey(rowKey, partitionPath));
        }
        String filePath = this.basePath + "/test.parquet";
        Schema schema = HoodieAvroUtils.getRecordKeyPartitionPathSchema();
        this.writeParquetFile(typeCode, filePath, rowKeys, schema, true, partitionPath);
        List fetchedRows = ParquetUtils.fetchRecordKeyPartitionPathFromParquet((Configuration)HoodieTestUtils.getDefaultHadoopConf(), (Path)new Path(filePath));
        Assertions.assertEquals((int)rowKeys.size(), (int)fetchedRows.size(), (String)"Total count does not match");
        for (HoodieKey entry : fetchedRows) {
            Assertions.assertTrue((boolean)expected.contains(entry), (String)"Record key must be in the given filter");
        }
    }

    private void writeParquetFile(String typeCode, String filePath, List<String> rowKeys) throws Exception {
        this.writeParquetFile(typeCode, filePath, rowKeys, HoodieAvroUtils.getRecordKeySchema(), false, "");
    }

    private void writeParquetFile(String typeCode, String filePath, List<String> rowKeys, Schema schema, boolean addPartitionPathField, String partitionPath) throws Exception {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)10000, (String)typeCode);
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, filter);
        ParquetWriter writer = new ParquetWriter(new Path(filePath), (WriteSupport)writeSupport, CompressionCodecName.GZIP, 0x7800000, 0x100000);
        for (String rowKey : rowKeys) {
            GenericData.Record rec = new GenericData.Record(schema);
            rec.put("_hoodie_record_key", (Object)rowKey);
            if (addPartitionPathField) {
                rec.put("_hoodie_partition_path", (Object)partitionPath);
            }
            writer.write((Object)rec);
            writeSupport.add(rowKey);
        }
        writer.close();
    }
}

