/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TablePathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public final class TestTablePathUtils {
    @TempDir
    static File tempDir;
    private static FileSystem fs;
    private static Path tablePath;
    private static Path partitionPath1;
    private static Path partitionPath2;
    private static Path filePath1;
    private static Path filePath2;

    @BeforeAll
    static void setup() throws IOException {
        URI tablePathURI = Paths.get(tempDir.getAbsolutePath(), "test_table").toUri();
        tablePath = new Path(tablePathURI);
        fs = tablePath.getFileSystem(new Configuration());
        Assertions.assertTrue((boolean)new File(Paths.get(tablePathURI.getPath(), HoodieTableMetaClient.BOOTSTRAP_INDEX_ROOT_FOLDER_PATH).toUri()).mkdirs());
        URI partitionPathURI1 = Paths.get(tablePathURI.getPath(), "key1=abc/key2=def").toUri();
        partitionPath1 = new Path(partitionPathURI1);
        URI partitionPathURI2 = Paths.get(tablePathURI.getPath(), "key1=xyz/key2=def").toUri();
        partitionPath2 = new Path(partitionPathURI2);
        Assertions.assertTrue((boolean)new File(partitionPathURI1).mkdirs());
        Assertions.assertTrue((boolean)new File(partitionPathURI2).mkdirs());
        HoodiePartitionMetadata partitionMetadata1 = new HoodiePartitionMetadata(fs, Instant.now().toString(), tablePath, partitionPath1);
        partitionMetadata1.trySave(1);
        HoodiePartitionMetadata partitionMetadata2 = new HoodiePartitionMetadata(fs, Instant.now().toString(), tablePath, partitionPath2);
        partitionMetadata2.trySave(2);
        URI filePathURI1 = Paths.get(partitionPathURI1.getPath(), "data1.parquet").toUri();
        filePath1 = new Path(filePathURI1);
        URI filePathURI2 = Paths.get(partitionPathURI2.getPath(), "data2.parquet").toUri();
        filePath2 = new Path(filePathURI2);
        Assertions.assertTrue((boolean)new File(filePathURI1).createNewFile());
        Assertions.assertTrue((boolean)new File(filePathURI2).createNewFile());
    }

    @Test
    void getTablePathFromTablePath() throws IOException {
        Option inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)tablePath);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromMetadataFolderPath() throws IOException {
        Path metadataFolder = new Path(tablePath, ".hoodie");
        Option inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)metadataFolder);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromMetadataSubFolderPath() throws IOException {
        Path auxFolder = new Path(tablePath, HoodieTableMetaClient.AUXILIARYFOLDER_NAME);
        Option inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)auxFolder);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
        Path bootstrapIndexFolder = new Path(tablePath, HoodieTableMetaClient.BOOTSTRAP_INDEX_ROOT_FOLDER_PATH);
        inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)bootstrapIndexFolder);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromPartitionFolderPath() throws IOException {
        Option inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)partitionPath1);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
        inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)partitionPath2);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }

    @Test
    void getTablePathFromFilePath() throws IOException {
        Option inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)filePath1);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
        inferredTablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)filePath2);
        Assertions.assertEquals((Object)tablePath, (Object)inferredTablePath.get());
    }
}

