/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
public class TestExternalSpillableMap
extends HoodieCommonTestHarness {
    private static String failureOutputPath;

    @BeforeEach
    public void setUp() {
        this.initPath();
        failureOutputPath = this.basePath + "/test_fail";
    }

    @Test
    public void simpleInsertTest() throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        String payloadClazz = HoodieAvroPayload.class.getName();
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        assert (recordKeys.size() == 100);
        Iterator itr = records.iterator();
        ArrayList<HoodieRecord> oRecords = new ArrayList<HoodieRecord>();
        while (itr.hasNext()) {
            HoodieRecord rec = (HoodieRecord)itr.next();
            oRecords.add(rec);
            assert (recordKeys.contains(rec.getRecordKey()));
        }
    }

    @Test
    public void testSimpleUpsert() throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        assert (recordKeys.size() == 100);
        for (HoodieRecord rec : records) {
            assert (recordKeys.contains(rec.getRecordKey()));
        }
        List<IndexedRecord> updatedRecords = SchemaTestUtil.updateHoodieTestRecords(recordKeys, SchemaTestUtil.generateHoodieTestRecords(0, 100), HoodieActiveTimeline.createNewInstantTime());
        SpillableMapTestUtils.upsertRecords(updatedRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        Assertions.assertTrue((records.getDiskBasedMapNumEntries() > 0 ? 1 : 0) != 0);
        updatedRecords.forEach(record -> {
            HoodieRecord rec = (HoodieRecord)records.get(((GenericRecord)record).get("_hoodie_record_key"));
            try {
                Assertions.assertEquals((Object)rec.getData().getInsertValue(schema).get(), (Object)record);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        });
    }

    @Test
    public void testAllMapOperations() throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        String payloadClazz = HoodieAvroPayload.class.getName();
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        IndexedRecord inMemoryRecord = iRecords.get(0);
        String ikey = ((GenericRecord)inMemoryRecord).get("_hoodie_record_key").toString();
        String iPartitionPath = ((GenericRecord)inMemoryRecord).get("_hoodie_partition_path").toString();
        HoodieRecord inMemoryHoodieRecord = new HoodieRecord(new HoodieKey(ikey, iPartitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)inMemoryRecord))));
        IndexedRecord onDiskRecord = iRecords.get(99);
        String dkey = ((GenericRecord)onDiskRecord).get("_hoodie_record_key").toString();
        String dPartitionPath = ((GenericRecord)onDiskRecord).get("_hoodie_partition_path").toString();
        HoodieRecord onDiskHoodieRecord = new HoodieRecord(new HoodieKey(dkey, dPartitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)onDiskRecord))));
        assert (records.size() == 100);
        assert (inMemoryHoodieRecord.getKey().equals((Object)((HoodieRecord)records.get((Object)ikey)).getKey()));
        assert (onDiskHoodieRecord.getKey().equals((Object)((HoodieRecord)records.get((Object)dkey)).getKey()));
        assert (((HoodieRecord)records.get((Object)ikey)).getCurrentLocation().getFileId().equals("DUMMY_FILE_ID"));
        assert (((HoodieRecord)records.get((Object)ikey)).getCurrentLocation().getInstantTime().equals("DUMMY_COMMIT_TIME"));
        Assertions.assertTrue((boolean)records.containsKey((Object)ikey));
        Assertions.assertTrue((boolean)records.containsKey((Object)dkey));
        Assertions.assertFalse((boolean)records.isEmpty());
        Assertions.assertTrue((boolean)records.keySet().containsAll(recordKeys));
        HoodieRecord removedRecord = (HoodieRecord)records.remove((Object)ikey);
        Assertions.assertTrue((removedRecord != null ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)records.containsKey((Object)ikey));
        removedRecord = (HoodieRecord)records.remove((Object)dkey);
        Assertions.assertTrue((removedRecord != null ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)records.containsKey((Object)dkey));
        records.clear();
        Assertions.assertTrue((records.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void simpleTestWithException() throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), failureOutputPath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        assert (recordKeys.size() == 100);
        Iterator itr = records.iterator();
        Assertions.assertThrows(IOException.class, () -> {
            if (itr.hasNext()) {
                throw new IOException("Testing failures...");
            }
        });
    }

    @Test
    public void testDataCorrectnessWithUpsertsToDataInMapAndOnDisk() throws IOException, URISyntaxException {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)SchemaTestUtil.getSimpleSchema());
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        ArrayList<String> recordKeys = new ArrayList<String>();
        while (records.getDiskBasedMapNumEntries() < 1) {
            List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
            recordKeys.addAll(SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records));
        }
        String key = (String)recordKeys.get(0);
        HoodieRecord record = (HoodieRecord)records.get((Object)key);
        ArrayList<Object> recordsToUpdate = new ArrayList<IndexedRecord>();
        recordsToUpdate.add((IndexedRecord)record.getData().getInsertValue(schema).get());
        String newCommitTime = HoodieActiveTimeline.createNewInstantTime();
        ArrayList<String> keysToBeUpdated = new ArrayList<String>();
        keysToBeUpdated.add(key);
        List<IndexedRecord> updatedRecords = SchemaTestUtil.updateHoodieTestRecords(keysToBeUpdated, recordsToUpdate, newCommitTime);
        SpillableMapTestUtils.upsertRecords(updatedRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        GenericRecord gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        assert (newCommitTime.contentEquals(gRecord.get("_hoodie_commit_time").toString()));
        key = (String)recordKeys.get(recordKeys.size() - 1);
        record = (HoodieRecord)records.get((Object)key);
        recordsToUpdate = new ArrayList();
        recordsToUpdate.add((IndexedRecord)record.getData().getInsertValue(schema).get());
        newCommitTime = HoodieActiveTimeline.createNewInstantTime();
        keysToBeUpdated = new ArrayList();
        keysToBeUpdated.add(key);
        updatedRecords = SchemaTestUtil.updateHoodieTestRecords(keysToBeUpdated, recordsToUpdate, newCommitTime);
        SpillableMapTestUtils.upsertRecords(updatedRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        assert (newCommitTime.contentEquals(gRecord.get("_hoodie_commit_time").toString()));
    }

    @Test
    public void testDataCorrectnessWithoutHoodieMetadata() throws IOException, URISyntaxException {
        Schema schema = SchemaTestUtil.getSimpleSchema();
        ExternalSpillableMap records = new ExternalSpillableMap(Long.valueOf(16L), this.basePath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(schema));
        ArrayList recordKeys = new ArrayList();
        while (records.getDiskBasedMapNumEntries() < 1) {
            List<HoodieRecord> hoodieRecords = SchemaTestUtil.generateHoodieTestRecordsWithoutHoodieMetadata(0, 100);
            hoodieRecords.stream().forEach(r -> {
                records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r);
                recordKeys.add(r.getRecordKey());
            });
        }
        String key = (String)recordKeys.get(0);
        HoodieRecord record = (HoodieRecord)records.get((Object)key);
        String fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
        String newValue = "update1";
        ArrayList<Object> recordsToUpdate = new ArrayList<HoodieRecord>();
        recordsToUpdate.add(record);
        List<HoodieRecord> updatedRecords = SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(recordsToUpdate, schema, fieldName, newValue);
        updatedRecords.forEach(r -> records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r));
        GenericRecord gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        Assertions.assertEquals((Object)gRecord.get(fieldName).toString(), (Object)newValue);
        key = (String)recordKeys.get(recordKeys.size() - 1);
        record = (HoodieRecord)records.get((Object)key);
        fieldName = schema.getFields().stream().filter(field -> field.schema().getType() == Schema.Type.STRING).findAny().get().name();
        newValue = "update2";
        recordsToUpdate = new ArrayList();
        recordsToUpdate.add(record);
        updatedRecords = SchemaTestUtil.updateHoodieTestRecordsWithoutHoodieMetadata(recordsToUpdate, schema, fieldName, newValue);
        updatedRecords.forEach(r -> records.put((Serializable)((Object)r.getRecordKey()), (Serializable)r));
        gRecord = (GenericRecord)((HoodieRecord)records.get((Object)key)).getData().getInsertValue(schema).get();
        Assertions.assertEquals((Object)gRecord.get(fieldName).toString(), (Object)newValue);
    }

    @Test
    public void testLargeInsertUpsert() {
    }
}

