/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.testutils.SpillableMapTestUtils;
import org.apache.hudi.common.util.collection.RocksDBBasedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRocksDbBasedMap
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() {
        this.initPath();
    }

    @Test
    public void testSimple() throws IOException, URISyntaxException {
        RocksDBBasedMap records = new RocksDBBasedMap(this.basePath);
        List<IndexedRecord> iRecords = SchemaTestUtil.generateHoodieTestRecords(0, 100);
        ((GenericRecord)iRecords.get(0)).get("_hoodie_commit_time").toString();
        List<String> recordKeys = SpillableMapTestUtils.upsertRecords(iRecords, (Map<String, HoodieRecord<? extends HoodieRecordPayload>>)records);
        Iterator itr = records.iterator();
        ArrayList<HoodieRecord> oRecords = new ArrayList<HoodieRecord>();
        while (itr.hasNext()) {
            HoodieRecord rec = (HoodieRecord)itr.next();
            oRecords.add(rec);
            assert (recordKeys.contains(rec.getRecordKey()));
        }
        Assertions.assertEquals((int)recordKeys.size(), (int)oRecords.size());
    }
}

