/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.Arrays;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;

public class AvroSchemaTestUtils {
    public static Schema.Field createNestedField(String name, Schema.Type type) {
        return AvroSchemaTestUtils.createNestedField(name, Schema.create((Schema.Type)type));
    }

    public static Schema.Field createNestedField(String name, Schema schema) {
        return new Schema.Field(name, AvroSchemaTestUtils.createRecord(name, new Schema.Field("nested", schema, null, null)), null, null);
    }

    public static Schema.Field createArrayField(String name, Schema.Type type) {
        return AvroSchemaTestUtils.createArrayField(name, Schema.create((Schema.Type)type));
    }

    public static Schema.Field createArrayField(String name, Schema schema) {
        return new Schema.Field(name, Schema.createArray((Schema)schema), null, null);
    }

    public static Schema.Field createNullableArrayField(String name, Schema schema) {
        return new Schema.Field(name, Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.createArray((Schema)schema)}), null, (Object)Schema.Field.NULL_VALUE);
    }

    public static Schema.Field createMapField(String name, Schema.Type type) {
        return AvroSchemaTestUtils.createMapField(name, Schema.create((Schema.Type)type));
    }

    public static Schema.Field createMapField(String name, Schema schema) {
        return new Schema.Field(name, Schema.createMap((Schema)schema), null, null);
    }

    public static Schema.Field createPrimitiveField(String name, Schema.Type type) {
        return new Schema.Field(name, Schema.create((Schema.Type)type), null, null);
    }

    public static Schema.Field createNullablePrimitiveField(String name, Schema.Type type) {
        return new Schema.Field(name, AvroSchemaUtils.createNullableSchema((Schema.Type)type), null, (Object)JsonProperties.NULL_VALUE);
    }

    public static Schema createRecord(String name, Schema.Field ... fields) {
        return Schema.createRecord((String)name, null, null, (boolean)false, Arrays.asList(fields));
    }

    public static Schema createNullableRecord(String name, Schema.Field ... fields) {
        return AvroSchemaUtils.createNullableSchema((Schema)Schema.createRecord((String)name, null, null, (boolean)false, Arrays.asList(fields)));
    }
}

