/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaComparatorForSchemaEvolution;
import org.apache.hudi.common.util.FileIOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAvroSchemaComparatorForSchemaEvolution {
    TestAvroSchemaComparatorForSchemaEvolution() {
    }

    @Test
    void testAttrsIrrelevantToEquality() throws IOException {
        String schemaA = FileIOUtils.readAsUTFString((InputStream)TestAvroSchemaComparatorForSchemaEvolution.class.getResourceAsStream("/avro-schema-evo/schema-allshapes-A.txt"));
        String schemaB = FileIOUtils.readAsUTFString((InputStream)TestAvroSchemaComparatorForSchemaEvolution.class.getResourceAsStream("/avro-schema-evo/schema-allshapes-B.txt"));
        Schema schema1 = new Schema.Parser().parse(schemaA);
        Schema schema2 = new Schema.Parser().parse(schemaB);
        Assertions.assertNotEquals((Object)schema1, (Object)schema2);
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)schema1, (Schema)schema2));
        Assertions.assertEquals((Object)new AvroSchemaComparatorForSchemaEvolution.SchemaWrapper(schema1), (Object)new AvroSchemaComparatorForSchemaEvolution.SchemaWrapper(schema2));
    }

    @Test
    void testComparingPrimitiveTypes() {
        Schema.Type[] primitiveTypes;
        for (Schema.Type primitiveType : primitiveTypes = new Schema.Type[]{Schema.Type.NULL, Schema.Type.BOOLEAN, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.BYTES, Schema.Type.STRING}) {
            for (Schema.Type type : primitiveTypes) {
                if (primitiveType == type) {
                    Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)Schema.create((Schema.Type)primitiveType), (Schema)Schema.create((Schema.Type)type)));
                    continue;
                }
                Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)Schema.create((Schema.Type)primitiveType), (Schema)Schema.create((Schema.Type)type)), (String)String.format("Types %s and %s should not be equal", primitiveType, type));
            }
        }
    }

    @Test
    void testEqualToSelf() {
        String schema = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema), (Schema)new Schema.Parser().parse(schema)));
    }

    @Test
    void testIsErrorFieldInRecordSchema() {
        Schema record1 = Schema.createRecord((String)"TestRecord", null, null, (boolean)false);
        record1.setFields(Arrays.asList(new Schema.Field("field1", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        Schema record2 = Schema.createRecord((String)"TestRecord", null, null, (boolean)true);
        record2.setFields(Arrays.asList(new Schema.Field("field1", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record2));
    }

    @Test
    void testRecordFieldTypes() {
        String schema1 = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\"}]}";
        String schema2 = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"field1\",\"type\":\"int\"}]}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testRecordFieldOrderAttribute() {
        String schema1 = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\",\"order\":\"ascending\"}]}";
        String schema2 = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"name\":\"field1\",\"type\":\"string\",\"order\":\"descending\"}]}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testArraySchema() {
        String schema1 = "{\"type\":\"array\",\"items\":\"string\"}";
        String schema2 = "{\"type\":\"array\",\"items\":\"int\"}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testMapSchema() {
        String schema1 = "{\"type\":\"map\",\"values\":\"string\"}";
        String schema2 = "{\"type\":\"map\",\"values\":\"int\"}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testFixedSchemaSizeAttr() {
        String schema1 = "{\"type\":\"fixed\",\"name\":\"F\",\"size\":16}";
        String schema2 = "{\"type\":\"fixed\",\"name\":\"F\",\"size\":32}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testUnionMemberTypes() {
        String schema1 = "[\"null\",\"string\"]";
        String schema2 = "[\"null\",\"int\"]";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testUnionMemberOrdering() {
        String schema1 = "[\"null\",\"string\"]";
        String schema2 = "[\"string\",\"null\"]";
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testLogicalTypeDecimalAttr() {
        String schema1 = "{\"type\":\"fixed\",\"name\":\"D\",\"size\":16,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":2}";
        String schema2 = "{\"type\":\"fixed\",\"name\":\"D\",\"size\":16,\"logicalType\":\"decimal\",\"precision\":8,\"scale\":2}";
        String schema3 = "{\"type\":\"fixed\",\"name\":\"D\",\"size\":16,\"logicalType\":\"decimal\",\"precision\":8,\"scale\":3}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema2), (Schema)new Schema.Parser().parse(schema3)));
    }

    @Test
    void testLogicalType() {
        String schema1 = "{\"type\":\"int\",\"logicalType\":\"date\"}";
        String schema2 = "{\"type\":\"int\",\"logicalType\":\"time-millis\"}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testLogicalTypesWithDifferentPrimitiveTypes() {
        String decimalFixed = "{\"type\":\"fixed\",\"name\":\"D\",\"size\":16,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":2}";
        String decimalBytes = "{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":10,\"scale\":2}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(decimalFixed), (Schema)new Schema.Parser().parse(decimalBytes)));
    }

    @Test
    void testComparingSchemaFieldNames() {
        String record1 = "{\"type\":\"record\",\"name\":\"R1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        String record2 = "{\"type\":\"record\",\"name\":\"R2\",\"fields\":[{\"name\":\"f2\",\"type\":\"string\"}]}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(record1), (Schema)new Schema.Parser().parse(record2)));
        String enum1 = "{\"type\":\"enum\",\"name\":\"E1\",\"symbols\":[\"A\"]}";
        String enum2 = "{\"type\":\"enum\",\"name\":\"E2\",\"symbols\":[\"A\"]}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(enum1), (Schema)new Schema.Parser().parse(enum2)));
        String fixed1 = "{\"type\":\"fixed\",\"name\":\"F1\",\"size\":16}";
        String fixed2 = "{\"type\":\"fixed\",\"name\":\"F2\",\"size\":16}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(fixed1), (Schema)new Schema.Parser().parse(fixed2)));
    }

    @Test
    void testEnumSchemaName() {
        Schema schema1 = Schema.createEnum((String)"enum1", null, null, Arrays.asList("A", "B", "C"));
        Schema schema2 = Schema.createEnum((String)"enum2", null, null, Arrays.asList("A", "B", "C"));
        Schema schema3 = Schema.createEnum((String)"enum1", null, null, Arrays.asList("A", "B", "C"));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)schema1, (Schema)schema2));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)schema1, (Schema)schema3));
    }

    @Test
    void testEnumSchema() {
        Schema schema1 = Schema.createEnum((String)"enum", null, null, Arrays.asList("A", "C"));
        Schema schema2 = Schema.createEnum((String)"enum", null, null, Arrays.asList("A", "B", "C"));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)schema1, (Schema)schema2));
    }

    @Test
    void testEnumSymbolsOrder() {
        String schema1 = "{\"type\":\"enum\",\"name\":\"E\",\"symbols\":[\"A\",\"B\"]}";
        String schema2 = "{\"type\":\"enum\",\"name\":\"E\",\"symbols\":[\"B\",\"A\"]}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
    }

    @Test
    void testDefaultValueEquality() {
        Schema.Field field1 = new Schema.Field("field", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)"default1");
        Schema.Field field2 = new Schema.Field("field", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)"default2");
        Schema.Field field3 = new Schema.Field("field", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)"default1");
        Schema.Field fieldNoDefault = new Schema.Field("field", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema record1 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record1.setFields(Collections.singletonList(field1));
        Schema record2 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record2.setFields(Collections.singletonList(field2));
        Schema record3 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record3.setFields(Collections.singletonList(field3));
        Schema recordNoDefault = Schema.createRecord((String)"test", null, null, (boolean)false);
        recordNoDefault.setFields(Collections.singletonList(fieldNoDefault));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record2));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record3));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)recordNoDefault));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)recordNoDefault, (Schema)recordNoDefault));
    }

    @Test
    void testComplexDefaultValueEquality() {
        Schema innerSchema = Schema.createRecord((String)"inner", null, null, (boolean)false);
        innerSchema.setFields(Collections.singletonList(new Schema.Field("value", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        HashMap<String, String> defaultValue1 = new HashMap<String, String>();
        defaultValue1.put("value", "test");
        HashMap<String, String> defaultValue2 = new HashMap<String, String>();
        defaultValue2.put("value", "test");
        HashMap<String, String> defaultValue3 = new HashMap<String, String>();
        defaultValue3.put("value", "different");
        Schema.Field field1 = new Schema.Field("field", innerSchema, null, defaultValue1);
        Schema.Field field2 = new Schema.Field("field", innerSchema, null, defaultValue2);
        Schema.Field field3 = new Schema.Field("field", innerSchema, null, defaultValue3);
        Schema record1 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record1.setFields(Collections.singletonList(field1));
        Schema record2 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record2.setFields(Collections.singletonList(field2));
        Schema record3 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record3.setFields(Collections.singletonList(field3));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record2));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record3));
    }

    @Test
    void testArrayDefaultValueEquality() {
        List<String> defaultArray1 = Arrays.asList("a", "b", "c");
        List<String> defaultArray2 = Arrays.asList("a", "b", "c");
        List<String> defaultArray3 = Arrays.asList("x", "y", "z");
        Schema arraySchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Schema.Field field1 = new Schema.Field("field", arraySchema, null, defaultArray1);
        Schema.Field field2 = new Schema.Field("field", arraySchema, null, defaultArray2);
        Schema.Field field3 = new Schema.Field("field", arraySchema, null, defaultArray3);
        Schema record1 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record1.setFields(Collections.singletonList(field1));
        Schema record2 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record2.setFields(Collections.singletonList(field2));
        Schema record3 = Schema.createRecord((String)"test", null, null, (boolean)false);
        record3.setFields(Collections.singletonList(field3));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record2));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record3));
    }

    @Test
    void testCompareWithNull() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)schema, null));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals(null, (Schema)schema));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals(null, null));
    }

    @Test
    void testRecordFieldCountMismatch() {
        Schema record1 = Schema.createRecord((String)"TestRecord", null, null, (boolean)false);
        record1.setFields(Collections.singletonList(new Schema.Field("field1", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        Schema record2 = Schema.createRecord((String)"TestRecord", null, null, (boolean)false);
        record2.setFields(Arrays.asList(new Schema.Field("field1", Schema.create((Schema.Type)Schema.Type.STRING), null, null), new Schema.Field("field2", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)record1, (Schema)record2));
    }

    @Test
    void testUnionSizeMismatch() {
        Schema union1 = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)));
        Schema union2 = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT)));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)union1, (Schema)union2));
    }

    @Test
    void testUnionOrder() {
        Schema union1 = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)));
        Schema union2 = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        Assertions.assertTrue((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)union1, (Schema)union2));
    }

    @Test
    void testLogicalTypeOneNull() {
        String schema1 = "{\"type\":\"int\",\"logicalType\":\"date\"}";
        String schema2 = "{\"type\":\"int\"}";
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema1), (Schema)new Schema.Parser().parse(schema2)));
        Assertions.assertFalse((boolean)AvroSchemaComparatorForSchemaEvolution.schemaEquals((Schema)new Schema.Parser().parse(schema2), (Schema)new Schema.Parser().parse(schema1)));
    }

    @Test
    void testSchemaWrapperNullAndTypeMismatch() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroSchemaComparatorForSchemaEvolution.SchemaWrapper wrapper = new AvroSchemaComparatorForSchemaEvolution.SchemaWrapper(schema);
        Assertions.assertNotNull((Object)wrapper);
        Assertions.assertNotEquals((Object)wrapper, (Object)new Object());
    }
}

