/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieAvroSchemaException;
import org.apache.hudi.exception.SchemaBackwardsCompatibilityException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestAvroSchemaUtils {
    private static final String SOURCE_SCHEMA = "{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n        \"name\" : \"f1\",\n        \"type\" : [ \"null\", {\n           \"type\" : \"fixed\",\n           \"name\" : \"f1\",\n           \"namespace\" : \"\",\n           \"size\" : 5,\n           \"logicalType\" : \"decimal\",\n           \"precision\" : 10,\n           \"scale\" : 2\n           }],\n       \"default\" : null\n      },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          },\n          {\n            \"name\": \"long\",\n            \"type\": [\"null\", \"long\"]\n          }\n        ]\n      }\n    }\n  ]\n}\n";
    private static final String PROJECTED_NESTED_SCHEMA_STRICT = "{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n        \"name\" : \"f1\",\n        \"type\" : [ \"null\", {\n           \"type\" : \"fixed\",\n           \"name\" : \"fixed\",\n           \"namespace\" : \"example.schema.source.f1\",\n           \"size\" : 5,\n           \"logicalType\" : \"decimal\",\n           \"precision\" : 10,\n           \"scale\" : 2\n           }],\n       \"default\" : null\n      },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          }\n        ]\n      }\n    }\n  ]\n}\n";
    private static final String PROJECTED_NESTED_SCHEMA_WITH_PROMOTION = "{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"long\"]\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          }\n        ]  \n      }\n    }\n  ]\n}\n";
    private static final Schema FULL_SCHEMA = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"fields\" : [ {\n    \"name\" : \"a\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"b\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"c\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  } ]\n}");
    private static final Schema SHORT_SCHEMA = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"record\",\n  \"fields\" : [ {\n    \"name\" : \"a\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"b\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  } ]\n}\n");
    private static final Schema BROKEN_SCHEMA = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"broken\",\n  \"fields\" : [ {\n    \"name\" : \"a\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"b\",\n    \"type\" : [ \"null\", \"int\" ],\n    \"default\" : null\n  }, {\n    \"name\" : \"c\",\n    \"type\" : [ \"null\", \"boolean\" ],\n    \"default\" : null\n  } ]\n}");

    @Test
    public void testCreateNewSchemaFromFieldsWithReference_NullSchema() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AvroSchemaUtils.createNewSchemaFromFieldsWithReference(null, Collections.emptyList()));
    }

    @Test
    public void testCreateNewSchemaFromFieldsWithReference_NullObjectProps() {
        String schemaStr = "{ \"type\": \"record\", \"name\": \"TestRecord\", \"fields\": [] }";
        Schema schema = new Schema.Parser().parse(schemaStr);
        Schema newSchema = AvroSchemaUtils.createNewSchemaFromFieldsWithReference((Schema)schema, Collections.emptyList());
        Assertions.assertEquals((Object)"TestRecord", (Object)newSchema.getName());
        Assertions.assertEquals((int)0, (int)newSchema.getFields().size());
    }

    @Test
    public void testCreateNewSchemaFromFieldsWithReference_WithObjectProps() {
        String schemaStr = "{ \"type\": \"record\", \"name\": \"TestRecord\", \"fields\": [], \"prop1\": \"value1\" }";
        Schema schema = new Schema.Parser().parse(schemaStr);
        schema.addProp("prop1", "value1");
        Schema.Field newField = new Schema.Field("newField", Schema.create((Schema.Type)Schema.Type.STRING), null, null);
        Schema newSchema = AvroSchemaUtils.createNewSchemaFromFieldsWithReference((Schema)schema, Collections.singletonList(newField));
        Assertions.assertEquals((Object)"TestRecord", (Object)newSchema.getName());
        Assertions.assertEquals((int)1, (int)newSchema.getFields().size());
        Assertions.assertEquals((Object)"value1", (Object)newSchema.getProp("prop1"));
        Assertions.assertEquals((Object)"newField", (Object)((Schema.Field)newSchema.getFields().get(0)).name());
    }

    @Test
    public void testIsStrictProjection() {
        Schema sourceSchema = new Schema.Parser().parse(SOURCE_SCHEMA);
        Schema projectedNestedSchema = new Schema.Parser().parse(PROJECTED_NESTED_SCHEMA_STRICT);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)projectedNestedSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)projectedNestedSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)Schema.createArray((Schema)sourceSchema), (Schema)Schema.createArray((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)Schema.createMap((Schema)sourceSchema), (Schema)Schema.createMap((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), sourceSchema}), (Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), projectedNestedSchema})));
    }

    @Test
    public void testIsCompatibleProjection() {
        Schema sourceSchema = new Schema.Parser().parse(SOURCE_SCHEMA);
        Schema projectedNestedSchema = new Schema.Parser().parse(PROJECTED_NESTED_SCHEMA_WITH_PROMOTION);
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)sourceSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)sourceSchema, (Schema)projectedNestedSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.isStrictProjectionOf((Schema)sourceSchema, (Schema)projectedNestedSchema));
        Assertions.assertFalse((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)projectedNestedSchema, (Schema)sourceSchema));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)Schema.createArray((Schema)sourceSchema), (Schema)Schema.createArray((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)Schema.createMap((Schema)sourceSchema), (Schema)Schema.createMap((Schema)projectedNestedSchema)));
        Assertions.assertTrue((boolean)AvroSchemaUtils.isCompatibleProjectionOf((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), sourceSchema}), (Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), projectedNestedSchema})));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIsCompatibleProjectionNotAllowed(boolean shouldValidate) {
        Assertions.assertThrows(SchemaCompatibilityException.class, () -> AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)SHORT_SCHEMA, (boolean)shouldValidate, (boolean)false, Collections.emptySet()));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIsCompatibleProjectionAllowed(boolean shouldValidate) {
        AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)SHORT_SCHEMA, (boolean)shouldValidate, (boolean)true, Collections.emptySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testIsCompatiblePartitionDropCols(boolean shouldValidate) {
        AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)SHORT_SCHEMA, (boolean)shouldValidate, (boolean)false, Collections.singleton("c"));
    }

    @Test
    public void testBrokenSchema() {
        Assertions.assertThrows(SchemaBackwardsCompatibilityException.class, () -> AvroSchemaUtils.checkSchemaCompatible((Schema)FULL_SCHEMA, (Schema)BROKEN_SCHEMA, (boolean)true, (boolean)false, Collections.emptySet()));
    }

    @Test
    public void testAppendFieldsToSchemaDedupNested() {
        Schema fullSchema = new Schema.Parser().parse("{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          },\n          {\n            \"name\": \"long\",\n            \"type\": [\"null\", \"long\"]\n          }\n        ]\n      }\n    },\n    {\n      \"name\": \"other\",\n      \"type\": [\"null\", \"int\"]\n    }\n  ]\n}\n");
        Schema missingFieldSchema = new Schema.Parser().parse("{\n  \"type\": \"record\",\n  \"namespace\": \"example.schema\",\n  \"name\": \"source\",\n  \"fields\": [\n    {\n      \"name\": \"number\",\n      \"type\": [\"null\", \"int\"]\n    },\n    {\n      \"name\": \"nested_record\",\n      \"type\": {\n        \"name\": \"nested\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"string\",\n            \"type\": [\"null\", \"string\"]\n          }\n        ]\n      }\n    },\n    {\n      \"name\": \"other\",\n      \"type\": [\"null\", \"int\"]\n    }\n  ]\n}\n");
        Option missingField = AvroSchemaUtils.findNestedField((Schema)fullSchema, (String)"nested_record.long");
        Assertions.assertTrue((boolean)missingField.isPresent());
        Assertions.assertEquals((Object)fullSchema, (Object)AvroSchemaUtils.appendFieldsToSchemaDedupNested((Schema)missingFieldSchema, Collections.singletonList(missingField.get())));
    }

    @Test
    public void testFindNestedFieldType() {
        Schema sourceSchema = new Schema.Parser().parse(SOURCE_SCHEMA);
        Option field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"number");
        Assertions.assertTrue((boolean)field.isPresent());
        Assertions.assertEquals((Object)Schema.Type.INT, (Object)field.get());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"nested_record.string");
        Assertions.assertTrue((boolean)field.isPresent());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)field.get());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"nested_record.long");
        Assertions.assertTrue((boolean)field.isPresent());
        Assertions.assertEquals((Object)Schema.Type.LONG, (Object)field.get());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, null);
        Assertions.assertTrue((boolean)field.isEmpty());
        field = AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"");
        Assertions.assertTrue((boolean)field.isEmpty());
        Assertions.assertThrows(HoodieAvroSchemaException.class, () -> AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"long"));
        Assertions.assertThrows(HoodieAvroSchemaException.class, () -> AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"nested_record.bool"));
        Assertions.assertThrows(HoodieAvroSchemaException.class, () -> AvroSchemaUtils.findNestedFieldType((Schema)sourceSchema, (String)"non_present_field.also_not_present"));
    }
}

