/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestHoodieListData {
    TestHoodieListData() {
    }

    private static Stream<Arguments> distinctWithKey() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)"k1", (Object)1), Pair.of((Object)"k2", (Object)2)), Arrays.asList(Pair.of((Object)"k1", (Object)1), Pair.of((Object)"k1", (Object)10), Pair.of((Object)"k1", (Object)100), Pair.of((Object)"k2", (Object)2))}));
    }

    @ParameterizedTest
    @MethodSource
    void distinctWithKey(List<Pair<String, Integer>> expected, List<Pair<String, Integer>> originalList) {
        List distinctList = HoodieListData.eager(originalList).distinctWithKey(Pair::getLeft, 1).collectAsList();
        Assertions.assertEquals(expected, (Object)distinctList);
    }

    @Test
    void testEagerSemantic() {
        List<String> sourceList = Arrays.asList("quick", "brown", "fox");
        HoodieListData originalListData = HoodieListData.eager(sourceList);
        HoodieData lengthsListData = originalListData.map(String::length);
        List expectedLengths = sourceList.stream().map(String::length).collect(Collectors.toList());
        Assertions.assertEquals(expectedLengths, (Object)lengthsListData.collectAsList());
        Assertions.assertEquals((long)3L, (long)originalListData.count());
        Assertions.assertEquals(sourceList, (Object)originalListData.collectAsList());
    }

    @Test
    public void testGetNumPartitions() {
        HoodieListData listData = HoodieListData.eager(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()));
        Assertions.assertEquals((int)1, (int)listData.getNumPartitions());
    }

    @Test
    public void testIsEmpty() {
        HoodieListData listData = HoodieListData.eager(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()));
        Assertions.assertFalse((boolean)listData.isEmpty());
        HoodieListData emptyListData = HoodieListData.eager(Collections.emptyList());
        Assertions.assertTrue((boolean)emptyListData.isEmpty());
        listData = HoodieListData.lazy(IntStream.rangeClosed(0, 100).boxed().collect(Collectors.toList()));
        Assertions.assertFalse((boolean)listData.isEmpty());
        emptyListData = HoodieListData.lazy(Collections.emptyList());
        Assertions.assertTrue((boolean)emptyListData.isEmpty());
    }
}

