/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListPairData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieListDataPairData {
    private static final String KEY1 = "key1";
    private static final String KEY2 = "key2";
    private static final String KEY3 = "key3";
    private static final String KEY4 = "key4";
    private static final String KEY5 = "key5";
    private static final String STRING_VALUE1 = "value1";
    private static final String STRING_VALUE2 = "value2";
    private static final String STRING_VALUE3 = "value3";
    private static final String STRING_VALUE4 = "value4";
    private static final String STRING_VALUE5 = "value5";
    private static final String STRING_VALUE6 = "value6";
    private static final int INTEGER_VALUE1 = 1;
    private static final int INTEGER_VALUE2 = 2;
    private static final int INTEGER_VALUE3 = 3;
    private static final int INTEGER_VALUE4 = 4;
    private static final int INTEGER_VALUE5 = 5;
    private List<Pair<String, String>> testPairs;
    private HoodiePairData<String, String> testHoodiePairData;

    @BeforeEach
    public void setup() {
        this.testPairs = TestHoodieListDataPairData.constructPairs();
        this.testHoodiePairData = HoodieListPairData.lazy(this.testPairs);
    }

    @Test
    public void testKeys() {
        this.assertHoodieDataEquals(Arrays.asList(KEY1, KEY1, KEY2, KEY2, KEY3, KEY4), this.testHoodiePairData.keys());
    }

    @Test
    public void testValues() {
        this.assertHoodieDataEquals(Arrays.asList(STRING_VALUE1, STRING_VALUE2, STRING_VALUE3, STRING_VALUE4, STRING_VALUE5, STRING_VALUE6), this.testHoodiePairData.values());
    }

    @Test
    public void testCount() {
        Assertions.assertEquals((long)6L, (long)this.testHoodiePairData.count());
    }

    @Test
    public void testCountByKey() {
        HashMap<String, Long> expectedResultMap = new HashMap<String, Long>();
        expectedResultMap.put(KEY1, 2L);
        expectedResultMap.put(KEY2, 2L);
        expectedResultMap.put(KEY3, 1L);
        expectedResultMap.put(KEY4, 1L);
        Assertions.assertEquals(expectedResultMap, (Object)this.testHoodiePairData.countByKey());
    }

    @Test
    public void testMap() {
        this.assertHoodieDataEquals(Arrays.asList("key1,value1", "key1,value2", "key2,value3", "key2,value4", "key3,value5", "key4,value6"), this.testHoodiePairData.map((SerializableFunction & Serializable)pair -> (String)pair.getKey() + "," + (String)pair.getValue()));
    }

    @Test
    public void testMapToPair() {
        HashMap<String, List<Integer>> expectedResultMap = new HashMap<String, List<Integer>>();
        expectedResultMap.put("key10", Arrays.asList(1, 2));
        expectedResultMap.put("key20", Arrays.asList(3, 4));
        expectedResultMap.put("key30", Arrays.asList(5));
        expectedResultMap.put("key40", Arrays.asList(6));
        Assertions.assertEquals(expectedResultMap, TestHoodieListDataPairData.toMap(this.testHoodiePairData.mapToPair((SerializablePairFunction & Serializable)pair -> {
            String value = (String)pair.getValue();
            return new ImmutablePair((Object)((String)pair.getKey() + "0"), (Object)Integer.parseInt(String.valueOf(value.charAt(value.length() - 1))));
        })));
    }

    private static Stream<Arguments> testReduceByKey() {
        return Stream.of(Arguments.of((Object[])new Object[]{CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)1, (Object)CollectionUtils.createImmutableList((Object[])new Integer[]{1001})), Pair.of((Object)2, (Object)CollectionUtils.createImmutableList((Object[])new Integer[]{2001})), Pair.of((Object)3, (Object)CollectionUtils.createImmutableList((Object[])new Integer[]{3001}))}), CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)1, (Object)CollectionUtils.createImmutableList((Object[])new Integer[]{1001, 1002, 1003})), Pair.of((Object)2, (Object)CollectionUtils.createImmutableList((Object[])new Integer[]{2001, 2002})), Pair.of((Object)3, (Object)CollectionUtils.createImmutableList((Object[])new Integer[]{3001})), Pair.of((Object)4, (Object)CollectionUtils.createImmutableList((Object[])new Object[0]))})}));
    }

    @ParameterizedTest
    @MethodSource
    public void testReduceByKey(Map<Integer, List<Integer>> expected, Map<Integer, List<Integer>> original) {
        HoodiePairData reduced = HoodieListPairData.lazy(original).reduceByKey((SerializableBiFunction & Serializable)(a, b) -> a, 1);
        Assertions.assertEquals(expected, TestHoodieListDataPairData.toMap(reduced));
    }

    @Test
    public void testLeftOuterJoinSingleValuePerKey() {
        HoodieListPairData pairData1 = HoodieListPairData.lazy(Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)STRING_VALUE1), ImmutablePair.of((Object)KEY2, (Object)STRING_VALUE2), ImmutablePair.of((Object)KEY3, (Object)STRING_VALUE3), ImmutablePair.of((Object)KEY4, (Object)STRING_VALUE4)));
        HoodieListPairData pairData2 = HoodieListPairData.lazy(Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)1), ImmutablePair.of((Object)KEY2, (Object)2), ImmutablePair.of((Object)KEY5, (Object)3)));
        HashMap<String, List<Pair>> expectedResultMap = new HashMap<String, List<Pair>>();
        expectedResultMap.put(KEY1, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE1, (Object)Option.of((Object)1))));
        expectedResultMap.put(KEY2, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE2, (Object)Option.of((Object)2))));
        expectedResultMap.put(KEY3, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE3, (Object)Option.empty())));
        expectedResultMap.put(KEY4, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE4, (Object)Option.empty())));
        Assertions.assertEquals(expectedResultMap, TestHoodieListDataPairData.toMap(pairData1.leftOuterJoin((HoodiePairData)pairData2)));
    }

    @Test
    public void testLeftOuterJoinMultipleValuesPerKey() {
        HoodieListPairData otherPairData = HoodieListPairData.lazy(Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)1), ImmutablePair.of((Object)KEY2, (Object)2), ImmutablePair.of((Object)KEY2, (Object)3), ImmutablePair.of((Object)KEY3, (Object)4), ImmutablePair.of((Object)KEY5, (Object)5)));
        HashMap<String, List<Pair>> expectedResultMap = new HashMap<String, List<Pair>>();
        expectedResultMap.put(KEY1, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE1, (Object)Option.of((Object)1)), ImmutablePair.of((Object)STRING_VALUE2, (Object)Option.of((Object)1))));
        expectedResultMap.put(KEY2, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE3, (Object)Option.of((Object)2)), ImmutablePair.of((Object)STRING_VALUE3, (Object)Option.of((Object)3)), ImmutablePair.of((Object)STRING_VALUE4, (Object)Option.of((Object)2)), ImmutablePair.of((Object)STRING_VALUE4, (Object)Option.of((Object)3))));
        expectedResultMap.put(KEY3, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE5, (Object)Option.of((Object)4))));
        expectedResultMap.put(KEY4, Arrays.asList(ImmutablePair.of((Object)STRING_VALUE6, (Object)Option.empty())));
        Assertions.assertEquals(expectedResultMap, TestHoodieListDataPairData.toMap(this.testHoodiePairData.leftOuterJoin((HoodiePairData)otherPairData)));
    }

    @Test
    void testEagerSemantic() {
        List sourceList = Stream.of("quick", "brown", "fox").map(s -> Pair.of((Object)s, (Object)s.length())).collect(Collectors.toList());
        HoodieListPairData originalListData = HoodieListPairData.eager(sourceList);
        HoodieData lengthsListData = originalListData.values();
        List expectedLengths = sourceList.stream().map(Pair::getValue).collect(Collectors.toList());
        Assertions.assertEquals(expectedLengths, (Object)lengthsListData.collectAsList());
        Assertions.assertEquals((long)3L, (long)originalListData.count());
        Assertions.assertEquals(sourceList, (Object)originalListData.collectAsList());
    }

    @Test
    public void testJoin() {
        List<Pair> leftData = Arrays.asList(Pair.of((Object)"a", (Object)STRING_VALUE1), Pair.of((Object)"b", (Object)STRING_VALUE2), Pair.of((Object)"c", (Object)STRING_VALUE3));
        List<Pair> rightData = Arrays.asList(Pair.of((Object)"a", (Object)"rValue1"), Pair.of((Object)"a", (Object)"rValue2"), Pair.of((Object)"b", (Object)"rValue3"), Pair.of((Object)"d", (Object)"rValue4"));
        HoodieListPairData left = new HoodieListPairData(leftData.stream(), true);
        HoodieListPairData right = new HoodieListPairData(rightData.stream(), true);
        HoodiePairData joined = left.join((HoodiePairData)right);
        List<Pair> expected = Arrays.asList(Pair.of((Object)"a", (Object)Pair.of((Object)STRING_VALUE1, (Object)"rValue1")), Pair.of((Object)"a", (Object)Pair.of((Object)STRING_VALUE1, (Object)"rValue2")), Pair.of((Object)"b", (Object)Pair.of((Object)STRING_VALUE2, (Object)"rValue3")));
        List result = joined.collectAsList();
        Assertions.assertEquals(expected, (Object)result, (String)"Join result does not match expected output");
    }

    private static List<Pair<String, String>> constructPairs() {
        return Arrays.asList(ImmutablePair.of((Object)KEY1, (Object)STRING_VALUE1), ImmutablePair.of((Object)KEY1, (Object)STRING_VALUE2), ImmutablePair.of((Object)KEY2, (Object)STRING_VALUE3), ImmutablePair.of((Object)KEY2, (Object)STRING_VALUE4), ImmutablePair.of((Object)KEY3, (Object)STRING_VALUE5), ImmutablePair.of((Object)KEY4, (Object)STRING_VALUE6));
    }

    private static <K, V> Map<K, List<V>> toMap(HoodiePairData<K, V> pairData) {
        return ((List)pairData.groupByKey().get()).stream().collect(Collectors.toMap(p -> p.getKey(), p -> StreamSupport.stream(((Iterable)p.getValue()).spliterator(), false).collect(Collectors.toList())));
    }

    private static <V> void addPairsToMap(Map<String, List<V>> map, List<Pair<String, V>> pairs) {
        for (Pair<String, V> pair : pairs) {
            String key = (String)pair.getKey();
            Object value = pair.getValue();
            List list = map.computeIfAbsent(key, k -> new ArrayList());
            list.add(value);
        }
    }

    private <T> void assertHoodieDataEquals(List<T> expectedList, HoodieData<T> hoodieData) {
        this.assertHoodieDataEquals(expectedList, hoodieData, Comparator.naturalOrder());
    }

    private <T> void assertHoodieDataEquals(List<T> expectedList, HoodieData<T> hoodieData, Comparator comparator) {
        Assertions.assertEquals(expectedList, hoodieData.collectAsList().stream().sorted(comparator).collect(Collectors.toList()));
    }
}

