/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAWSDmsAvroPayload {
    private static final String AVRO_SCHEMA_STRING = "{\"type\": \"record\",\"name\": \"events\",\"fields\": [ {\"name\": \"field1\", \"type\" : \"int\"},{\"name\": \"Op\", \"type\": \"string\"}]}";

    @Test
    public void testInsert() {
        Schema avroSchema = new Schema.Parser().parse(AVRO_SCHEMA_STRING);
        GenericData.Record record = new GenericData.Record(avroSchema);
        Properties properties = new Properties();
        record.put("field1", (Object)0);
        record.put("Op", (Object)"I");
        AWSDmsAvroPayload payload = new AWSDmsAvroPayload(Option.of((Object)record));
        try {
            Option outputPayload = payload.getInsertValue(avroSchema, properties);
            Assertions.assertTrue(((Integer)((IndexedRecord)outputPayload.get()).get(0) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)((IndexedRecord)outputPayload.get()).get(1).toString().equals("I"));
        }
        catch (Exception e) {
            Assertions.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testUpdate() {
        Schema avroSchema = new Schema.Parser().parse(AVRO_SCHEMA_STRING);
        GenericData.Record newRecord = new GenericData.Record(avroSchema);
        Properties properties = new Properties();
        newRecord.put("field1", (Object)1);
        newRecord.put("Op", (Object)"U");
        GenericData.Record oldRecord = new GenericData.Record(avroSchema);
        oldRecord.put("field1", (Object)0);
        oldRecord.put("Op", (Object)"I");
        AWSDmsAvroPayload payload = new AWSDmsAvroPayload(Option.of((Object)newRecord));
        try {
            Option outputPayload = payload.combineAndGetUpdateValue((IndexedRecord)oldRecord, avroSchema, properties);
            Assertions.assertTrue(((Integer)((IndexedRecord)outputPayload.get()).get(0) == 1 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)((IndexedRecord)outputPayload.get()).get(1).toString().equals("U"));
        }
        catch (Exception e) {
            Assertions.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testDelete() {
        Schema avroSchema = new Schema.Parser().parse(AVRO_SCHEMA_STRING);
        GenericData.Record deleteRecord = new GenericData.Record(avroSchema);
        Properties properties = new Properties();
        deleteRecord.put("field1", (Object)2);
        deleteRecord.put("Op", (Object)"D");
        GenericData.Record oldRecord = new GenericData.Record(avroSchema);
        oldRecord.put("field1", (Object)2);
        oldRecord.put("Op", (Object)"U");
        AWSDmsAvroPayload payload = new AWSDmsAvroPayload(Option.of((Object)deleteRecord));
        try {
            Option outputPayload = payload.combineAndGetUpdateValue((IndexedRecord)oldRecord, avroSchema, properties);
            Assertions.assertFalse((boolean)outputPayload.isPresent());
            Assertions.assertTrue((boolean)payload.isDeleted(avroSchema, properties));
        }
        catch (Exception e) {
            Assertions.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testDeleteWithEmptyPayLoad() {
        Schema avroSchema = new Schema.Parser().parse(AVRO_SCHEMA_STRING);
        Properties properties = new Properties();
        GenericData.Record oldRecord = new GenericData.Record(avroSchema);
        oldRecord.put("field1", (Object)2);
        oldRecord.put("Op", (Object)"U");
        AWSDmsAvroPayload payload = new AWSDmsAvroPayload(Option.empty());
        try {
            Option outputPayload = payload.combineAndGetUpdateValue((IndexedRecord)oldRecord, avroSchema, properties);
            Assertions.assertFalse((boolean)outputPayload.isPresent());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testPreCombineWithDelete() {
        Schema avroSchema = new Schema.Parser().parse(AVRO_SCHEMA_STRING);
        GenericData.Record deleteRecord = new GenericData.Record(avroSchema);
        Properties properties = new Properties();
        deleteRecord.put("field1", (Object)4);
        deleteRecord.put("Op", (Object)"D");
        GenericData.Record oldRecord = new GenericData.Record(avroSchema);
        oldRecord.put("field1", (Object)3);
        oldRecord.put("Op", (Object)"I");
        AWSDmsAvroPayload payload = new AWSDmsAvroPayload(Option.of((Object)deleteRecord));
        AWSDmsAvroPayload insertPayload = new AWSDmsAvroPayload(Option.of((Object)oldRecord));
        OverwriteWithLatestAvroPayload output = payload.preCombine((OverwriteWithLatestAvroPayload)insertPayload);
        Assertions.assertEquals((Object)payload, (Object)output);
    }
}

