/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.PreCombineTestUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class TestDefaultHoodieRecordPayload {
    private Schema schema;
    private Properties props;

    @BeforeEach
    public void setUp() throws Exception {
        this.schema = Schema.createRecord(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("partition", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("ts", Schema.create((Schema.Type)Schema.Type.LONG), "", null), new Schema.Field("_hoodie_is_deleted", Schema.create((Schema.Type)Schema.Type.BOOLEAN), "", (Object)false)));
        this.props = new Properties();
        this.props.setProperty("hoodie.payload.ordering.field", "ts");
        this.props.setProperty("hoodie.payload.event.time.field", "ts");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.hudi.common.testutils.PreCombineTestUtils#configurePreCombine"})
    public void testActiveRecords(String key) throws IOException {
        PreCombineTestUtils.setPreCombineConfig(this.props, key, "ts");
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"2");
        record2.put("partition", (Object)"partition1");
        record2.put("ts", (Object)1L);
        record2.put("_hoodie_is_deleted", (Object)false);
        DefaultHoodieRecordPayload payload1 = new DefaultHoodieRecordPayload((GenericRecord)record1, (Comparable)Integer.valueOf(1));
        DefaultHoodieRecordPayload payload2 = new DefaultHoodieRecordPayload((GenericRecord)record2, (Comparable)Integer.valueOf(2));
        Assertions.assertEquals((Object)payload1.preCombine((HoodieRecordPayload)payload2, this.props), (Object)payload2);
        Assertions.assertEquals((Object)payload2.preCombine((HoodieRecordPayload)payload1, this.props), (Object)payload2);
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema, this.props).get());
        Assertions.assertEquals((Object)record2, (Object)payload2.getInsertValue(this.schema, this.props).get());
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)record2, this.schema, this.props).get(), (Object)record2);
        Assertions.assertEquals((Object)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, this.props).get(), (Object)record2);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.hudi.common.testutils.PreCombineTestUtils#configurePreCombine"})
    public void testDeletedRecord(String key) throws IOException {
        PreCombineTestUtils.setPreCombineConfig(this.props, key, "ts");
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record delRecord1 = new GenericData.Record(this.schema);
        delRecord1.put("id", (Object)"2");
        delRecord1.put("partition", (Object)"partition1");
        delRecord1.put("ts", (Object)1L);
        delRecord1.put("_hoodie_is_deleted", (Object)true);
        DefaultHoodieRecordPayload payload1 = new DefaultHoodieRecordPayload((GenericRecord)record1, (Comparable)Integer.valueOf(1));
        DefaultHoodieRecordPayload payload2 = new DefaultHoodieRecordPayload((GenericRecord)delRecord1, (Comparable)Integer.valueOf(2));
        Assertions.assertFalse((boolean)payload1.isDeleted(this.schema, this.props));
        Assertions.assertTrue((boolean)payload2.isDeleted(this.schema, this.props));
        Assertions.assertEquals((Object)payload1.preCombine((HoodieRecordPayload)payload2, this.props), (Object)payload2);
        Assertions.assertEquals((Object)payload2.preCombine((HoodieRecordPayload)payload1, this.props), (Object)payload2);
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema, this.props).get());
        Assertions.assertFalse((boolean)payload2.getInsertValue(this.schema, this.props).isPresent());
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)delRecord1, this.schema, this.props).get(), (Object)delRecord1);
        Assertions.assertFalse((boolean)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, this.props).isPresent());
    }

    @Test
    public void testDeleteKey() throws IOException {
        this.props.setProperty("hoodie.payload.delete.field", "ts");
        this.props.setProperty("hoodie.payload.delete.marker", String.valueOf(1L));
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"1");
        record.put("partition", (Object)"partition0");
        record.put("ts", (Object)0L);
        record.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record delRecord = new GenericData.Record(this.schema);
        delRecord.put("id", (Object)"2");
        delRecord.put("partition", (Object)"partition1");
        delRecord.put("ts", (Object)1L);
        delRecord.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record defaultDeleteRecord = new GenericData.Record(this.schema);
        defaultDeleteRecord.put("id", (Object)"2");
        defaultDeleteRecord.put("partition", (Object)"partition1");
        defaultDeleteRecord.put("ts", (Object)2L);
        defaultDeleteRecord.put("_hoodie_is_deleted", (Object)true);
        DefaultHoodieRecordPayload payload = new DefaultHoodieRecordPayload((GenericRecord)record, (Comparable)Integer.valueOf(1));
        DefaultHoodieRecordPayload deletePayload = new DefaultHoodieRecordPayload((GenericRecord)delRecord, (Comparable)Integer.valueOf(2));
        DefaultHoodieRecordPayload defaultDeletePayload = new DefaultHoodieRecordPayload((GenericRecord)defaultDeleteRecord, (Comparable)Integer.valueOf(2));
        Assertions.assertFalse((boolean)payload.isDeleted(this.schema, this.props));
        Assertions.assertTrue((boolean)deletePayload.isDeleted(this.schema, this.props));
        Assertions.assertFalse((boolean)defaultDeletePayload.isDeleted(this.schema, this.props));
        Assertions.assertEquals((Object)record, (Object)payload.getInsertValue(this.schema, this.props).get());
        Assertions.assertFalse((boolean)deletePayload.getInsertValue(this.schema, this.props).isPresent());
        Assertions.assertTrue((boolean)defaultDeletePayload.getInsertValue(this.schema, this.props).isPresent());
        Assertions.assertEquals((Object)delRecord, (Object)payload.combineAndGetUpdateValue((IndexedRecord)delRecord, this.schema, this.props).get());
        Assertions.assertEquals((Object)defaultDeleteRecord, (Object)payload.combineAndGetUpdateValue((IndexedRecord)defaultDeleteRecord, this.schema, this.props).get());
        Assertions.assertFalse((boolean)deletePayload.combineAndGetUpdateValue((IndexedRecord)record, this.schema, this.props).isPresent());
    }

    @Test
    public void testDeleteKeyConfiguration() throws IOException {
        this.props.setProperty("hoodie.payload.delete.field", "ts");
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"1");
        record.put("partition", (Object)"partition0");
        record.put("ts", (Object)0L);
        record.put("_hoodie_is_deleted", (Object)false);
        DefaultHoodieRecordPayload payload = new DefaultHoodieRecordPayload((GenericRecord)record, (Comparable)Integer.valueOf(1));
        try {
            payload.getInsertValue(this.schema, this.props).get();
            Assertions.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            payload = new DefaultHoodieRecordPayload((GenericRecord)record, (Comparable)Integer.valueOf(1));
            payload.combineAndGetUpdateValue((IndexedRecord)record, this.schema, this.props).get();
            Assertions.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEmptyMetadata() {
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"1");
        record.put("partition", (Object)"partition0");
        record.put("ts", (Object)0L);
        record.put("_hoodie_is_deleted", (Object)false);
        DefaultHoodieRecordPayload payload = new DefaultHoodieRecordPayload(Option.of((Object)record));
        Assertions.assertFalse((boolean)payload.getMetadata().isPresent());
    }

    @ParameterizedTest
    @ValueSource(longs={1L, 1612542030000L})
    public void testGetEventTimeInMetadata(long eventTime) throws IOException {
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition0");
        record2.put("ts", (Object)eventTime);
        record2.put("_hoodie_is_deleted", (Object)false);
        DefaultHoodieRecordPayload payload2 = new DefaultHoodieRecordPayload((GenericRecord)record2, (Comparable)Long.valueOf(eventTime));
        payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, this.props);
        Assertions.assertTrue((boolean)payload2.getMetadata().isPresent());
        Assertions.assertEquals((long)eventTime, (long)Long.parseLong((String)((Map)payload2.getMetadata().get()).get("metadata.event_time.key")));
    }

    @Test
    public void testEmptyProperty() throws IOException {
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"1");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"1");
        record2.put("partition", (Object)"partition0");
        record2.put("ts", (Object)1L);
        record2.put("_hoodie_is_deleted", (Object)false);
        DefaultHoodieRecordPayload payload = new DefaultHoodieRecordPayload(Option.of((Object)record1));
        Properties properties = new Properties();
        payload.getInsertValue(this.schema, properties);
        payload.combineAndGetUpdateValue((IndexedRecord)record2, this.schema, properties);
    }

    @ParameterizedTest
    @ValueSource(longs={1L, 1612542030000L})
    public void testGetEventTimeInMetadataForInserts(long eventTime) throws IOException {
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"1");
        record.put("partition", (Object)"partition0");
        record.put("ts", (Object)eventTime);
        record.put("_hoodie_is_deleted", (Object)false);
        DefaultHoodieRecordPayload payload = new DefaultHoodieRecordPayload((GenericRecord)record, (Comparable)Long.valueOf(eventTime));
        payload.getInsertValue(this.schema, this.props);
        Assertions.assertTrue((boolean)payload.getMetadata().isPresent());
        Assertions.assertEquals((long)eventTime, (long)Long.parseLong((String)((Map)payload.getMetadata().get()).get("metadata.event_time.key")));
    }
}

