/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieDeltaWriteStat {
    @Test
    public void testBaseFileAndLogFiles() {
        HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
        String baseFile = "file1" + ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
        String logFile1 = ".log1.log";
        String logFile2 = ".log2.log";
        writeStat.setBaseFile(baseFile);
        writeStat.addLogFiles(logFile1);
        writeStat.addLogFiles(logFile2);
        Assertions.assertTrue((boolean)writeStat.getLogFiles().contains(logFile1));
        Assertions.assertTrue((boolean)writeStat.getLogFiles().contains(logFile2));
        Assertions.assertEquals((Object)baseFile, (Object)writeStat.getBaseFile());
        writeStat.setLogFiles(new ArrayList());
        Assertions.assertTrue((boolean)writeStat.getLogFiles().isEmpty());
    }

    @Test
    void testGetHoodieDeltaWriteStatFromPreviousStat() {
        HoodieDeltaWriteStat prevStat = this.createDeltaWriteStat("part", "fileId", "888", "base", Collections.singletonList("log1"));
        HoodieDeltaWriteStat stat = prevStat.copy();
        Assertions.assertEquals((Object)prevStat.getPartitionPath(), (Object)stat.getPartitionPath());
        Assertions.assertEquals((Object)prevStat.getFileId(), (Object)stat.getFileId());
        Assertions.assertEquals((Object)prevStat.getPrevCommit(), (Object)stat.getPrevCommit());
        Assertions.assertEquals((Object)prevStat.getBaseFile(), (Object)stat.getBaseFile());
        Assertions.assertEquals((int)1, (int)stat.getLogFiles().size());
        Assertions.assertEquals(prevStat.getLogFiles().get(0), stat.getLogFiles().get(0));
    }

    private HoodieDeltaWriteStat createDeltaWriteStat(String partition, String fileId, String prevCommit, String baseFile, List<String> logFiles) {
        HoodieDeltaWriteStat writeStat1 = new HoodieDeltaWriteStat();
        writeStat1.setPartitionPath(partition);
        writeStat1.setFileId(fileId);
        writeStat1.setPrevCommit(prevCommit);
        writeStat1.setBaseFile(baseFile);
        writeStat1.setLogFiles(logFiles);
        return writeStat1;
    }
}

