/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieLogFile {
    private final String pathStr = "file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1";
    private final String fileId = "136281f3-c24e-423b-a65a-95dbfbddce1d";
    private final String baseCommitTime = "100";
    private final int logVersion = 2;
    private final String writeToken = "1-0-1";
    private final String fileExtension = "log";
    private final int length = 10;
    private final short blockReplication = (short)2;
    private final long blockSize = 1000000L;

    @Test
    void createFromLogFile() {
        StoragePathInfo pathInfo = new StoragePathInfo(new StoragePath("file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1"), 10L, false, 2, 1000000L, 0L);
        HoodieLogFile hoodieLogFile = new HoodieLogFile(pathInfo);
        this.assertFileGetters(pathInfo, new HoodieLogFile(hoodieLogFile), 10L);
    }

    @Test
    void createFromFileStatus() {
        StoragePathInfo pathInfo = new StoragePathInfo(new StoragePath("file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1"), 10L, false, 2, 1000000L, 0L);
        HoodieLogFile hoodieLogFile = new HoodieLogFile(pathInfo);
        this.assertFileGetters(pathInfo, hoodieLogFile, 10L);
    }

    @Test
    void createFromPath() {
        HoodieLogFile hoodieLogFile = new HoodieLogFile(new StoragePath("file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1"));
        this.assertFileGetters(null, hoodieLogFile, -1L);
    }

    @Test
    void createFromPathAndLength() {
        HoodieLogFile hoodieLogFile = new HoodieLogFile(new StoragePath("file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1"), 10L);
        this.assertFileGetters(null, hoodieLogFile, 10L);
    }

    @Test
    void createFromString() {
        HoodieLogFile hoodieLogFile = new HoodieLogFile("file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1");
        this.assertFileGetters(null, hoodieLogFile, -1L);
    }

    @Test
    void createFromStringWithSuffix() {
        String suffix = ".cdc";
        String pathWithSuffix = "file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1" + suffix;
        HoodieLogFile hoodieLogFile = new HoodieLogFile(pathWithSuffix);
        this.assertFileGetters(pathWithSuffix, null, hoodieLogFile, -1L, suffix);
    }

    private void assertFileGetters(StoragePathInfo pathInfo, HoodieLogFile hoodieLogFile, long fileLength) {
        this.assertFileGetters("file:///tmp/hoodie/2021/01/01/.136281f3-c24e-423b-a65a-95dbfbddce1d_100.log.2_1-0-1", pathInfo, hoodieLogFile, fileLength, "");
    }

    private void assertFileGetters(String pathStr, StoragePathInfo pathInfo, HoodieLogFile hoodieLogFile, long fileLength, String suffix) {
        Assertions.assertEquals((Object)"136281f3-c24e-423b-a65a-95dbfbddce1d", (Object)hoodieLogFile.getFileId());
        Assertions.assertEquals((Object)"100", (Object)hoodieLogFile.getDeltaCommitTime());
        Assertions.assertEquals((int)2, (int)hoodieLogFile.getLogVersion());
        Assertions.assertEquals((Object)"1-0-1", (Object)hoodieLogFile.getLogWriteToken());
        Assertions.assertEquals((Object)"log", (Object)hoodieLogFile.getFileExtension());
        Assertions.assertEquals((Object)new StoragePath(pathStr), (Object)hoodieLogFile.getPath());
        Assertions.assertEquals((long)fileLength, (long)hoodieLogFile.getFileSize());
        Assertions.assertEquals((Object)pathInfo, (Object)hoodieLogFile.getPathInfo());
        Assertions.assertEquals((Object)suffix, (Object)hoodieLogFile.getSuffix());
    }
}

