/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieMetadataRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieMetadataRecordMerger {
    private HoodieTestDataGenerator dataGen;

    @BeforeEach
    public void setUp() {
        this.dataGen = new HoodieTestDataGenerator();
    }

    @AfterEach
    public void cleanUp() {
        if (this.dataGen != null) {
            this.dataGen = null;
        }
    }

    @Test
    public void testFullOuterMerge() throws IOException {
        List<HoodieRecord> newRecordList = this.dataGen.generateInserts("000", 1);
        List<HoodieRecord> updateRecordList = this.dataGen.generateUpdates("0001", newRecordList);
        HoodieMetadataRecordMerger recordMerger = new HoodieMetadataRecordMerger();
        List mergedRecords = recordMerger.fullOuterMerge(newRecordList.get(0), HoodieTestDataGenerator.AVRO_SCHEMA, updateRecordList.get(0), HoodieTestDataGenerator.AVRO_SCHEMA, new TypedProperties());
        Assertions.assertEquals((int)2, (int)mergedRecords.size());
        Assertions.assertEquals((Object)updateRecordList.get(0), (Object)((Pair)mergedRecords.get(1)).getLeft());
    }
}

