/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TestHoodieCommitMetadata;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.junit.jupiter.api.Test;

public class TestHoodieReplaceCommitMetadata {
    private static final List<String> EXPECTED_FIELD_NAMES = Arrays.asList("partitionToWriteStats", "partitionToReplaceFileIds", "compacted", "extraMetadata", "operationType");

    @Test
    public void verifyFieldNamesInReplaceCommitMetadata() throws IOException {
        List<HoodieWriteStat> fakeHoodieWriteStats = HoodieTestUtils.generateFakeHoodieWriteStat(10);
        HoodieReplaceCommitMetadata commitMetadata = new HoodieReplaceCommitMetadata();
        fakeHoodieWriteStats.forEach(stat -> {
            commitMetadata.addWriteStat(stat.getPartitionPath(), stat);
            commitMetadata.addReplaceFileId(stat.getPartitionPath(), stat.getFileId());
        });
        TestHoodieCommitMetadata.verifyMetadataFieldNames((HoodieCommitMetadata)commitMetadata, EXPECTED_FIELD_NAMES);
    }
}

