/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class TestFileGroupRecordBuffer {
    private String schemaString = "{\"type\": \"record\",\"name\": \"EventRecord\",\"namespace\": \"com.example.avro\",\"fields\": [{\"name\": \"id\", \"type\": \"string\"},{\"name\": \"ts\", \"type\": \"long\"},{\"name\": \"op\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\"}]}";
    private Schema schema = new Schema.Parser().parse(this.schemaString);
    private final HoodieReaderContext readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
    private final FileGroupReaderSchemaHandler schemaHandler = (FileGroupReaderSchemaHandler)Mockito.mock(FileGroupReaderSchemaHandler.class);
    private HoodieTableMetaClient hoodieTableMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private Option<String> partitionNameOverrideOpt = Option.empty();
    private Option<String[]> partitionPathFieldOpt = Option.empty();
    private TypedProperties props = new TypedProperties();
    private HoodieReadStats readStats = (HoodieReadStats)Mockito.mock(HoodieReadStats.class);

    TestFileGroupRecordBuffer() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.readerContext.getSchemaHandler()).thenReturn((Object)this.schemaHandler);
        Mockito.when((Object)this.schemaHandler.getRequiredSchema()).thenReturn((Object)this.schema);
        Mockito.when((Object)this.readerContext.getRecordMerger()).thenReturn((Object)Option.empty());
    }

    @Test
    void testGetOrderingValueFromDeleteRecord() {
        HoodieReaderContext readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
        DeleteRecord deleteRecord = (DeleteRecord)Mockito.mock(DeleteRecord.class);
        this.mockDeleteRecord(deleteRecord, null);
        Assertions.assertEquals((Object)0, (Object)FileGroupRecordBuffer.getOrderingValue((HoodieReaderContext)readerContext, (DeleteRecord)deleteRecord));
        this.mockDeleteRecord(deleteRecord, Integer.valueOf(0));
        Assertions.assertEquals((Object)0, (Object)FileGroupRecordBuffer.getOrderingValue((HoodieReaderContext)readerContext, (DeleteRecord)deleteRecord));
        String orderingValue = "xyz";
        String convertedValue = "_xyz";
        this.mockDeleteRecord(deleteRecord, (Comparable)((Object)orderingValue));
        Mockito.when((Object)readerContext.convertValueToEngineType((Comparable)((Object)orderingValue))).thenReturn((Object)convertedValue);
        Assertions.assertEquals((Object)convertedValue, (Object)FileGroupRecordBuffer.getOrderingValue((HoodieReaderContext)readerContext, (DeleteRecord)deleteRecord));
    }

    @ParameterizedTest
    @CsvSource(value={"true, true, true, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, false, false, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, true, false, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, false, true, EVENT_TIME_ORDERING, false, EIGHT, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, true, true, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, false, false, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, true, false, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, false, true, COMMIT_TIME_ORDERING, false, EIGHT, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, true, true, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, false, false, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, true, false, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, false, true, CUSTOM, false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, true, true, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, false, false, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, true, false, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "false, false, true, , false, EIGHT, 00000000-0000-0000-0000-000000000000", "true, true, true, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, false, false, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, true, false, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "false, false, true, EVENT_TIME_ORDERING, false, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "true, true, true, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, false, false, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, true, false, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "false, false, true, COMMIT_TIME_ORDERING, false, SIX, ce9acb64-bde0-424c-9b91-f6ebba25356d", "true, true, true, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "true, false, false, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "false, true, false, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "false, false, true, CUSTOM, false, SIX, 00000000-0000-0000-0000-000000000000", "true, true, true, , false, SIX, 00000000-0000-0000-0000-000000000000", "true, false, false, , false, SIX, 00000000-0000-0000-0000-000000000000", "false, true, false, , false, SIX, 00000000-0000-0000-0000-000000000000", "false, false, true, , false, SIX, 00000000-0000-0000-0000-000000000000", "true, true, true, COMMIT_TIME_ORDERING, true, SIX, eeb8d96f-b1e4-49fd-bbf8-28ac514178e5"})
    public void testSchemaForMandatoryFields(boolean setPrecombine, boolean addHoodieIsDeleted, boolean addCustomDeleteMarker, RecordMergeMode mergeMode, boolean isProjectionCompatible, HoodieTableVersion tableVersion, String mergeStrategyId) {
        HoodieReaderContext readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
        Mockito.when((Object)readerContext.getHasBootstrapBaseFile()).thenReturn((Object)false);
        Mockito.when((Object)readerContext.getHasLogFiles()).thenReturn((Object)true);
        HoodieRecordMerger recordMerger = (HoodieRecordMerger)Mockito.mock(HoodieRecordMerger.class);
        Mockito.when((Object)readerContext.getRecordMerger()).thenReturn((Object)Option.of((Object)recordMerger));
        Mockito.when((Object)recordMerger.isProjectionCompatible()).thenReturn((Object)isProjectionCompatible);
        String preCombineField = "ts";
        String customDeleteKey = "colC";
        String customDeleteValue = "D";
        ArrayList<String> dataSchemaFields = new ArrayList<String>();
        dataSchemaFields.addAll(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, preCombineField, "colA", "colB", "colC", "colD"));
        if (addHoodieIsDeleted) {
            dataSchemaFields.add("_hoodie_is_deleted");
        }
        Schema dataSchema = this.getSchema(dataSchemaFields);
        Schema requestedSchema = this.getSchema(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD));
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)tableConfig.getRecordMergeMode()).thenReturn((Object)mergeMode);
        Mockito.when((Object)tableConfig.populateMetaFields()).thenReturn((Object)true);
        Mockito.when((Object)tableConfig.getPreCombineField()).thenReturn((Object)(setPrecombine ? preCombineField : ""));
        Mockito.when((Object)tableConfig.getTableVersion()).thenReturn((Object)tableVersion);
        if (tableConfig.getTableVersion() == HoodieTableVersion.SIX) {
            if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING) {
                Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)DefaultHoodieRecordPayload.class.getName());
            } else if (mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING) {
                Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)OverwriteWithLatestAvroPayload.class.getName());
            } else {
                Mockito.when((Object)tableConfig.getPayloadClass()).thenReturn((Object)OverwriteNonDefaultsWithLatestAvroPayload.class.getName());
            }
        }
        if (mergeMode != null) {
            Mockito.when((Object)tableConfig.getRecordMergeStrategyId()).thenReturn((Object)mergeStrategyId);
        }
        TypedProperties props = new TypedProperties();
        if (addCustomDeleteMarker) {
            props.setProperty("hoodie.payload.delete.field", customDeleteKey);
            props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        }
        ArrayList<String> expectedFields = new ArrayList<String>();
        expectedFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        expectedFields.add(HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        if (addCustomDeleteMarker) {
            expectedFields.add(customDeleteKey);
        }
        if (setPrecombine && mergeMode != RecordMergeMode.COMMIT_TIME_ORDERING) {
            expectedFields.add(preCombineField);
        }
        if (addHoodieIsDeleted) {
            expectedFields.add("_hoodie_is_deleted");
        }
        Schema expectedSchema = mergeMode == RecordMergeMode.CUSTOM && !isProjectionCompatible ? dataSchema : this.getSchema(expectedFields);
        Mockito.when((Object)recordMerger.getMandatoryFieldsForMerging(dataSchema, tableConfig, props)).thenReturn((Object)expectedFields.toArray(new String[0]));
        FileGroupReaderSchemaHandler fileGroupReaderSchemaHandler = new FileGroupReaderSchemaHandler(readerContext, dataSchema, requestedSchema, Option.empty(), tableConfig, props);
        Schema actualSchema = fileGroupReaderSchemaHandler.generateRequiredSchema();
        Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
        Assertions.assertEquals((Object)addHoodieIsDeleted, (Object)fileGroupReaderSchemaHandler.hasBuiltInDelete());
        Assertions.assertEquals((Object)(addCustomDeleteMarker ? Option.of((Object)Pair.of((Object)customDeleteKey, (Object)customDeleteValue)) : Option.empty()), (Object)fileGroupReaderSchemaHandler.getCustomDeleteMarkerKeyValue());
    }

    @ParameterizedTest
    @CsvSource(value={"true,false", "false,true"})
    void testInvalidCustomDeleteConfigs(boolean configureCustomDeleteKey, boolean configureCustomDeleteMarker) {
        HoodieReaderContext readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
        Mockito.when((Object)readerContext.getHasBootstrapBaseFile()).thenReturn((Object)false);
        Mockito.when((Object)readerContext.getHasLogFiles()).thenReturn((Object)true);
        HoodieRecordMerger recordMerger = (HoodieRecordMerger)Mockito.mock(HoodieRecordMerger.class);
        Mockito.when((Object)readerContext.getRecordMerger()).thenReturn((Object)Option.of((Object)recordMerger));
        Mockito.when((Object)recordMerger.isProjectionCompatible()).thenReturn((Object)false);
        String customDeleteKey = "colC";
        String customDeleteValue = "D";
        ArrayList<String> dataSchemaFields = new ArrayList<String>(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD, "colA", "colB", "colC", "colD"));
        Schema dataSchema = this.getSchema(dataSchemaFields);
        Schema requestedSchema = this.getSchema(Arrays.asList(HoodieRecord.RECORD_KEY_METADATA_FIELD, HoodieRecord.PARTITION_PATH_METADATA_FIELD));
        HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        TypedProperties props = new TypedProperties();
        if (configureCustomDeleteKey) {
            props.setProperty("hoodie.payload.delete.field", customDeleteKey);
        }
        if (configureCustomDeleteMarker) {
            props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        }
        Throwable exception = Assertions.assertThrows(IllegalArgumentException.class, () -> new FileGroupReaderSchemaHandler(readerContext, dataSchema, requestedSchema, Option.empty(), tableConfig, props));
        Assertions.assertEquals((Object)"Either custom delete key or marker is not specified", (Object)exception.getMessage());
    }

    private Schema getSchema(List<String> fields) {
        SchemaBuilder.FieldAssembler schemaFieldAssembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.builder().record("test_schema").namespace("test_namespace")).fields();
        for (String field : fields) {
            schemaFieldAssembler = schemaFieldAssembler.name(field).type().stringType().noDefault();
        }
        return (Schema)schemaFieldAssembler.endRecord();
    }

    private void mockDeleteRecord(DeleteRecord deleteRecord, Comparable orderingValue) {
        Mockito.when((Object)deleteRecord.getOrderingValue()).thenReturn((Object)orderingValue);
    }

    @Test
    void testIsCustomDeleteRecord() {
        String customDeleteKey = "op";
        String customDeleteValue = "d";
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"12345");
        record.put("ts", (Object)System.currentTimeMillis());
        record.put(customDeleteKey, (Object)"d");
        Mockito.when((Object)this.schemaHandler.getCustomDeleteMarkerKeyValue()).thenReturn((Object)Option.of((Object)Pair.of((Object)customDeleteKey, (Object)customDeleteValue)));
        KeyBasedFileGroupRecordBuffer keyBasedBuffer = new KeyBasedFileGroupRecordBuffer(this.readerContext, this.hoodieTableMetaClient, RecordMergeMode.COMMIT_TIME_ORDERING, this.partitionNameOverrideOpt, this.partitionPathFieldOpt, this.props, this.readStats);
        Mockito.when((Object)this.readerContext.getValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        Assertions.assertFalse((boolean)keyBasedBuffer.isCustomDeleteRecord((Object)record));
        this.props.setProperty("hoodie.payload.delete.field", customDeleteKey);
        this.props.setProperty("hoodie.payload.delete.marker", customDeleteValue);
        keyBasedBuffer = new KeyBasedFileGroupRecordBuffer(this.readerContext, this.hoodieTableMetaClient, RecordMergeMode.COMMIT_TIME_ORDERING, this.partitionNameOverrideOpt, this.partitionPathFieldOpt, this.props, this.readStats);
        Mockito.when((Object)this.readerContext.getValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"i");
        Assertions.assertFalse((boolean)keyBasedBuffer.isCustomDeleteRecord((Object)record));
        Mockito.when((Object)this.readerContext.getValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"d");
        Assertions.assertTrue((boolean)keyBasedBuffer.isCustomDeleteRecord((Object)record));
    }

    @Test
    void testProcessCustomDeleteRecord() throws IOException {
        String customDeleteKey = "op";
        String customDeleteValue = "d";
        Mockito.when((Object)this.schemaHandler.getCustomDeleteMarkerKeyValue()).thenReturn((Object)Option.of((Object)Pair.of((Object)customDeleteKey, (Object)customDeleteValue)));
        Mockito.when((Object)this.schemaHandler.hasBuiltInDelete()).thenReturn((Object)true);
        KeyBasedFileGroupRecordBuffer keyBasedBuffer = new KeyBasedFileGroupRecordBuffer(this.readerContext, this.hoodieTableMetaClient, RecordMergeMode.COMMIT_TIME_ORDERING, this.partitionNameOverrideOpt, this.partitionPathFieldOpt, this.props, this.readStats);
        GenericData.Record record = new GenericData.Record(this.schema);
        record.put("id", (Object)"12345");
        record.put("ts", (Object)System.currentTimeMillis());
        record.put("op", (Object)"d");
        record.put("_hoodie_is_deleted", (Object)false);
        Mockito.when((Object)this.readerContext.getOrderingValue(ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)1);
        Mockito.when((Object)this.readerContext.convertValueToEngineType((Comparable)ArgumentMatchers.any())).thenReturn((Object)1);
        BufferedRecord bufferedRecord = BufferedRecord.forRecordWithContext((Object)record, (Schema)this.schema, (HoodieReaderContext)this.readerContext, (Option)Option.of((Object)"ts"), (boolean)true);
        keyBasedBuffer.processNextDataRecord(bufferedRecord, (Serializable)((Object)"12345"));
        Map records = keyBasedBuffer.getLogRecords();
        Assertions.assertEquals((int)1, (int)records.size());
        BufferedRecord deleteRecord = (BufferedRecord)records.get("12345");
        Assertions.assertNull((Object)deleteRecord.getRecordKey(), (String)"The record key metadata field is missing");
        Assertions.assertEquals((Object)1, (Object)deleteRecord.getOrderingValue());
        GenericData.Record anotherRecord = new GenericData.Record(this.schema);
        anotherRecord.put("id", (Object)"54321");
        anotherRecord.put("ts", (Object)System.currentTimeMillis());
        anotherRecord.put("op", (Object)"i");
        anotherRecord.put("_hoodie_is_deleted", (Object)true);
        bufferedRecord = BufferedRecord.forRecordWithContext((Object)anotherRecord, (Schema)this.schema, (HoodieReaderContext)this.readerContext, (Option)Option.of((Object)"ts"), (boolean)true);
        keyBasedBuffer.processNextDataRecord(bufferedRecord, (Serializable)((Object)"54321"));
        records = keyBasedBuffer.getLogRecords();
        Assertions.assertEquals((int)2, (int)records.size());
        deleteRecord = (BufferedRecord)records.get("54321");
        Assertions.assertNull((Object)deleteRecord.getRecordKey(), (String)"The record key metadata field is missing");
        Assertions.assertEquals((Object)1, (Object)deleteRecord.getOrderingValue());
    }
}

