/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class TestHoodieFileGroupReaderBase<T> {
    @TempDir
    protected Path tempDir;

    public abstract StorageConfiguration<?> getStorageConf();

    public abstract String getBasePath();

    public abstract HoodieReaderContext<T> getHoodieReaderContext(String var1, Schema var2, StorageConfiguration<?> var3);

    public abstract String getCustomPayload();

    public abstract void commitToTable(List<HoodieRecord> var1, String var2, Map<String, String> var3);

    public abstract void validateRecordsInFileGroup(String var1, List<T> var2, Schema var3, FileSlice var4, boolean var5);

    public void validateRecordsInFileGroup(String tablePath, List<T> actualRecordList, Schema schema, FileSlice fileSlice) {
        this.validateRecordsInFileGroup(tablePath, actualRecordList, schema, fileSlice, false);
    }

    public abstract void assertRecordsEqual(Schema var1, T var2, T var3);

    private static Stream<Arguments> testArguments() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, "avro"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.COMMIT_TIME_ORDERING, "parquet"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, "avro"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.EVENT_TIME_ORDERING, "parquet"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, "avro"}), Arguments.arguments((Object[])new Object[]{RecordMergeMode.CUSTOM, "parquet"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testReadFileGroupInMergeOnReadTable(RecordMergeMode recordMergeMode, String logDataBlockFormat) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(recordMergeMode));
        writeConfigs.put(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key(), logDataBlockFormat);
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            this.commitToTable(dataGen.generateInserts("001", 100), WriteOperationType.INSERT.value(), writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), dataGen.getPartitionPaths(), true, 0, recordMergeMode);
            this.commitToTable(dataGen.generateUpdates("002", 100), WriteOperationType.UPSERT.value(), writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), dataGen.getPartitionPaths(), true, 1, recordMergeMode);
            this.commitToTable(dataGen.generateUpdates("003", 100), WriteOperationType.UPSERT.value(), writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), dataGen.getPartitionPaths(), true, 2, recordMergeMode);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testReadLogFilesOnlyInMergeOnReadTable(RecordMergeMode recordMergeMode, String logDataBlockFormat) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(recordMergeMode));
        writeConfigs.put(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key(), logDataBlockFormat);
        writeConfigs.put("hoodie.index.type", "INMEMORY");
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            this.commitToTable(dataGen.generateInserts("001", 100), WriteOperationType.INSERT.value(), writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), dataGen.getPartitionPaths(), false, 1, recordMergeMode);
            this.commitToTable(dataGen.generateUpdates("002", 100), WriteOperationType.UPSERT.value(), writeConfigs);
            this.validateOutputFromFileGroupReader(this.getStorageConf(), this.getBasePath(), dataGen.getPartitionPaths(), false, 2, recordMergeMode);
        }
    }

    @ParameterizedTest
    @EnumSource(value=ExternalSpillableMap.DiskMapType.class)
    public void testSpillableMapUsage(ExternalSpillableMap.DiskMapType diskMapType) throws Exception {
        HashMap<String, String> writeConfigs = new HashMap<String, String>(this.getCommonConfigs(RecordMergeMode.COMMIT_TIME_ORDERING));
        try (HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57071L);){
            this.commitToTable(dataGen.generateInserts("001", 100), WriteOperationType.INSERT.value(), writeConfigs);
            String baseMapPath = Files.createTempDirectory(null, new FileAttribute[0]).toString();
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(this.getStorageConf(), this.getBasePath());
            Schema avroSchema = new TableSchemaResolver(metaClient).getTableAvroSchema();
            FileSlice fileSlice = this.getFileSliceToRead(this.getStorageConf(), this.getBasePath(), metaClient, dataGen.getPartitionPaths(), true, 0);
            List<T> records = this.readRecordsFromFileGroup(this.getStorageConf(), this.getBasePath(), metaClient, fileSlice, avroSchema, RecordMergeMode.COMMIT_TIME_ORDERING, false);
            HoodieReaderContext<T> readerContext = this.getHoodieReaderContext(this.getBasePath(), avroSchema, this.getStorageConf());
            boolean[] blArray = new boolean[]{true, false};
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean isCompressionEnabled = blArray[i];
                try (ExternalSpillableMap spillableMap = new ExternalSpillableMap(16L, baseMapPath, (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(avroSchema), diskMapType, (CustomSerializer)new DefaultSerializer(), isCompressionEnabled.booleanValue(), this.getClass().getSimpleName());){
                    Long l;
                    String recordKey;
                    Long position = 0L;
                    for (T record : records) {
                        recordKey = readerContext.getRecordKey(record, avroSchema);
                        BufferedRecord bufferedRecord = BufferedRecord.forRecordWithContext(record, (Schema)avroSchema, readerContext, (Option)Option.of((Object)"timestamp"), (boolean)false);
                        spillableMap.put((Serializable)((Object)recordKey), (Object)bufferedRecord.toBinary(readerContext));
                        Long l2 = position;
                        l = position = Long.valueOf(position + 1L);
                        spillableMap.put((Serializable)l2, (Object)bufferedRecord.toBinary(readerContext));
                    }
                    Assertions.assertEquals((int)(records.size() * 2), (int)spillableMap.size());
                    position = 0L;
                    for (T record : records) {
                        recordKey = readerContext.getRecordKey(record, avroSchema);
                        BufferedRecord keyBased = (BufferedRecord)spillableMap.get((Object)recordKey);
                        Assertions.assertNotNull((Object)keyBased);
                        l = position;
                        Long l3 = position = Long.valueOf(position + 1L);
                        BufferedRecord positionBased = (BufferedRecord)spillableMap.get((Object)l);
                        Assertions.assertNotNull((Object)positionBased);
                        this.assertRecordsEqual(avroSchema, record, keyBased.getRecord());
                        this.assertRecordsEqual(avroSchema, record, positionBased.getRecord());
                        Assertions.assertEquals((Object)keyBased.getRecordKey(), (Object)recordKey);
                        Assertions.assertEquals((Object)positionBased.getRecordKey(), (Object)recordKey);
                        Assertions.assertEquals((Object)avroSchema, (Object)readerContext.getSchemaFromBufferRecord(keyBased));
                        Assertions.assertEquals((Object)readerContext.convertValueToEngineType((Comparable)Long.valueOf(0L)), (Object)positionBased.getOrderingValue());
                    }
                    continue;
                }
            }
        }
    }

    private Map<String, String> getCommonConfigs(RecordMergeMode recordMergeMode) {
        HashMap<String, String> configMapping = new HashMap<String, String>();
        configMapping.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        configMapping.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "partition_path");
        configMapping.put("hoodie.datasource.write.precombine.field", "timestamp");
        configMapping.put("hoodie.payload.ordering.field", "timestamp");
        configMapping.put("hoodie.table.name", "hoodie_test");
        configMapping.put("hoodie.insert.shuffle.parallelism", "4");
        configMapping.put("hoodie.upsert.shuffle.parallelism", "4");
        configMapping.put("hoodie.bulkinsert.shuffle.parallelism", "2");
        configMapping.put("hoodie.delete.shuffle.parallelism", "1");
        configMapping.put("hoodie.merge.small.file.group.candidates.limit", "0");
        configMapping.put("hoodie.compact.inline", "false");
        configMapping.put("hoodie.write.record.merge.mode", recordMergeMode.name());
        if (recordMergeMode.equals((Object)RecordMergeMode.CUSTOM)) {
            configMapping.put("hoodie.datasource.write.payload.class", this.getCustomPayload());
        }
        return configMapping;
    }

    private void validateOutputFromFileGroupReader(StorageConfiguration<?> storageConf, String tablePath, String[] partitionPaths, boolean containsBaseFile, int expectedLogFileNum, RecordMergeMode recordMergeMode) throws Exception {
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(storageConf, tablePath);
        Schema avroSchema = new TableSchemaResolver(metaClient).getTableAvroSchema();
        FileSlice fileSlice = this.getFileSliceToRead(storageConf, tablePath, metaClient, partitionPaths, containsBaseFile, expectedLogFileNum);
        List<T> actualRecordList = this.readRecordsFromFileGroup(storageConf, tablePath, metaClient, fileSlice, avroSchema, recordMergeMode, false);
        this.validateRecordsInFileGroup(tablePath, actualRecordList, avroSchema, fileSlice);
        actualRecordList = this.readRecordsFromFileGroup(storageConf, tablePath, metaClient, fileSlice, avroSchema, recordMergeMode, true);
        this.validateRecordsInFileGroup(tablePath, actualRecordList, avroSchema, fileSlice, true);
    }

    private FileSlice getFileSliceToRead(StorageConfiguration<?> storageConf, String tablePath, HoodieTableMetaClient metaClient, String[] partitionPaths, boolean containsBaseFile, int expectedLogFileNum) {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(storageConf);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        FileSystemViewManager viewManager = FileSystemViewManager.createViewManager((HoodieEngineContext)engineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)FileSystemViewStorageConfig.newBuilder().build(), (HoodieCommonConfig)HoodieCommonConfig.newBuilder().build(), arg_0 -> TestHoodieFileGroupReaderBase.lambda$getFileSliceToRead$4fcbcd7$1((HoodieEngineContext)engineContext, metadataConfig, tablePath, arg_0));
        SyncableFileSystemView fsView = viewManager.getFileSystemView(metaClient);
        FileSlice fileSlice = (FileSlice)fsView.getAllFileSlices(partitionPaths[0]).findFirst().get();
        List<String> logFilePathList = HoodieTestUtils.getLogFileListFromFileSlice(fileSlice);
        Assertions.assertEquals((int)expectedLogFileNum, (int)logFilePathList.size());
        Assertions.assertEquals((Object)containsBaseFile, (Object)fileSlice.getBaseFile().isPresent());
        return fileSlice;
    }

    private List<T> readRecordsFromFileGroup(StorageConfiguration<?> storageConf, String tablePath, HoodieTableMetaClient metaClient, FileSlice fileSlice, Schema avroSchema, RecordMergeMode recordMergeMode, boolean isSkipMerge) throws Exception {
        ArrayList<Object> actualRecordList = new ArrayList<Object>();
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.datasource.write.precombine.field", "timestamp");
        props.setProperty("hoodie.payload.ordering.field", "timestamp");
        props.setProperty(HoodieTableConfig.RECORD_MERGE_MODE.key(), recordMergeMode.name());
        if (recordMergeMode.equals((Object)RecordMergeMode.CUSTOM)) {
            props.setProperty(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key(), "00000000-0000-0000-0000-000000000000");
            props.setProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key(), this.getCustomPayload());
        }
        props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), String.valueOf(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.defaultValue()));
        props.setProperty(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), metaClient.getTempFolderPath());
        props.setProperty(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), ExternalSpillableMap.DiskMapType.ROCKS_DB.name());
        props.setProperty(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), "false");
        if (metaClient.getTableConfig().contains(HoodieTableConfig.PARTITION_FIELDS)) {
            props.setProperty(HoodieTableConfig.PARTITION_FIELDS.key(), metaClient.getTableConfig().getString(HoodieTableConfig.PARTITION_FIELDS));
        }
        if (isSkipMerge) {
            props.setProperty(HoodieReaderConfig.MERGE_TYPE.key(), "skip_merge");
        }
        if (this.shouldValidatePartialRead(fileSlice, avroSchema)) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieFileGroupReader(this.getHoodieReaderContext(tablePath, avroSchema, storageConf), metaClient.getStorage(), tablePath, ((HoodieInstant)metaClient.getActiveTimeline().lastInstant().get()).requestedTime(), fileSlice, avroSchema, avroSchema, Option.empty(), metaClient, props, 1L, fileSlice.getTotalFileSize(), false, false));
        }
        HoodieFileGroupReader fileGroupReader = new HoodieFileGroupReader(this.getHoodieReaderContext(tablePath, avroSchema, storageConf), metaClient.getStorage(), tablePath, ((HoodieInstant)metaClient.getActiveTimeline().lastInstant().get()).requestedTime(), fileSlice, avroSchema, avroSchema, Option.empty(), metaClient, props, 0L, fileSlice.getTotalFileSize(), false, false);
        fileGroupReader.initRecordIterators();
        while (fileGroupReader.hasNext()) {
            actualRecordList.add(fileGroupReader.next());
        }
        fileGroupReader.close();
        return actualRecordList;
    }

    private boolean shouldValidatePartialRead(FileSlice fileSlice, Schema requestedSchema) {
        if (fileSlice.getLogFiles().findAny().isPresent()) {
            return true;
        }
        if (((HoodieBaseFile)fileSlice.getBaseFile().get()).getBootstrapBaseFile().isPresent()) {
            Pair dataAndMetaCols = FileGroupReaderSchemaHandler.getDataAndMetaCols((Schema)requestedSchema);
            return !((List)dataAndMetaCols.getLeft()).isEmpty() && !((List)dataAndMetaCols.getRight()).isEmpty();
        }
        return false;
    }

    private static /* synthetic */ HoodieTableMetadata lambda$getFileSliceToRead$4fcbcd7$1(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String tablePath, HoodieTableMetaClient mc) {
        return HoodieTableMetadata.create((HoodieEngineContext)engineContext, (HoodieStorage)mc.getStorage(), (HoodieMetadataConfig)metadataConfig, (String)tablePath);
    }
}

