/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.BaseTestCommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.table.timeline.versioning.v2.CommitMetadataSerDeV2;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.junit.jupiter.api.Test;

public class TestCommitMetadataSerDeV2
extends BaseTestCommitMetadataSerDe {
    @Override
    protected CommitMetadataSerDe getSerDe() {
        return new CommitMetadataSerDeV2();
    }

    @Override
    protected HoodieInstant createTestInstant(String action, String id) {
        return HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, action, id);
    }

    @Test
    public void testLegacyInstant() throws Exception {
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        HoodieWriteStat writeStat = this.createTestWriteStat();
        metadata.addWriteStat("2023/01/01", writeStat);
        metadata.setOperationType(WriteOperationType.INSERT);
        metadata.setCompacted(Boolean.valueOf(true));
        metadata.addMetadata("test-key", "test-value");
        CommitMetadataSerDeV1 serDeV1 = new CommitMetadataSerDeV1();
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", "001", "002", true, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        byte[] serialized = TimelineMetadataUtils.convertMetadataToByteArray((Object)metadata, (CommitMetadataSerDe)serDeV1);
        HoodieCommitMetadata deserialized = (HoodieCommitMetadata)this.getSerDe().deserialize(instant, (InputStream)new ByteArrayInputStream(serialized), () -> false, HoodieCommitMetadata.class);
        this.verifyCommitMetadata(deserialized);
        this.verifyWriteStat((HoodieWriteStat)((List)deserialized.getPartitionToWriteStats().get("2023/01/01")).get(0));
    }
}

