/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.http.client.HttpResponseException;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.PriorityBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.MockHoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class TestPriorityBasedFileSystemView {
    @Mock
    private HoodieEngineContext engineContext;
    @Mock
    private SyncableFileSystemView primary;
    @Mock
    private SyncableFileSystemView secondary;
    @Mock
    private SerializableFunctionUnchecked<HoodieEngineContext, SyncableFileSystemView> secondaryViewCreator;
    @InjectMocks
    private PriorityBasedFileSystemView fsView;
    private Stream<HoodieBaseFile> testBaseFileStream;
    private Stream<FileSlice> testFileSliceStream;

    @BeforeEach
    public void setUp() {
        this.fsView = new PriorityBasedFileSystemView(this.primary, this.secondaryViewCreator, this.engineContext);
        this.testBaseFileStream = Stream.of(new HoodieBaseFile("test"));
        this.testFileSliceStream = Stream.of(new FileSlice("2020-01-01", "20:20", "file0001" + ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testFileSliceStream.close();
        this.testBaseFileStream.close();
        this.fsView.close();
    }

    private void resetMocks() {
        Mockito.reset((Object[])new SyncableFileSystemView[]{this.primary, this.secondary});
    }

    @Test
    public void testGetLatestBaseFiles() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        Mockito.when((Object)this.primary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFiles();
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestBaseFiles()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadRequestExceptionWithPrimary() {
        TestLogAppender appender = new TestLogAppender();
        Logger logger = (Logger)LogManager.getLogger(PriorityBasedFileSystemView.class);
        try {
            appender.start();
            logger.addAppender((Appender)appender);
            Stream<HoodieBaseFile> expected = this.testBaseFileStream;
            this.resetMocks();
            Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
            Mockito.when((Object)this.primary.getLatestBaseFiles()).thenThrow(new Throwable[]{new RuntimeException((Throwable)new HttpResponseException(400, "Bad Request"))});
            Mockito.when((Object)this.secondary.getLatestBaseFiles()).thenReturn(this.testBaseFileStream);
            Stream actual = this.fsView.getLatestBaseFiles();
            Assertions.assertEquals(expected, (Object)actual);
            List<LogEvent> logs = appender.getLog();
            LogEvent firstLogEntry = logs.get(0);
            Assertions.assertEquals((Object)firstLogEntry.getLevel(), (Object)Level.WARN);
            Assertions.assertTrue((boolean)firstLogEntry.getMessage().getFormattedMessage().contains("Got error running preferred function. Likely due to another concurrent writer in progress. Trying secondary"));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    @Test
    public void testGetLatestBaseFilesWithPartitionPath() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFiles(partitionPath));
    }

    @Test
    public void testGetLatestBaseFilesBeforeOrOn() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        String partitionPath = "/table2";
        String maxCommitTime = "2010-10-10";
        Mockito.when((Object)this.primary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFilesBeforeOrOn(partitionPath, maxCommitTime));
    }

    @Test
    public void testGetLatestBaseFile() {
        Option expected = Option.of((Object)new HoodieBaseFile("test.file"));
        String partitionPath = "/table2";
        String fileID = "file.123";
        Mockito.when((Object)this.primary.getLatestBaseFile(partitionPath, fileID)).thenReturn((Object)expected);
        Option actual = this.fsView.getLatestBaseFile(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestBaseFile(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFile(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestBaseFile(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFile(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestBaseFile(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFile(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFile(partitionPath, fileID));
    }

    @Test
    public void testGetBaseFileOn() {
        Option expected = Option.of((Object)new HoodieBaseFile("test.file"));
        String partitionPath = "/table2";
        String instantTime = "2020-01-01";
        String fileID = "file.123";
        Mockito.when((Object)this.primary.getBaseFileOn(partitionPath, instantTime, fileID)).thenReturn((Object)expected);
        Option actual = this.fsView.getBaseFileOn(partitionPath, instantTime, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getBaseFileOn(partitionPath, instantTime, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getBaseFileOn(partitionPath, instantTime, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getBaseFileOn(partitionPath, instantTime, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getBaseFileOn(partitionPath, instantTime, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getBaseFileOn(partitionPath, instantTime, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getBaseFileOn(partitionPath, instantTime, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getBaseFileOn(partitionPath, instantTime, fileID));
    }

    @Test
    public void testGetLatestBaseFilesInRange() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        List<String> commitsToReturn = Collections.singletonList("/table2");
        Mockito.when((Object)this.primary.getLatestBaseFilesInRange(commitsToReturn)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getLatestBaseFilesInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestBaseFilesInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestBaseFilesInRange(commitsToReturn)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesInRange(commitsToReturn)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getLatestBaseFilesInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestBaseFilesInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestBaseFilesInRange(commitsToReturn));
    }

    @Test
    public void testGetAllBaseFiles() {
        Stream<HoodieBaseFile> expected = this.testBaseFileStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getAllBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        Stream actual = this.fsView.getAllBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getAllBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getAllBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getAllBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllBaseFiles(partitionPath)).thenReturn(this.testBaseFileStream);
        actual = this.fsView.getAllBaseFiles(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllBaseFiles(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getAllBaseFiles(partitionPath));
    }

    @Test
    public void testGetLatestFileSlices() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlices(partitionPath));
    }

    @Test
    public void testGetLatestFileSlicesIncludingInflight() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestFileSlicesIncludingInflight(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSlicesIncludingInflight(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestFileSlicesIncludingInflight(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlicesIncludingInflight(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlicesIncludingInflight(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlicesIncludingInflight(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlicesIncludingInflight(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlicesIncludingInflight(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlicesIncludingInflight(partitionPath));
    }

    @Test
    public void testGetLatestUnCompactedFileSlices() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getLatestUnCompactedFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestUnCompactedFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestUnCompactedFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestUnCompactedFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestUnCompactedFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestUnCompactedFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestUnCompactedFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestUnCompactedFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestUnCompactedFileSlices(partitionPath));
    }

    @Test
    public void testGetLatestFileSlicesBeforeOrOn() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        String maxCommitTime = "2020-01-01";
        Mockito.when((Object)this.primary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, maxCommitTime, false));
    }

    @Test
    public void testGetLatestMergedFileSlicesBeforeOrOn() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        String maxInstantTime = "2020-01-01";
        Mockito.when((Object)this.primary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime));
    }

    @Test
    public void testGetLatestFileSliceInRange() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        List<String> commitsToReturn = Collections.singletonList("/table2");
        Mockito.when((Object)this.primary.getLatestFileSliceInRange(commitsToReturn)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getLatestFileSliceInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestFileSliceInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSliceInRange(commitsToReturn)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSliceInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSliceInRange(commitsToReturn)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getLatestFileSliceInRange(commitsToReturn);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSliceInRange(commitsToReturn)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSliceInRange(commitsToReturn));
    }

    @Test
    public void testGetAllFileSlices() {
        Stream<FileSlice> expected = this.testFileSliceStream;
        String partitionPath = "/table2";
        Mockito.when((Object)this.primary.getAllFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        Stream actual = this.fsView.getAllFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getAllFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getAllFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getAllFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileSlices(partitionPath)).thenReturn(this.testFileSliceStream);
        actual = this.fsView.getAllFileSlices(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileSlices(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getAllFileSlices(partitionPath));
    }

    @Test
    public void testGetAllFileGroups() {
        String partitionPath = "/table2";
        Stream expected = Collections.singleton(new HoodieFileGroup(partitionPath, "id1", (HoodieTimeline)new MockHoodieTimeline(Stream.empty(), Stream.empty()))).stream();
        Mockito.when((Object)this.primary.getAllFileGroups(partitionPath)).thenReturn(expected);
        Stream actual = this.fsView.getAllFileGroups(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getAllFileGroups(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getAllFileGroups(partitionPath)).thenReturn(expected);
        actual = this.fsView.getAllFileGroups(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileGroups(partitionPath)).thenReturn(expected);
        actual = this.fsView.getAllFileGroups(partitionPath);
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getAllFileGroups(partitionPath)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getAllFileGroups(partitionPath));
    }

    @Test
    public void testGetPendingCompactionOperations() {
        Stream expected = Collections.singleton(new ImmutablePair((Object)"test", (Object)new CompactionOperation())).stream();
        Mockito.when((Object)this.primary.getPendingCompactionOperations()).thenReturn(expected);
        Stream actual = this.fsView.getPendingCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getPendingCompactionOperations()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getPendingCompactionOperations()).thenReturn(expected);
        actual = this.fsView.getPendingCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getPendingCompactionOperations()).thenReturn(expected);
        actual = this.fsView.getPendingCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getPendingCompactionOperations()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getPendingCompactionOperations());
    }

    @Test
    public void testGetPendingLogCompactionOperations() {
        Stream expected = Collections.singleton(new ImmutablePair((Object)"test", (Object)new CompactionOperation())).stream();
        Mockito.when((Object)this.primary.getPendingLogCompactionOperations()).thenReturn(expected);
        Stream actual = this.fsView.getPendingLogCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getPendingLogCompactionOperations()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getPendingLogCompactionOperations()).thenReturn(expected);
        actual = this.fsView.getPendingLogCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getPendingLogCompactionOperations()).thenReturn(expected);
        actual = this.fsView.getPendingLogCompactionOperations();
        Assertions.assertEquals(expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getPendingLogCompactionOperations()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getPendingLogCompactionOperations());
    }

    @Test
    public void testClose_noSecondaryInitialized() {
        this.fsView.close();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).close();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testClose_withSecondaryInitialized() {
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        this.fsView.getSecondaryView();
        this.fsView.close();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).close();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testReset_noSecondaryInitialized() {
        this.fsView.reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testReset_withSecondaryInitialized() {
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        this.fsView.getSecondaryView();
        this.fsView.reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).reset();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testGetLastInstant() {
        Option expected = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "", ""));
        Mockito.when((Object)this.primary.getLastInstant()).thenReturn((Object)expected);
        Option actual = this.fsView.getLastInstant();
        Assertions.assertEquals((Object)expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLastInstant()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLastInstant()).thenReturn((Object)expected);
        actual = this.fsView.getLastInstant();
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLastInstant()).thenReturn((Object)expected);
        actual = this.fsView.getLastInstant();
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLastInstant()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLastInstant());
    }

    @Test
    public void testGetTimeline() {
        MockHoodieTimeline expected = new MockHoodieTimeline(Stream.empty(), Stream.empty());
        Mockito.when((Object)this.primary.getTimeline()).thenReturn((Object)expected);
        HoodieTimeline actual = this.fsView.getTimeline();
        Assertions.assertEquals((Object)((Object)expected), (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getTimeline()).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getTimeline()).thenReturn((Object)expected);
        actual = this.fsView.getTimeline();
        Assertions.assertEquals((Object)((Object)expected), (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getTimeline()).thenReturn((Object)expected);
        actual = this.fsView.getTimeline();
        Assertions.assertEquals((Object)((Object)expected), (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getTimeline()).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getTimeline());
    }

    @Test
    public void testSync_noSecondaryInitialized() {
        this.fsView.sync();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).sync();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.never())).sync();
    }

    @Test
    public void testSync_withSecondaryInitialized() {
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        this.fsView.getSecondaryView();
        this.fsView.sync();
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).sync();
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).sync();
    }

    @Test
    public void testGetLatestFileSlice() {
        Option expected = Option.fromJavaOptional(this.testFileSliceStream.findFirst());
        String partitionPath = "/table2";
        String fileID = "file.123";
        Mockito.when((Object)this.primary.getLatestFileSlice(partitionPath, fileID)).thenReturn((Object)expected);
        Option actual = this.fsView.getLatestFileSlice(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Mockito.when((Object)this.primary.getLatestFileSlice(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Mockito.when((Object)this.secondary.getLatestFileSlice(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestFileSlice(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlice(partitionPath, fileID)).thenReturn((Object)expected);
        actual = this.fsView.getLatestFileSlice(partitionPath, fileID);
        Assertions.assertEquals((Object)expected, (Object)actual);
        this.resetMocks();
        Mockito.when((Object)this.secondary.getLatestFileSlice(partitionPath, fileID)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.getLatestFileSlice(partitionPath, fileID));
    }

    @Test
    public void testLoadPartitions() {
        String partitionPath = "/table2";
        this.fsView.loadPartitions(Collections.singletonList(partitionPath));
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).loadPartitions(Collections.singletonList(partitionPath));
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.never())).loadPartitions((List)ArgumentMatchers.any());
        ((SerializableFunctionUnchecked)Mockito.verify(this.secondaryViewCreator, (VerificationMode)Mockito.never())).apply((Object)this.engineContext);
        this.resetMocks();
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        ((SyncableFileSystemView)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.primary)).loadPartitions(Collections.singletonList(partitionPath));
        this.fsView.loadPartitions(Collections.singletonList(partitionPath));
        ((SyncableFileSystemView)Mockito.verify((Object)this.primary, (VerificationMode)Mockito.times((int)1))).loadPartitions(Collections.singletonList(partitionPath));
        ((SyncableFileSystemView)Mockito.verify((Object)this.secondary, (VerificationMode)Mockito.times((int)1))).loadPartitions(Collections.singletonList(partitionPath));
        this.resetMocks();
        ((SyncableFileSystemView)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.secondary)).loadPartitions(Collections.singletonList(partitionPath));
        Assertions.assertThrows(RuntimeException.class, () -> this.fsView.loadPartitions(Collections.singletonList(partitionPath)));
    }

    @Test
    public void testGetPreferredView() {
        Assertions.assertEquals((Object)this.primary, (Object)this.fsView.getPreferredView());
    }

    @Test
    public void testGetSecondaryView() {
        Mockito.when((Object)this.secondaryViewCreator.apply((Object)this.engineContext)).thenReturn((Object)this.secondary);
        Assertions.assertEquals((Object)this.secondary, (Object)this.fsView.getSecondaryView());
    }

    class TestLogAppender
    extends AbstractAppender {
        private final List<LogEvent> log;

        protected TestLogAppender() {
            super(UUID.randomUUID().toString(), null, null, false, null);
            this.log = new ArrayList<LogEvent>();
        }

        public void append(LogEvent event) {
            this.log.add(event.toImmutable());
        }

        public List<LogEvent> getLog() {
            return new ArrayList<LogEvent>(this.log);
        }
    }
}

