/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieAvroRecordTestMerger
extends HoodieAvroRecordMerger {
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        Comparable oldOrderingVal = older.getOrderingValue(oldSchema, (Properties)props);
        Comparable newOrderingVal = newer.getOrderingValue(newSchema, (Properties)props);
        if (oldOrderingVal == null || newOrderingVal.compareTo(oldOrderingVal) > 0) {
            return Option.of((Object)Pair.of((Object)newer, (Object)newSchema));
        }
        if (newOrderingVal.compareTo(oldOrderingVal) < 0) {
            return Option.of((Object)Pair.of((Object)older, (Object)oldSchema));
        }
        return this.combineAndGetUpdateValue(older, newer, newSchema, (Properties)props).map(r -> Pair.of((Object)new HoodieAvroIndexedRecord(r), (Object)r.getSchema()));
    }

    private Option<IndexedRecord> combineAndGetUpdateValue(HoodieRecord older, HoodieRecord newer, Schema schema, Properties props) throws IOException {
        Option previousAvroData = older.toIndexedRecord(schema, props).map(HoodieRecord::getData);
        if (!previousAvroData.isPresent()) {
            return newer.toIndexedRecord(schema, props).map(HoodieRecord::getData);
        }
        return ((HoodieAvroRecord)newer).getData().combineAndGetUpdateValue((IndexedRecord)previousAvroData.get(), schema, props);
    }
}

