/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class HoodieRecordTestPayload
extends OverwriteWithLatestAvroPayload {
    public static final String METADATA_EVENT_TIME_KEY = "metadata.event_time.key";
    public static final String DELETE_KEY = "hoodie.payload.delete.field";
    public static final String DELETE_MARKER = "hoodie.payload.delete.marker";
    private Option<Object> eventTime = Option.empty();
    private AtomicBoolean isDeleteComputed = new AtomicBoolean(false);
    private boolean isDefaultRecordPayloadDeleted = false;

    public HoodieRecordTestPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public HoodieRecordTestPayload preCombine(HoodieRecordTestPayload oldValue) {
        if (oldValue.recordBytes.length == 0) {
            return this;
        }
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        if (this.isDeleted(schema, properties)) {
            String orderingField = ConfigUtils.getOrderingField((Properties)properties);
            if (orderingField == null) {
                return Option.empty();
            }
            Comparable currentOrderingVal = (Comparable)currentValue.get(currentValue.getSchema().getField(orderingField).pos());
            if (this.orderingVal.compareTo(currentOrderingVal) >= 0) {
                return Option.empty();
            }
            return Option.of((Object)currentValue);
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro((byte[])this.recordBytes, (Schema)schema);
        if (!this.needUpdatingPersistedRecord(currentValue, (IndexedRecord)incomingRecord, properties)) {
            return Option.of((Object)currentValue);
        }
        this.eventTime = HoodieRecordTestPayload.updateEventTime(incomingRecord, properties);
        if (!this.isDeleteComputed.getAndSet(true)) {
            this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, properties);
        }
        return this.isDefaultRecordPayloadDeleted ? Option.empty() : Option.of((Object)incomingRecord);
    }

    public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro((byte[])this.recordBytes, (Schema)schema);
        this.eventTime = HoodieRecordTestPayload.updateEventTime(incomingRecord, properties);
        if (!this.isDeleteComputed.getAndSet(true)) {
            this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, properties);
        }
        return this.isDefaultRecordPayloadDeleted ? Option.empty() : Option.of((Object)incomingRecord);
    }

    public boolean isDeleted(Schema schema, Properties props) {
        if (this.recordBytes.length == 0) {
            return true;
        }
        try {
            if (!this.isDeleteComputed.getAndSet(true)) {
                GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro((byte[])this.recordBytes, (Schema)schema);
                this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, props);
            }
            return this.isDefaultRecordPayloadDeleted;
        }
        catch (IOException e) {
            throw new HoodieIOException("Deserializing bytes to avro failed ", e);
        }
    }

    protected boolean isDeleteRecord(GenericRecord genericRecord, Properties properties) {
        String deleteKey = properties.getProperty(DELETE_KEY);
        if (StringUtils.isNullOrEmpty((String)deleteKey)) {
            return this.isDeleteRecord(genericRecord);
        }
        ValidationUtils.checkArgument((!StringUtils.isNullOrEmpty((String)properties.getProperty(DELETE_MARKER)) ? 1 : 0) != 0, () -> "hoodie.payload.delete.marker should be configured with hoodie.payload.delete.field");
        if (genericRecord.getSchema().getField(deleteKey) == null) {
            return false;
        }
        Object deleteMarker = genericRecord.get(deleteKey);
        return deleteMarker != null && properties.getProperty(DELETE_MARKER).equals(deleteMarker.toString());
    }

    private static Option<Object> updateEventTime(GenericRecord record, Properties properties) {
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), (String)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        String eventTimeField = properties.getProperty("hoodie.payload.event.time.field");
        if (eventTimeField == null) {
            return Option.empty();
        }
        return Option.ofNullable((Object)HoodieAvroUtils.getNestedFieldVal((GenericRecord)record, (String)eventTimeField, (boolean)true, (boolean)consistentLogicalTimestampEnabled));
    }

    public Option<Map<String, String>> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.eventTime.isPresent()) {
            metadata.put(METADATA_EVENT_TIME_KEY, String.valueOf(this.eventTime.get()));
        }
        return metadata.isEmpty() ? Option.empty() : Option.of(metadata);
    }

    protected boolean needUpdatingPersistedRecord(IndexedRecord currentValue, IndexedRecord incomingRecord, Properties properties) {
        String orderingField = ConfigUtils.getOrderingField((Properties)properties);
        if (orderingField == null) {
            return true;
        }
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), (String)KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        Object persistedOrderingVal = HoodieAvroUtils.getNestedFieldVal((GenericRecord)((GenericRecord)currentValue), (String)orderingField, (boolean)true, (boolean)consistentLogicalTimestampEnabled);
        Comparable incomingOrderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)((GenericRecord)incomingRecord), (String)orderingField, (boolean)true, (boolean)consistentLogicalTimestampEnabled);
        return persistedOrderingVal == null || ((Comparable)persistedOrderingVal).compareTo(incomingOrderingVal) <= 0;
    }
}

