/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.util.FileFormatUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBaseFileUtils {
    private static final String PARTITION_PATH = "partition";
    private static final String COLUMN_NAME = "columnName";

    @Test
    public void testGetColumnRangeInPartition() {
        HoodieColumnRangeMetadata fileColumnRange1 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)COLUMN_NAME, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5), (long)0L, (long)10L, (long)100L, (long)200L);
        HoodieColumnRangeMetadata fileColumnRange2 = HoodieColumnRangeMetadata.create((String)"path/to/file2", (String)COLUMN_NAME, (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        List<HoodieColumnRangeMetadata> fileColumnRanges = Arrays.asList(fileColumnRange1, fileColumnRange2);
        HoodieColumnRangeMetadata result = FileFormatUtils.getColumnRangeInPartition((String)PARTITION_PATH, fileColumnRanges, Collections.emptyMap());
        Assertions.assertEquals((Object)PARTITION_PATH, (Object)result.getFilePath());
        Assertions.assertEquals((Object)COLUMN_NAME, (Object)result.getColumnName());
        Assertions.assertEquals((Integer)1, (Integer)new Integer(result.getMinValue().toString()));
        Assertions.assertEquals((Integer)8, (Integer)new Integer(result.getMaxValue().toString()));
        Assertions.assertEquals((long)1L, (long)result.getNullCount());
        Assertions.assertEquals((long)25L, (long)result.getValueCount());
        Assertions.assertEquals((long)220L, (long)result.getTotalSize());
        Assertions.assertEquals((long)450L, (long)result.getTotalUncompressedSize());
    }

    @Test
    public void testGetColumnRangeInPartitionWithNullMinMax() {
        HoodieColumnRangeMetadata fileColumnRange1 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)COLUMN_NAME, (Comparable)Integer.valueOf(1), null, (long)0L, (long)10L, (long)100L, (long)200L);
        HoodieColumnRangeMetadata fileColumnRange2 = HoodieColumnRangeMetadata.create((String)"path/to/file2", (String)COLUMN_NAME, null, (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        List<HoodieColumnRangeMetadata> fileColumnRanges = Arrays.asList(fileColumnRange1, fileColumnRange2);
        HoodieColumnRangeMetadata result = FileFormatUtils.getColumnRangeInPartition((String)PARTITION_PATH, fileColumnRanges, Collections.emptyMap());
        Assertions.assertEquals((Object)PARTITION_PATH, (Object)result.getFilePath());
        Assertions.assertEquals((Object)COLUMN_NAME, (Object)result.getColumnName());
        Assertions.assertEquals((Integer)1, (Integer)new Integer(result.getMinValue().toString()));
        Assertions.assertEquals((Integer)8, (Integer)new Integer(result.getMaxValue().toString()));
        Assertions.assertEquals((long)1L, (long)result.getNullCount());
        Assertions.assertEquals((long)25L, (long)result.getValueCount());
        Assertions.assertEquals((long)220L, (long)result.getTotalSize());
        Assertions.assertEquals((long)450L, (long)result.getTotalUncompressedSize());
    }

    @Test
    public void testGetColumnRangeInPartitionWithDifferentColumnNameThrowsException() {
        HoodieColumnRangeMetadata fileColumnRange1 = HoodieColumnRangeMetadata.create((String)"path/to/file1", (String)"columnName1", (Comparable)Integer.valueOf(1), null, (long)0L, (long)10L, (long)100L, (long)200L);
        HoodieColumnRangeMetadata fileColumnRange2 = HoodieColumnRangeMetadata.create((String)"path/to/file2", (String)"columnName2", null, (Comparable)Integer.valueOf(8), (long)1L, (long)15L, (long)120L, (long)250L);
        List<HoodieColumnRangeMetadata> fileColumnRanges = Arrays.asList(fileColumnRange1, fileColumnRange2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileFormatUtils.getColumnRangeInPartition((String)PARTITION_PATH, (List)fileColumnRanges, Collections.emptyMap()));
    }
}

