/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Functions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestCleanerUtils {
    private final Functions.Function0<Boolean> rollbackFunction = (Functions.Function0)Mockito.mock(Functions.Function0.class);

    TestCleanerUtils() {
    }

    @Test
    void rollbackFailedWrites_CleanWithEagerPolicy() {
        Assertions.assertFalse((boolean)CleanerUtils.rollbackFailedWrites((HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER, (String)"clean", this.rollbackFunction));
        ((Functions.Function0)Mockito.verify(this.rollbackFunction, (VerificationMode)Mockito.never())).apply();
    }

    @Test
    void rollbackFailedWrites_CleanWithLazyPolicy() {
        Mockito.when((Object)this.rollbackFunction.apply()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)CleanerUtils.rollbackFailedWrites((HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.LAZY, (String)"clean", this.rollbackFunction));
    }

    @Test
    void rollbackFailedWrites_CommitWithEagerPolicy() {
        Mockito.when((Object)this.rollbackFunction.apply()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)CleanerUtils.rollbackFailedWrites((HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER, (String)"commit", this.rollbackFunction));
    }

    @Test
    void rollbackFailedWrites_CommitWithLazyPolicy() {
        Assertions.assertFalse((boolean)CleanerUtils.rollbackFailedWrites((HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.LAZY, (String)"commit", this.rollbackFunction));
        ((Functions.Function0)Mockito.verify(this.rollbackFunction, (VerificationMode)Mockito.never())).apply();
    }
}

