/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSerializableSchema {
    @Test
    public void testSerDeser() throws IOException {
        this.verifySchema(HoodieTestDataGenerator.AVRO_TRIP_SCHEMA);
        this.verifySchema(HoodieAvroUtils.addMetadataFields((Schema)HoodieTestDataGenerator.AVRO_TRIP_SCHEMA));
        this.verifySchema(HoodieTestDataGenerator.AVRO_SHORT_TRIP_SCHEMA);
        this.verifySchema(HoodieAvroUtils.addMetadataFields((Schema)HoodieTestDataGenerator.AVRO_SHORT_TRIP_SCHEMA));
        this.verifySchema(HoodieTestDataGenerator.FLATTENED_AVRO_SCHEMA);
        this.verifySchema(HoodieAvroUtils.addMetadataFields((Schema)HoodieTestDataGenerator.FLATTENED_AVRO_SCHEMA));
        this.verifySchema(HoodieTestDataGenerator.AVRO_SCHEMA_WITH_METADATA_FIELDS);
    }

    @Test
    public void testLargeSchema() throws IOException {
        this.verifySchema(new Schema.Parser().parse(this.generateLargeSchema()));
    }

    private void verifySchema(Schema schema) throws IOException {
        SerializableSchema serializableSchema = new SerializableSchema(schema);
        Assertions.assertEquals((Object)schema, (Object)serializableSchema.get());
        Assertions.assertTrue((schema != serializableSchema.get() ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        serializableSchema.writeObjectTo(oos);
        oos.flush();
        oos.close();
        byte[] bytesWritten = baos.toByteArray();
        SerializableSchema newSchema = new SerializableSchema();
        newSchema.readObjectFrom(new ObjectInputStream(new ByteArrayInputStream(bytesWritten)));
        Assertions.assertEquals((Object)schema, (Object)newSchema.get());
    }

    private String generateLargeSchema() {
        StringBuilder schema = new StringBuilder();
        schema.append("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},");
        int fieldNum = 1;
        while (schema.length() < 81920) {
            String fieldName = "field" + fieldNum;
            schema.append("{\"name\": \"" + fieldName + "\",\"type\": {\"type\":\"record\", \"name\":\"" + fieldName + "\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},");
            ++fieldNum;
        }
        schema.append("{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        return schema.toString();
    }
}

