/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.hash.BucketIndexUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestBucketIndexUtil {
    private static Stream<Arguments> partitionParams() {
        ArrayList<Arguments> argsList = new ArrayList<Arguments>();
        argsList.add(Arguments.of((Object[])new Object[]{10, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{20, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{21, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{40, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{41, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{100, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{101, 5, true}));
        argsList.add(Arguments.of((Object[])new Object[]{20, 100, true}));
        argsList.add(Arguments.of((Object[])new Object[]{21, 100, true}));
        argsList.add(Arguments.of((Object[])new Object[]{100, 100, true}));
        argsList.add(Arguments.of((Object[])new Object[]{101, 100, true}));
        argsList.add(Arguments.of((Object[])new Object[]{200, 100, true}));
        argsList.add(Arguments.of((Object[])new Object[]{201, 100, true}));
        argsList.add(Arguments.of((Object[])new Object[]{400, 1000, true}));
        argsList.add(Arguments.of((Object[])new Object[]{401, 1000, true}));
        return argsList.stream();
    }

    private static Stream<Arguments> noPartitionParams() {
        ArrayList<Arguments> argsList = new ArrayList<Arguments>();
        argsList.add(Arguments.of((Object[])new Object[]{10, 50, false}));
        argsList.add(Arguments.of((Object[])new Object[]{11, 50, false}));
        argsList.add(Arguments.of((Object[])new Object[]{100, 50, false}));
        argsList.add(Arguments.of((Object[])new Object[]{101, 50, false}));
        return argsList.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"partitionParams"})
    void testPartition(int parallelism, int bucketNumber, boolean partitioned) {
        HashMap<Integer, Integer> parallelism2TaskCount = new HashMap<Integer, Integer>();
        Functions.Function2 partitionIndexFunc = BucketIndexUtil.getPartitionIndexFunc((int)bucketNumber, (int)parallelism);
        this.initPartitionData(parallelism2TaskCount, bucketNumber, (Functions.Function2<String, Integer, Integer>)partitionIndexFunc);
        this.checkResult(parallelism2TaskCount, parallelism, bucketNumber, partitioned);
    }

    @ParameterizedTest
    @MethodSource(value={"noPartitionParams"})
    void testNoPartition(int parallelism, int bucketNumber, boolean partitioned) {
        HashMap<Integer, Integer> parallelism2TaskCount = new HashMap<Integer, Integer>();
        Functions.Function2 partitionIndexFunc = BucketIndexUtil.getPartitionIndexFunc((int)bucketNumber, (int)parallelism);
        this.initNoPartitionData(parallelism2TaskCount, bucketNumber, (Functions.Function2<String, Integer, Integer>)partitionIndexFunc);
        this.checkResult(parallelism2TaskCount, parallelism, bucketNumber, partitioned);
    }

    private static void putIndexCount(Map<Integer, Integer> parallelism2TaskCount, int workIndex) {
        if (parallelism2TaskCount.containsKey(workIndex)) {
            parallelism2TaskCount.put(workIndex, parallelism2TaskCount.get(workIndex) + 1);
        } else {
            parallelism2TaskCount.put(workIndex, 1);
        }
    }

    private void checkResult(Map<Integer, Integer> parallelism2TaskCount, int parallelism, int bucketNumber, boolean partitioned) {
        int sum = 0;
        for (int v : parallelism2TaskCount.values()) {
            sum += v;
        }
        int avg = sum / parallelism;
        double minToleranceValue = (double)avg * 0.8;
        double maxToleranceValue = (double)avg * 1.2;
        ArrayList<Integer> outOfLimit = new ArrayList<Integer>();
        ArrayList<Integer> inLimit = new ArrayList<Integer>();
        for (int v : parallelism2TaskCount.values()) {
            if ((double)v >= minToleranceValue && (double)v <= maxToleranceValue || Math.abs(v - avg) <= 2) {
                inLimit.add(v);
                continue;
            }
            outOfLimit.add(v);
        }
        Assertions.assertEquals((int)0, (int)outOfLimit.size());
        int totalBucketFileNumber = bucketNumber;
        if (partitioned) {
            totalBucketFileNumber = bucketNumber * 8;
        }
        if (parallelism >= totalBucketFileNumber) {
            Assertions.assertTrue(((double)parallelism2TaskCount.size() >= (double)totalBucketFileNumber * 0.9 ? 1 : 0) != 0);
        } else {
            Assertions.assertTrue(((double)parallelism2TaskCount.size() >= (double)parallelism * 0.9 ? 1 : 0) != 0);
        }
    }

    private void initPartitionData(Map<Integer, Integer> parallelism2TaskCount, int bucketNumber, Functions.Function2<String, Integer, Integer> partitionIndexFunc) {
        parallelism2TaskCount.clear();
        Arrays.asList("year=2021/month=01/day=01", "year=2021/month=01/day=02", "year=2021/month=01/day=03", "year=2021/month=01/day=04", "year=2021/month=01/day=05", "year=2021/month=01/day=06", "year=2021/month=01/day=07", "year=2021/month=01/day=08").forEach(partition -> {
            for (int bucketIndex = 0; bucketIndex < bucketNumber; ++bucketIndex) {
                TestBucketIndexUtil.putIndexCount(parallelism2TaskCount, (Integer)partitionIndexFunc.apply(partition, (Object)bucketIndex));
            }
        });
    }

    private void initNoPartitionData(Map<Integer, Integer> parallelism2TaskCount, int bucketNumber, Functions.Function2<String, Integer, Integer> partitionIndexFunc) {
        parallelism2TaskCount.clear();
        for (int bucketIndex = 0; bucketIndex < bucketNumber; ++bucketIndex) {
            TestBucketIndexUtil.putIndexCount(parallelism2TaskCount, (Integer)partitionIndexFunc.apply((Object)"", (Object)bucketIndex));
        }
    }
}

