/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.io;

import java.nio.ByteBuffer;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestByteBufferBackedInputStream {
    @Test
    public void testConstructor() {
        byte[] bytes = new byte[]{13, 14, 10, 13, 13, 14, 14, 13};
        ByteBuffer byteBuf = ByteBuffer.wrap(bytes, 0, 1);
        ByteBuffer byteBufClone = byteBuf.duplicate();
        ByteBufferBackedInputStream first = new ByteBufferBackedInputStream(byteBuf);
        Assertions.assertEquals((int)first.read(), (int)13);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ByteBufferBackedInputStream)first).read());
        Assertions.assertEquals((Object)byteBufClone, (Object)byteBuf);
        ByteBufferBackedInputStream second = new ByteBufferBackedInputStream(bytes);
        Assertions.assertEquals((int)second.read(), (int)13);
        ByteBufferBackedInputStream third = new ByteBufferBackedInputStream(bytes, 1, 1);
        Assertions.assertEquals((int)third.read(), (int)14);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ByteBufferBackedInputStream)third).read());
    }

    @Test
    public void testRead() {
        byte[] sourceBytes = new byte[]{13, 14, 10, 13, 13, 14, 14, 13};
        ByteBufferBackedInputStream stream = new ByteBufferBackedInputStream(sourceBytes);
        int firstByte = stream.read();
        Assertions.assertEquals((int)firstByte, (int)13);
        byte[] readBytes = new byte[4];
        int read = stream.read(readBytes, 1, 3);
        Assertions.assertEquals((int)3, (int)read);
        Assertions.assertArrayEquals((byte[])new byte[]{0, 14, 10, 13}, (byte[])readBytes);
        Assertions.assertEquals((int)4, (int)stream.getPosition());
    }

    @Test
    public void testSeek() {
        byte[] sourceBytes = new byte[]{13, 14, 10, 13, 13, 10, 14, 13};
        ByteBufferBackedInputStream stream = new ByteBufferBackedInputStream(sourceBytes, 1, 7);
        stream.seek(1L);
        int firstRead = stream.read();
        Assertions.assertEquals((int)10, (int)firstRead);
        stream.seek(5L);
        int secondRead = stream.read();
        Assertions.assertEquals((int)14, (int)secondRead);
        Assertions.assertThrows(IllegalArgumentException.class, () -> stream.seek(8L));
    }

    @Test
    public void testCopyFrom() {
        byte[] sourceBytes = new byte[]{13, 14, 10, 13, 13, 10, 14, 13};
        ByteBufferBackedInputStream stream = new ByteBufferBackedInputStream(sourceBytes);
        int firstByte = stream.read();
        Assertions.assertEquals((int)firstByte, (int)13);
        byte[] targetBytes = new byte[5];
        stream.copyFrom(2L, targetBytes, 0, targetBytes.length);
        Assertions.assertArrayEquals((byte[])new byte[]{10, 13, 13, 10, 14}, (byte[])targetBytes);
        int secondByte = stream.read();
        Assertions.assertEquals((int)secondByte, (int)14);
    }
}

