/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.exception.HoodieNullSchemaTypeException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroSchemaEvolutionUtils {
    String schemaStr = "{\"type\":\"record\",\"name\":\"newTableName\",\"fields\":[{\"name\":\"id\",\"type\":\"int\"},{\"name\":\"data\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"preferences\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"preferences\",\"namespace\":\"newTableName\",\"fields\":[{\"name\":\"feature1\",\"type\":\"boolean\"},{\"name\":\"feature2\",\"type\":[\"null\",\"boolean\"],\"default\":null}]}],\"default\":null},{\"name\":\"locations\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"locations\",\"namespace\":\"newTableName\",\"fields\":[{\"name\":\"lat\",\"type\":\"float\"},{\"name\":\"long\",\"type\":\"float\"}]}}},{\"name\":\"points\",\"type\":[\"null\",{\"type\":\"array\",\"items\":[\"null\",{\"type\":\"record\",\"name\":\"points\",\"namespace\":\"newTableName\",\"fields\":[{\"name\":\"x\",\"type\":\"long\"},{\"name\":\"y\",\"type\":\"long\"}]}]}],\"default\":null},{\"name\":\"doubles\",\"type\":{\"type\":\"array\",\"items\":\"double\"}},{\"name\":\"properties\",\"type\":[\"null\",{\"type\":\"map\",\"values\":[\"null\",\"string\"]}],\"default\":null}]}";

    @Test
    public void testPrimitiveTypes() {
        Schema[] avroPrimitives = new Schema[]{Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.FLOAT), Schema.create((Schema.Type)Schema.Type.DOUBLE), LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.create((Schema.Type)Schema.Type.STRING), LogicalTypes.uuid().addToSchema(Schema.createFixed((String)"t1.fixed", null, null, (int)16)), Schema.createFixed((String)"t1.fixed", null, null, (int)12), Schema.create((Schema.Type)Schema.Type.BYTES), LogicalTypes.decimal((int)9, (int)4).addToSchema(Schema.createFixed((String)"t1.fixed", null, null, (int)4))};
        Type[] primitiveTypes = new Type[]{Types.BooleanType.get(), Types.IntType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.get(), Types.StringType.get(), Types.UUIDType.get(), Types.FixedType.getFixed((int)12), Types.BinaryType.get(), Types.DecimalType.get((int)9, (int)4)};
        for (int i = 0; i < primitiveTypes.length; ++i) {
            Type convertPrimitiveResult = AvroInternalSchemaConverter.convertToField((Schema)avroPrimitives[i]);
            Assertions.assertEquals((Object)convertPrimitiveResult, (Object)primitiveTypes[i]);
            Schema convertResult = AvroInternalSchemaConverter.convert((Type)primitiveTypes[i], (String)"t1");
            Assertions.assertEquals((Object)convertResult, (Object)avroPrimitives[i]);
        }
    }

    @Test
    public void testRecordAndPrimitiveTypes() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"bool", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"int", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"long", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"float", (Type)Types.FloatType.get()), Types.Field.get((int)4, (String)"double", (Type)Types.DoubleType.get()), Types.Field.get((int)5, (String)"date", (Type)Types.DateType.get()), Types.Field.get((int)6, (String)"time", (Type)Types.TimeType.get()), Types.Field.get((int)7, (String)"timestamp", (Type)Types.TimestampType.get()), Types.Field.get((int)8, (String)"string", (Type)Types.StringType.get()), Types.Field.get((int)9, (String)"uuid", (Type)Types.UUIDType.get()), Types.Field.get((int)10, (String)"fixed", (Type)Types.FixedType.getFixed((int)10)), Types.Field.get((int)11, (String)"binary", (Type)Types.BinaryType.get()), Types.Field.get((int)12, (String)"decimal", (Type)Types.DecimalType.get((int)10, (int)2))));
        Schema schema = this.create("t1", new Schema.Field("bool", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("int", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("long", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("float", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("double", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("date", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("time", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("timestamp", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("string", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("uuid", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.uuid().addToSchema(Schema.createFixed((String)"t1.uuid.fixed", null, null, (int)16))), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("fixed", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.createFixed((String)"t1.fixed.fixed", null, null, (int)10)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("binary", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.BYTES)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("decimal", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.decimal((int)10, (int)2).addToSchema(Schema.createFixed((String)"t1.decimal.fixed", null, null, (int)5))), null, (Object)JsonProperties.NULL_VALUE));
        Schema convertedSchema = AvroInternalSchemaConverter.convert((Types.RecordType)record, (String)"t1");
        Assertions.assertEquals((Object)convertedSchema, (Object)schema);
        Types.RecordType convertedRecord = AvroInternalSchemaConverter.convert((Schema)schema).getRecord();
        Assertions.assertEquals((Object)convertedRecord, (Object)record);
    }

    private Schema create(String name, Schema.Field ... fields) {
        return Schema.createRecord((String)name, null, null, (boolean)false, Arrays.asList(fields));
    }

    @Test
    public void testArrayType() {
        Types.ArrayType arrayNestRecordType = Types.ArrayType.get((int)0, (boolean)false, (Type)Types.RecordType.get(Arrays.asList(Types.Field.get((int)1, (boolean)false, (String)"a", (Type)Types.FloatType.get()), Types.Field.get((int)2, (boolean)false, (String)"b", (Type)Types.FloatType.get()))));
        Schema schema = (Schema)SchemaBuilder.array().items(this.create("t1", new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.FLOAT), null, null), new Schema.Field("b", Schema.create((Schema.Type)Schema.Type.FLOAT), null, null)));
        Schema convertedSchema = AvroInternalSchemaConverter.convert((Type)arrayNestRecordType, (String)"t1");
        Assertions.assertEquals((Object)convertedSchema, (Object)schema);
        Types.ArrayType convertedRecord = (Types.ArrayType)AvroInternalSchemaConverter.convertToField((Schema)schema);
        Assertions.assertEquals((Object)convertedRecord, (Object)arrayNestRecordType);
    }

    @Test
    public void testComplexConvert() {
        Schema schema = new Schema.Parser().parse(this.schemaStr);
        Types.RecordType recordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)7, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)8, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)13, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)14, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)15, (boolean)false, (String)"y", (Type)Types.LongType.get())}))), Types.Field.get((int)5, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)16, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)6, (boolean)true, (String)"properties", (Type)Types.MapType.get((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        InternalSchema internalSchema = new InternalSchema(recordType);
        Types.RecordType convertRecord = AvroInternalSchemaConverter.convert((Schema)schema).getRecord();
        Assertions.assertEquals((Object)convertRecord, (Object)internalSchema.getRecord());
        Assertions.assertEquals((Object)schema, (Object)AvroInternalSchemaConverter.convert((InternalSchema)internalSchema, (String)"newTableName"));
    }

    @Test
    public void testNullFieldType() {
        Schema schema = this.create("t1", new Schema.Field("nullField", Schema.create((Schema.Type)Schema.Type.NULL), null, (Object)JsonProperties.NULL_VALUE));
        Throwable t = Assertions.assertThrows(HoodieNullSchemaTypeException.class, () -> AvroInternalSchemaConverter.convert((Schema)schema));
        Assertions.assertTrue((boolean)t.getMessage().contains("'t1.nullField'"));
        Schema schemaArray = this.create("t2", new Schema.Field("nullArray", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.NULL)), null, null));
        t = Assertions.assertThrows(HoodieNullSchemaTypeException.class, () -> AvroInternalSchemaConverter.convert((Schema)schemaArray));
        Assertions.assertTrue((boolean)t.getMessage().contains("'t2.nullArray.element'"));
        Schema schemaMap = this.create("t3", new Schema.Field("nullMap", Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.NULL)), null, null));
        t = Assertions.assertThrows(HoodieNullSchemaTypeException.class, () -> AvroInternalSchemaConverter.convert((Schema)schemaMap));
        Assertions.assertTrue((boolean)t.getMessage().contains("'t3.nullMap.value'"));
        Schema schemaComplex = this.create("t4", new Schema.Field("complexField", Schema.createMap((Schema)this.create("nestedStruct", new Schema.Field("nestedArray", Schema.createArray((Schema)Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.NULL))), null, null))), null, null));
        t = Assertions.assertThrows(HoodieNullSchemaTypeException.class, () -> AvroInternalSchemaConverter.convert((Schema)schemaComplex));
        Assertions.assertTrue((boolean)t.getMessage().contains("'t4.nestedStruct.nestedArray.element.value'"));
    }

    @Test
    public void testRefreshNewId() {
        Types.RecordType record = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)4, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)5, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)8, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)9, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false))});
        AtomicInteger newId = new AtomicInteger(100);
        Types.RecordType recordWithNewId = (Types.RecordType)InternalSchemaBuilder.getBuilder().refreshNewId((Type)record, newId);
        Types.RecordType newRecord = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)100, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)101, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)102, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)104, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)105, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)103, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)106, (int)107, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)108, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)109, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false))});
        Assertions.assertEquals((Object)newRecord, (Object)recordWithNewId);
    }

    @Test
    public void testFixNullOrdering() {
        Schema schema = SchemaTestUtil.getSchemaFromResource(TestAvroSchemaEvolutionUtils.class, "/nullWrong.avsc");
        Schema expectedSchema = SchemaTestUtil.getSchemaFromResource(TestAvroSchemaEvolutionUtils.class, "/nullRight.avsc");
        Assertions.assertEquals((Object)expectedSchema, (Object)AvroInternalSchemaConverter.fixNullOrdering((Schema)schema));
        Assertions.assertEquals((Object)expectedSchema, (Object)AvroInternalSchemaConverter.fixNullOrdering((Schema)expectedSchema));
    }

    @Test
    public void testFixNullOrderingSameSchemaCheck() {
        Schema schema = SchemaTestUtil.getSchemaFromResource(TestAvroSchemaEvolutionUtils.class, "/source_evolved.avsc");
        Assertions.assertEquals((Object)schema, (Object)AvroInternalSchemaConverter.fixNullOrdering((Schema)schema));
    }

    @Test
    public void testReWriteRecordWithTypeChanged() {
        String enumSchema = "{\"type\":\"enum\",\"name\":\"Enum\",\"namespace\":\"org.apache.hudi.internal.schema.utils.TestAvroSchemaEvolutionUtils$\",\"symbols\":[\"ENUM1\",\"ENUM2\"]}";
        Schema avroSchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"h0_record\",\"namespace\":\"hoodie.h0\",\"fields\":[{\"name\":\"id\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"comb\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"com1\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"col0\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"col1\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"col11\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"col12\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"col2\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"col21\",\"type\":[\"null\",\"float\"],\"default\":null},{\"name\":\"col3\",\"type\":[\"null\",\"double\"],\"default\":null},{\"name\":\"col31\",\"type\":[\"null\",\"double\"],\"default\":null},{\"name\":\"col4\",\"type\":[\"null\",{\"type\":\"fixed\",\"name\":\"fixed\",\"namespace\":\"hoodie.h0.h0_record.col4\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":4}],\"default\":null},{\"name\":\"col41\",\"type\":[\"null\",{\"type\":\"fixed\",\"name\":\"fixed\",\"namespace\":\"hoodie.h0.h0_record.col41\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":4}],\"default\":null},{\"name\":\"col5\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"col51\",\"type\":[\"null\",\"string\"],\"default\":null},{\"name\":\"col6\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}],\"default\":null},{\"name\":\"col7\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}],\"default\":null},{\"name\":\"col8\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"col9\",\"type\":[\"null\",\"bytes\"],\"default\":null},{\"name\":\"par\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}],\"default\":null},{\"name\":\"enum\",\"type\":[\"null\"," + enumSchema + "],\"default\":null}]}");
        GenericData.Record avroRecord = new GenericData.Record(avroSchema);
        avroRecord.put("id", (Object)1);
        avroRecord.put("comb", (Object)100);
        avroRecord.put("com1", (Object)-100);
        avroRecord.put("col0", (Object)256);
        avroRecord.put("col1", (Object)1000L);
        avroRecord.put("col11", (Object)-100L);
        avroRecord.put("col12", (Object)2000L);
        avroRecord.put("col2", (Object)Float.valueOf(-5.001f));
        avroRecord.put("col21", (Object)Float.valueOf(5.001f));
        avroRecord.put("col3", (Object)12.999);
        avroRecord.put("col31", (Object)9999.999);
        Schema currentDecimalType = (Schema)avroSchema.getField("col4").schema().getTypes().get(1);
        BigDecimal bd = new BigDecimal("123.456").setScale(((LogicalTypes.Decimal)currentDecimalType.getLogicalType()).getScale());
        avroRecord.put("col4", (Object)HoodieAvroUtils.DECIMAL_CONVERSION.toFixed(bd, currentDecimalType, currentDecimalType.getLogicalType()));
        Schema currentDecimalType1 = (Schema)avroSchema.getField("col41").schema().getTypes().get(1);
        BigDecimal bd1 = new BigDecimal("7890.456").setScale(((LogicalTypes.Decimal)currentDecimalType1.getLogicalType()).getScale());
        avroRecord.put("col41", (Object)HoodieAvroUtils.DECIMAL_CONVERSION.toFixed(bd1, currentDecimalType1, currentDecimalType1.getLogicalType()));
        avroRecord.put("col5", (Object)"2011-01-01");
        avroRecord.put("col51", (Object)"199.342");
        avroRecord.put("col6", (Object)18987);
        avroRecord.put("col7", (Object)1640491505000000L);
        avroRecord.put("col8", (Object)false);
        ByteBuffer bb = ByteBuffer.wrap(new byte[]{97, 48, 53});
        avroRecord.put("col9", (Object)bb);
        avroRecord.put("enum", (Object)new GenericData.EnumSymbol(new Schema.Parser().parse(enumSchema), (Object)Enum.ENUM1));
        Assertions.assertEquals((Object)GenericData.get().validate(avroSchema, (Object)avroRecord), (Object)true);
        InternalSchema internalSchema = AvroInternalSchemaConverter.convert((Schema)avroSchema);
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get((InternalSchema)internalSchema);
        updateChange.updateColumnType("id", (Type)Types.LongType.get()).updateColumnType("comb", (Type)Types.FloatType.get()).updateColumnType("com1", (Type)Types.DoubleType.get()).updateColumnType("col0", (Type)Types.StringType.get()).updateColumnType("col1", (Type)Types.FloatType.get()).updateColumnType("col11", (Type)Types.DoubleType.get()).updateColumnType("col12", (Type)Types.StringType.get()).updateColumnType("col2", (Type)Types.DoubleType.get()).updateColumnType("col21", (Type)Types.StringType.get()).updateColumnType("col3", (Type)Types.StringType.get()).updateColumnType("col31", (Type)Types.DecimalType.get((int)18, (int)9)).updateColumnType("col4", (Type)Types.DecimalType.get((int)18, (int)9)).updateColumnType("col41", (Type)Types.StringType.get()).updateColumnType("col5", (Type)Types.DateType.get()).updateColumnType("col51", (Type)Types.DecimalType.get((int)18, (int)9)).updateColumnType("col6", (Type)Types.StringType.get()).updateColumnType("enum", (Type)Types.StringType.get());
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)internalSchema, (TableChanges.ColumnUpdateChange)updateChange);
        Schema newAvroSchema = AvroInternalSchemaConverter.convert((InternalSchema)newSchema, (String)avroSchema.getFullName());
        GenericRecord newRecord = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)avroRecord, (Schema)newAvroSchema, Collections.emptyMap());
        Assertions.assertEquals((Object)"ENUM1", (Object)newRecord.get("enum"));
        Assertions.assertEquals((Object)GenericData.get().validate(newAvroSchema, (Object)newRecord), (Object)true);
    }

    @Test
    public void testReWriteNestRecord() {
        Types.RecordType record = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)7, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)4, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)8, (int)9, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)10, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)11, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false))});
        Schema schema = AvroInternalSchemaConverter.convert((Types.RecordType)record, (String)"test1");
        GenericData.Record avroRecord = new GenericData.Record(schema);
        GenericData.get().validate(schema, (Object)avroRecord);
        avroRecord.put("id", (Object)2);
        avroRecord.put("data", (Object)"xs");
        GenericData.Record preferencesRecord = new GenericData.Record(AvroInternalSchemaConverter.convert((Type)record.fieldType("preferences"), (String)"test1.preferences"));
        preferencesRecord.put("feature1", (Object)false);
        preferencesRecord.put("feature2", (Object)true);
        Assertions.assertEquals((Object)GenericData.get().validate(AvroInternalSchemaConverter.convert((Type)record.fieldType("preferences"), (String)"test1.preferences"), (Object)preferencesRecord), (Object)true);
        avroRecord.put("preferences", (Object)preferencesRecord);
        HashMap<String, GenericData.Record> locations = new HashMap<String, GenericData.Record>();
        Schema mapSchema = AvroInternalSchemaConverter.convert((Type)((Types.MapType)record.fieldByNameCaseInsensitive("locations").type()).valueType(), (String)"test1.locations");
        GenericData.Record locationsValue = new GenericData.Record(mapSchema);
        locationsValue.put("lat", (Object)Float.valueOf(1.2f));
        locationsValue.put("long", (Object)Float.valueOf(1.4f));
        GenericData.Record locationsValue1 = new GenericData.Record(mapSchema);
        locationsValue1.put("lat", (Object)Float.valueOf(2.2f));
        locationsValue1.put("long", (Object)Float.valueOf(2.4f));
        locations.put("key1", locationsValue);
        locations.put("key2", locationsValue1);
        avroRecord.put("locations", locations);
        ArrayList<Double> doubles = new ArrayList<Double>();
        doubles.add(2.0);
        doubles.add(3.0);
        avroRecord.put("doubles", doubles);
        Assertions.assertTrue((boolean)GenericData.get().validate(schema, (Object)avroRecord));
        Types.RecordType newRecord = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)5, (boolean)true, (String)"featurex", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)7, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)4, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)8, (int)9, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)10, (boolean)true, (String)"laty", (Type)Types.FloatType.get()), Types.Field.get((int)11, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false))});
        Schema newAvroSchema = AvroInternalSchemaConverter.convert((Types.RecordType)newRecord, (String)schema.getName());
        GenericRecord newAvroRecord = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)avroRecord, (Schema)newAvroSchema, Collections.emptyMap());
        Assertions.assertEquals((Object)GenericData.get().validate(newAvroSchema, (Object)newAvroRecord), (Object)true);
        InternalSchema internalSchema = AvroInternalSchemaConverter.convert((Schema)schema);
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get((InternalSchema)internalSchema);
        updateChange.renameColumn("id", "idx").renameColumn("data", "datax").renameColumn("preferences.feature1", "f1").renameColumn("preferences.feature2", "f2").renameColumn("locations.value.lat", "lt");
        InternalSchema internalSchemaRename = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)internalSchema, (TableChanges.ColumnUpdateChange)updateChange);
        Schema avroSchemaRename = AvroInternalSchemaConverter.convert((InternalSchema)internalSchemaRename, (String)schema.getFullName());
        Map renameCols = InternalSchemaUtils.collectRenameCols((InternalSchema)internalSchema, (InternalSchema)internalSchemaRename);
        GenericRecord avroRecordRename = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)avroRecord, (Schema)avroSchemaRename, (Map)renameCols);
        Assertions.assertEquals((Object)GenericData.get().validate(avroSchemaRename, (Object)avroRecordRename), (Object)true);
    }

    @Test
    public void testEvolutionSchemaFromNewAvroSchema() {
        Types.RecordType oldRecord = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"featurex", (Type)Types.BooleanType.get()), Types.Field.get((int)7, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)8, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)4, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"laty", (Type)Types.FloatType.get()), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false))});
        InternalSchema oldSchema = new InternalSchema(oldRecord);
        Types.RecordType evolvedRecord = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)5, (boolean)true, (String)"featurex", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get()), Types.Field.get((int)5, (boolean)true, (String)"feature3", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)7, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)4, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)8, (int)9, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)10, (boolean)false, (String)"laty", (Type)Types.FloatType.get()), Types.Field.get((int)11, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)0, (boolean)false, (String)"add1", (Type)Types.IntType.get()), Types.Field.get((int)2, (boolean)true, (String)"addStruct", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"nest1", (Type)Types.BooleanType.get()), Types.Field.get((int)5, (boolean)true, (String)"nest2", (Type)Types.BooleanType.get())}))});
        evolvedRecord = (Types.RecordType)InternalSchemaBuilder.getBuilder().refreshNewId((Type)evolvedRecord, new AtomicInteger(0));
        Schema evolvedAvroSchema = AvroInternalSchemaConverter.convert((Types.RecordType)evolvedRecord, (String)"test1");
        InternalSchema result = AvroSchemaEvolutionUtils.reconcileSchema((Schema)evolvedAvroSchema, (InternalSchema)oldSchema, (boolean)false);
        Types.RecordType checkedRecord = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"featurex", (Type)Types.BooleanType.get()), Types.Field.get((int)7, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get()), Types.Field.get((int)17, (boolean)true, (String)"feature3", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)8, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)4, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"laty", (Type)Types.FloatType.get()), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)13, (boolean)true, (String)"add1", (Type)Types.IntType.get()), Types.Field.get((int)14, (boolean)true, (String)"addStruct", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)15, (boolean)false, (String)"nest1", (Type)Types.BooleanType.get()), Types.Field.get((int)16, (boolean)true, (String)"nest2", (Type)Types.BooleanType.get())}))});
        Assertions.assertEquals((Object)result.getRecord(), (Object)checkedRecord);
    }

    @Test
    public void testReconcileSchema() {
        Schema schema = this.create("simple", new Schema.Field("a", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("b", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.INT)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("c", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("d", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)JsonProperties.NULL_VALUE));
        Schema incomingSchema = this.create("simpleIncoming", new Schema.Field("a", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("a1", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("c", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("c1", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("c2", AvroInternalSchemaConverter.nullableSchema((Schema)Schema.create((Schema.Type)Schema.Type.LONG)), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("d", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("d1", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)JsonProperties.NULL_VALUE), new Schema.Field("d2", AvroInternalSchemaConverter.nullableSchema((Schema)LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)JsonProperties.NULL_VALUE));
        Schema simpleCheckSchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"simple\",\"fields\":[{\"name\":\"a\",\"type\":[\"null\",\"boolean\"],\"default\":null},{\"name\":\"b\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"c\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"d\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}],\"default\":null},{\"name\":\"a1\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"c1\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"c2\",\"type\":[\"null\",\"long\"],\"default\":null},{\"name\":\"d1\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}],\"default\":null},{\"name\":\"d2\",\"type\":[\"null\",{\"type\":\"int\",\"logicalType\":\"date\"}],\"default\":null}]}");
        Schema simpleReconcileSchema = AvroInternalSchemaConverter.convert((InternalSchema)AvroSchemaEvolutionUtils.reconcileSchema((Schema)incomingSchema, (InternalSchema)AvroInternalSchemaConverter.convert((Schema)schema), (boolean)false), (String)"schemaNameFallback");
        Assertions.assertEquals((Object)simpleCheckSchema, (Object)simpleReconcileSchema);
    }

    public static enum Enum {
        ENUM1,
        ENUM2;

    }
}

