/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestMetrics {
    private final HoodieStorage hoodieStorage = (HoodieStorage)Mockito.mock(HoodieStorage.class);

    TestMetrics() {
    }

    @Test
    void metricsInstanceCached() {
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/tmp/path1").withReporterType("INMEMORY").build();
        Metrics metrics1 = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)this.hoodieStorage);
        Metrics metrics2 = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)this.hoodieStorage);
        Assertions.assertSame((Object)metrics1, (Object)metrics2);
        metrics1.shutdown();
    }

    @Test
    void recreateMetricsForBasePath() {
        String path = "/tmp/path2";
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath(path).withReporterType("INMEMORY").build();
        Metrics metrics1 = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)this.hoodieStorage);
        metrics1.shutdown();
        Assertions.assertFalse((boolean)Metrics.isInitialized((String)path));
        Metrics metrics2 = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)this.hoodieStorage);
        Assertions.assertTrue((boolean)Metrics.isInitialized((String)path));
        Assertions.assertNotSame((Object)metrics1, (Object)metrics2);
    }
}

