/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.timeline.TimelineServiceClient;
import org.apache.hudi.timeline.TimelineServiceClientBase;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestTimelineServiceClient {
    private static final String TEST_ENDPOINT = "/test-endpoint";
    private static final int DEFAULT_READ_TIMEOUT_SECS = 5;
    private static final boolean DEFAULT_HTTP_RESPONSE = true;
    private Server server;
    private int serverPort;

    TestTimelineServiceClient() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.server = new Server(0);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new TestServlet()), TEST_ENDPOINT);
        this.server.start();
        this.serverPort = this.server.getURI().getPort();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testSuccessfulGetRequest() throws IOException {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(this.serverPort)).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(5));
        MockTimelineServiceNetworkClient client = new MockTimelineServiceNetworkClient(builder.build());
        TimelineServiceClientBase.Request request = TimelineServiceClientBase.Request.newBuilder((TimelineServiceClientBase.RequestMethod)TimelineServiceClientBase.RequestMethod.GET, (String)TEST_ENDPOINT).build();
        TimelineServiceClientBase.Response response = client.makeRequest(request);
        Assertions.assertEquals((Object)true, (Object)response.getDecodedContent((TypeReference)new TypeReference<Boolean>(){}));
    }

    @Test
    public void testSuccessfulPostRequest() throws IOException {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(this.serverPort)).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(5));
        MockTimelineServiceNetworkClient client = new MockTimelineServiceNetworkClient(builder.build());
        TimelineServiceClientBase.Request request = TimelineServiceClientBase.Request.newBuilder((TimelineServiceClientBase.RequestMethod)TimelineServiceClientBase.RequestMethod.POST, (String)TEST_ENDPOINT).addQueryParam("key1", "val1").addQueryParams(Collections.singletonMap("key2", "val2")).build();
        TimelineServiceClientBase.Response response = client.makeRequest(request);
        Assertions.assertEquals((Object)true, (Object)response.getDecodedContent((TypeReference)new TypeReference<Boolean>(){}));
    }

    private static List<Arguments> testScenariosForFailures() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{5, 2, InducedFailuresInfo.ExceptionType.NO_HTTP_RESPONSE_EXCEPTION, true}), Arguments.of((Object[])new Object[]{5, 2, InducedFailuresInfo.ExceptionType.PARSE_EXCEPTION, true}), Arguments.of((Object[])new Object[]{2, 5, InducedFailuresInfo.ExceptionType.NO_HTTP_RESPONSE_EXCEPTION, false}), Arguments.of((Object[])new Object[]{2, 5, InducedFailuresInfo.ExceptionType.PARSE_EXCEPTION, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"testScenariosForFailures"})
    public void testRetriesForExceptions(int numberOfRetries, int numberOfInducedFailures, InducedFailuresInfo.ExceptionType exceptionType, boolean shouldSucceed) throws IOException {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(this.serverPort)).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(5)).withRemoteTimelineClientRetry(true).withRemoteTimelineClientMaxRetryIntervalMs(Long.valueOf(2000L)).withRemoteTimelineClientMaxRetryNumbers(Integer.valueOf(numberOfRetries));
        InducedFailuresInfo inducedFailuresInfo = new InducedFailuresInfo(exceptionType, numberOfInducedFailures);
        MockTimelineServiceNetworkClient client = new MockTimelineServiceNetworkClient(builder.build(), (Option<InducedFailuresInfo>)Option.of((Object)inducedFailuresInfo));
        TimelineServiceClientBase.Request request = TimelineServiceClientBase.Request.newBuilder((TimelineServiceClientBase.RequestMethod)TimelineServiceClientBase.RequestMethod.GET, (String)TEST_ENDPOINT).build();
        if (shouldSucceed) {
            TimelineServiceClientBase.Response response = client.makeRequest(request);
            Assertions.assertEquals((Object)true, (Object)response.getDecodedContent((TypeReference)new TypeReference<Boolean>(){}));
        } else {
            Class<? extends Exception> expectedException = exceptionType.getExceptionType();
            Assertions.assertThrows(expectedException, () -> client.makeRequest(request), (String)"Should throw an Exception.'");
        }
    }

    private static class TestServlet
    extends HttpServlet {
        private TestServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.sendResponse(req, resp);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.sendResponse(req, resp);
        }

        private void sendResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.setContentType("text/plain");
            resp.setStatus(200);
            ObjectMapper objectMapper = new ObjectMapper();
            resp.getWriter().println(objectMapper.writeValueAsString((Object)true));
        }
    }

    private static class InducedFailuresInfo {
        private final ExceptionType exceptionType;
        private final int maxInducedFailures;

        public InducedFailuresInfo(ExceptionType exceptionType, int maxInducedFailures) {
            this.exceptionType = exceptionType;
            this.maxInducedFailures = maxInducedFailures;
        }

        public static enum ExceptionType {
            NO_HTTP_RESPONSE_EXCEPTION(NoHttpResponseException.class),
            PARSE_EXCEPTION(ParseException.class);

            private final Class<? extends Exception> exceptionType;

            private ExceptionType(Class<? extends Exception> exceptionType) {
                this.exceptionType = exceptionType;
            }

            public Class<? extends Exception> getExceptionType() {
                return this.exceptionType;
            }
        }
    }

    private static class MockTimelineServiceNetworkClient
    extends TimelineServiceClient {
        private final Option<InducedFailuresInfo> inducedFailuresInfo;
        private int currentInducedFailures;

        public MockTimelineServiceNetworkClient(FileSystemViewStorageConfig config) {
            this(config, (Option<InducedFailuresInfo>)Option.empty());
        }

        public MockTimelineServiceNetworkClient(FileSystemViewStorageConfig config, Option<InducedFailuresInfo> inducedFailuresInfo) {
            super(config);
            this.inducedFailuresInfo = inducedFailuresInfo;
            this.currentInducedFailures = 0;
        }

        protected TimelineServiceClientBase.Response executeRequest(TimelineServiceClientBase.Request request) throws IOException {
            if (this.inducedFailuresInfo.isPresent() && ++this.currentInducedFailures <= ((InducedFailuresInfo)this.inducedFailuresInfo.get()).maxInducedFailures) {
                switch (((InducedFailuresInfo)this.inducedFailuresInfo.get()).exceptionType) {
                    case PARSE_EXCEPTION: {
                        throw new ParseException("Parse Exception");
                    }
                }
                throw new NoHttpResponseException("No HTTP Response Exception");
            }
            return super.executeRequest(request);
        }
    }
}

