/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.Option;

public class FileSlice
implements Serializable {
    private final HoodieFileGroupId fileGroupId;
    private final String baseInstantTime;
    private HoodieBaseFile baseFile;
    private final TreeSet<HoodieLogFile> logFiles;

    public FileSlice(FileSlice fileSlice) {
        this(fileSlice, true);
    }

    private FileSlice(FileSlice fileSlice, boolean includeLogFiles) {
        this.baseInstantTime = fileSlice.baseInstantTime;
        this.baseFile = fileSlice.baseFile != null ? new HoodieBaseFile(fileSlice.baseFile) : null;
        this.fileGroupId = fileSlice.fileGroupId;
        this.logFiles = new TreeSet<HoodieLogFile>(HoodieLogFile.getReverseLogFileComparator());
        if (includeLogFiles) {
            fileSlice.logFiles.forEach(lf -> this.logFiles.add(new HoodieLogFile((HoodieLogFile)lf)));
        }
    }

    public FileSlice(String partitionPath, String baseInstantTime, String fileId) {
        this(new HoodieFileGroupId(partitionPath, fileId), baseInstantTime);
    }

    public FileSlice(HoodieFileGroupId fileGroupId, String baseInstantTime) {
        this.fileGroupId = fileGroupId;
        this.baseInstantTime = baseInstantTime;
        this.baseFile = null;
        this.logFiles = new TreeSet<HoodieLogFile>(HoodieLogFile.getReverseLogFileComparator());
    }

    public FileSlice(HoodieFileGroupId fileGroupId, String baseInstantTime, HoodieBaseFile baseFile, List<HoodieLogFile> logFiles) {
        this.fileGroupId = fileGroupId;
        this.baseInstantTime = baseInstantTime;
        this.baseFile = baseFile;
        this.logFiles = new TreeSet<HoodieLogFile>(HoodieLogFile.getReverseLogFileComparator());
        this.logFiles.addAll(logFiles);
    }

    public void setBaseFile(HoodieBaseFile baseFile) {
        this.baseFile = baseFile;
    }

    public void addLogFile(HoodieLogFile logFile) {
        this.logFiles.add(logFile);
    }

    public FileSlice withLogFiles(boolean includeLogFiles) {
        if (includeLogFiles || !this.hasLogFiles()) {
            return this;
        }
        return new FileSlice(this, false);
    }

    public boolean hasBootstrapBase() {
        return this.getBaseFile().isPresent() && ((HoodieBaseFile)this.getBaseFile().get()).getBootstrapBaseFile().isPresent();
    }

    public boolean hasLogFiles() {
        return !this.logFiles.isEmpty();
    }

    public Stream<HoodieLogFile> getLogFiles() {
        return this.logFiles.stream();
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public String getPartitionPath() {
        return this.fileGroupId.getPartitionPath();
    }

    public String getFileId() {
        return this.fileGroupId.getFileId();
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.fileGroupId;
    }

    public Option<HoodieBaseFile> getBaseFile() {
        return Option.ofNullable((Object)this.baseFile);
    }

    public Option<HoodieLogFile> getLatestLogFile() {
        return Option.fromJavaOptional(this.logFiles.stream().findFirst());
    }

    public long getTotalFileSize() {
        return (Long)this.getBaseFile().map(BaseFile::getFileSize).orElse((Object)0L) + this.getLogFiles().mapToLong(HoodieLogFile::getFileSize).sum();
    }

    public String getLatestInstantTime() {
        Option latestDeltaCommitTime = this.getLatestLogFile().map(HoodieLogFile::getDeltaCommitTime);
        return latestDeltaCommitTime.isPresent() ? InstantComparison.maxInstant((String)latestDeltaCommitTime.get(), this.getBaseInstantTime()) : this.getBaseInstantTime();
    }

    public boolean isEmpty() {
        return this.baseFile == null && this.logFiles.isEmpty();
    }

    public String toString() {
        return "FileSlice {fileGroupId=" + this.fileGroupId + ", baseCommitTime=" + this.baseInstantTime + ", baseFile='" + this.baseFile + '\'' + ", logFiles='" + this.logFiles + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSlice slice = (FileSlice)o;
        return Objects.equals(this.fileGroupId, slice.fileGroupId) && Objects.equals(this.baseInstantTime, slice.baseInstantTime) && Objects.equals(this.baseFile, slice.baseFile) && Objects.equals(this.logFiles, slice.logFiles);
    }

    public int hashCode() {
        return Objects.hash(this.fileGroupId, this.baseInstantTime);
    }
}

