/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.TimelineDTO;
import org.apache.hudi.common.util.ValidationUtils;

public class DTOUtils {
    public static List<FileGroupDTO> fileGroupDTOsfromFileGroups(List<HoodieFileGroup> fileGroups) {
        if (fileGroups.isEmpty()) {
            return Collections.emptyList();
        }
        if (fileGroups.size() == 1) {
            return Collections.singletonList(FileGroupDTO.fromFileGroup(fileGroups.get(0), true));
        }
        ArrayList<FileGroupDTO> fileGroupDTOS = new ArrayList<FileGroupDTO>(fileGroups.size());
        fileGroupDTOS.add(FileGroupDTO.fromFileGroup(fileGroups.get(0), true));
        fileGroupDTOS.addAll(fileGroups.stream().skip(1L).map(fg -> FileGroupDTO.fromFileGroup(fg, false)).collect(Collectors.toList()));
        return fileGroupDTOS;
    }

    public static Stream<HoodieFileGroup> fileGroupDTOsToFileGroups(List<FileGroupDTO> dtos, HoodieTableMetaClient metaClient) {
        if (dtos.isEmpty()) {
            return Stream.empty();
        }
        ValidationUtils.checkState((dtos.get((int)0).timeline != null ? 1 : 0) != 0, (String)"Timeline is expected to be set for the first FileGroupDTO");
        HoodieTimeline timeline = TimelineDTO.toTimeline(dtos.get((int)0).timeline, metaClient);
        return dtos.stream().map(dto -> FileGroupDTO.toFileGroup(dto, timeline));
    }
}

