/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.ArchivedTimelineLoaderV1;
import org.apache.hudi.common.table.timeline.versioning.v1.BaseTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivedTimelineV1
extends BaseTimelineV1
implements HoodieArchivedTimeline,
HoodieInstantReader {
    private static final String HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX = "commits";
    private static final String ACTION_TYPE_KEY = "actionType";
    private static final String ACTION_STATE = "actionState";
    private static final String STATE_TRANSITION_TIME = "stateTransitionTime";
    private HoodieTableMetaClient metaClient;
    private final Map<String, Map<HoodieInstant.State, byte[]>> readCommits = new HashMap<String, Map<HoodieInstant.State, byte[]>>();
    private final ArchivedTimelineLoaderV1 timelineLoader = new ArchivedTimelineLoaderV1();
    private static final Logger LOG = LoggerFactory.getLogger(HoodieArchivedTimeline.class);

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(false));
    }

    private ArchivedTimelineV1(HoodieTableMetaClient metaClient, HoodieArchivedTimeline.TimeRangeFilter timeRangeFilter) {
        this(metaClient, timeRangeFilter, null, (Option<HoodieInstant.State>)Option.of((Object)((Object)HoodieInstant.State.COMPLETED)));
    }

    private ArchivedTimelineV1(HoodieTableMetaClient metaClient, HoodieArchivedTimeline.TimeRangeFilter timeRangeFilter, Option<HoodieInstant.State> state) {
        this(metaClient, timeRangeFilter, null, state);
    }

    private ArchivedTimelineV1(HoodieTableMetaClient metaClient, HoodieArchivedTimeline.TimeRangeFilter timeRangeFilter, LogFileFilter logFileFilter, Option<HoodieInstant.State> state) {
        this.metaClient = metaClient;
        Function<GenericRecord, Boolean> commitsFilter = state.isPresent() ? record -> ((HoodieInstant.State)((Object)((Object)state.get()))).toString().equals(record.get(ACTION_STATE).toString()) : record -> true;
        this.setInstants(this.loadInstants(timeRangeFilter, logFileFilter, true, commitsFilter));
    }

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient, String startTs) {
        this(metaClient, new HoodieArchivedTimeline.StartTsFilter(startTs));
    }

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient, String startTs, String endTs) {
        this(metaClient, new HoodieArchivedTimeline.ClosedClosedTimeRangeFilter(startTs, endTs));
    }

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient, String startTs, String endTs, Option<HoodieInstant.State> state) {
        this(metaClient, new HoodieArchivedTimeline.ClosedClosedTimeRangeFilter(startTs, endTs), state);
    }

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient, Set<String> logFiles) {
        this(metaClient, null, new LogFileFilter(logFiles), (Option<HoodieInstant.State>)Option.of((Object)((Object)HoodieInstant.State.COMPLETED)));
    }

    public ArchivedTimelineV1(HoodieTableMetaClient metaClient, Set<String> logFiles, Option<HoodieInstant.State> state) {
        this(metaClient, null, new LogFileFilter(logFiles), state);
    }

    public ArchivedTimelineV1() {
    }

    @Override
    public HoodieInstantReader getInstantReader() {
        return this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return Option.ofNullable(((Map)this.readCommits.getOrDefault(instant.requestedTime(), new HashMap())).get((Object)instant.getState()));
    }

    @Override
    public InputStream getContentStream(HoodieInstant instant) {
        Option<InputStream> stream = TimelineUtils.getInputStreamOptionLegacy(this, instant);
        if (stream.isEmpty()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return (InputStream)stream.get();
    }

    public static StoragePath getArchiveLogPath(StoragePath archiveFolder) {
        return new StoragePath(archiveFolder, HOODIE_COMMIT_ARCHIVE_LOG_FILE_PREFIX);
    }

    @Override
    public void loadInstantDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(startTs, endTs);
    }

    @Override
    public void loadCompletedInstantDetailsInMemory() {
        this.loadInstants(null, null, true, record -> {
            Object action = record.get(ACTION_STATE);
            return action == null || HoodieInstant.State.COMPLETED.toString().equals(action.toString());
        });
    }

    @Override
    public void loadCompactionDetailsInMemory(String compactionInstantTime) {
        this.loadCompactionDetailsInMemory(compactionInstantTime, compactionInstantTime);
    }

    @Override
    public void loadCompactionDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(new HoodieArchivedTimeline.ClosedClosedTimeRangeFilter(startTs, endTs), null, true, record -> {
            Object action = record.get(ACTION_STATE);
            return record.get(ACTION_TYPE_KEY).toString().equals("compaction") && (action == null || HoodieInstant.State.INFLIGHT.toString().equals(action.toString()));
        });
    }

    @Override
    public void clearInstantDetailsFromMemory(String instantTime) {
        this.readCommits.remove(instantTime);
    }

    @Override
    public void clearInstantDetailsFromMemory(String startTs, String endTs) {
        this.findInstantsInRange(startTs, endTs).getInstants().forEach(instant -> this.readCommits.remove(instant.requestedTime()));
    }

    private List<HoodieInstant> loadInstants(boolean loadInstantDetails) {
        return this.loadInstants(null, loadInstantDetails);
    }

    private List<HoodieInstant> loadInstants(String startTs, String endTs) {
        return this.loadInstants(new HoodieArchivedTimeline.TimeRangeFilter(startTs, endTs), true);
    }

    private List<HoodieInstant> loadInstants(HoodieArchivedTimeline.TimeRangeFilter filter, boolean loadInstantDetails) {
        return this.loadInstants(filter, null, loadInstantDetails, genericRecord -> true);
    }

    private List<HoodieInstant> loadInstants(HoodieArchivedTimeline.TimeRangeFilter filter, LogFileFilter logFileFilter, boolean loadInstantDetails, Function<GenericRecord, Boolean> commitsFilter) {
        InstantsLoader loader = new InstantsLoader(loadInstantDetails);
        this.timelineLoader.loadInstants(this.metaClient, filter, (Option<LogFileFilter>)Option.ofNullable((Object)logFileFilter), HoodieArchivedTimeline.LoadMode.PLAN, commitsFilter, loader);
        return loader.getInstantsInRangeCollected().values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    private Option<HoodieInstant> readCommit(String instantTime, GenericRecord record, boolean loadDetails, HoodieArchivedTimeline.TimeRangeFilter timeRangeFilter) {
        String action = record.get(ACTION_TYPE_KEY).toString();
        String stateTransitionTime = (String)record.get(STATE_TRANSITION_TIME);
        HoodieInstant hoodieInstant = new HoodieInstant(HoodieInstant.State.valueOf(record.get(ACTION_STATE).toString()), action, instantTime, stateTransitionTime, InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        if (timeRangeFilter != null && !timeRangeFilter.isInRange(hoodieInstant.requestedTime())) {
            return Option.empty();
        }
        if (loadDetails) {
            ArchivedTimelineV1.getMetadataKey(hoodieInstant).map(key -> {
                Object actionData = record.get(key);
                if (actionData != null) {
                    this.readCommits.computeIfAbsent(instantTime, k -> new HashMap());
                    if (action.equals("compaction")) {
                        this.readCommits.get(instantTime).put(hoodieInstant.getState(), HoodieAvroUtils.avroToBytes((IndexedRecord)actionData));
                    } else {
                        this.readCommits.get(instantTime).put(hoodieInstant.getState(), actionData.toString().getBytes(StandardCharsets.UTF_8));
                    }
                }
                return null;
            });
        }
        return Option.of((Object)hoodieInstant);
    }

    @Nonnull
    private static Option<String> getMetadataKey(HoodieInstant instant) {
        switch (instant.getAction()) {
            case "clean": {
                return Option.of((Object)"hoodieCleanMetadata");
            }
            case "commit": 
            case "deltacommit": {
                return Option.of((Object)"hoodieCommitMetadata");
            }
            case "rollback": {
                return Option.of((Object)"hoodieRollbackMetadata");
            }
            case "savepoint": {
                return Option.of((Object)"hoodieSavePointMetadata");
            }
            case "compaction": 
            case "logcompaction": {
                return Option.of((Object)"hoodieCompactionPlan");
            }
            case "replacecommit": {
                if (instant.isRequested()) {
                    return Option.of((Object)"hoodieRequestedReplaceMetadata");
                }
                return Option.of((Object)"hoodieReplaceCommitMetadata");
            }
            case "indexing": {
                return Option.of((Object)"hoodieIndexCommitMetadata");
            }
        }
        LOG.error(String.format("Unknown action in metadata (%s)", instant.getAction()));
        return Option.empty();
    }

    @Override
    public HoodieArchivedTimeline reload() {
        return new ArchivedTimelineV1(this.metaClient);
    }

    @Override
    public HoodieArchivedTimeline reload(String startTs) {
        return new ArchivedTimelineV1(this.metaClient, startTs);
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return this.getInstantDetails(instant).isEmpty();
    }

    static class LogFileFilter {
        private final Set<String> logFiles;

        public LogFileFilter(Set<String> logFiles) {
            this.logFiles = logFiles;
        }

        public boolean shouldLoadFile(StoragePathInfo storagePathInfo) {
            return this.logFiles.contains(storagePathInfo.getPath().toString());
        }
    }

    public class InstantsLoader
    implements BiConsumer<String, GenericRecord> {
        private final Map<String, List<HoodieInstant>> instantsInRange = new ConcurrentHashMap<String, List<HoodieInstant>>();
        private final boolean loadInstantDetails;

        private InstantsLoader(boolean loadInstantDetails) {
            this.loadInstantDetails = loadInstantDetails;
        }

        @Override
        public void accept(String instantTime, GenericRecord record) {
            Option instant = ArchivedTimelineV1.this.readCommit(instantTime, record, this.loadInstantDetails, null);
            if (instant.isPresent()) {
                this.instantsInRange.computeIfAbsent(((HoodieInstant)instant.get()).requestedTime(), s -> new ArrayList()).add(instant.get());
            }
        }

        public Map<String, List<HoodieInstant>> getInstantsInRangeCollected() {
            return this.instantsInRange;
        }
    }
}

